/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.xpath;

import java.io.StringWriter;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.compiler.XPathSourceGenerator;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lib.XPathExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathLiteralGenerator {
    @Nullable
    Map<String, URI> currentNameSpaces;
    @NotNull
    final XPathSourceGenerator generator;

    public XPathLiteralGenerator(@NotNull Set<XPathVariable> scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathLiteralGenerator.<init> must not be null");
        }
        this.generator = new XPathSourceGenerator(XPathLiteralGenerator.buildScopeMap(scope));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String makeLiteral(String literal) {
        String string = XPathSourceGenerator.makeString(literal);
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathLiteralGenerator.makeLiteral must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public XPathExpression makeXMLLiteral(String literal) {
        XPathSourceGenerator sg = this.generator;
        StringWriter sw = new StringWriter();
        sg.init(sw, false, this.currentNameSpaces);
        sg.makeXMLLiteral(literal);
        XPathExpression xPathExpression = new XPathExpression(sw.toString(), sg.getNsMap());
        if (xPathExpression == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathLiteralGenerator.makeXMLLiteral must not return null");
        }
        return xPathExpression;
    }

    public void setCurrentNameSpaces(@Nullable Map<String, URI> nameSpaces) {
        this.currentNameSpaces = nameSpaces != null && nameSpaces.isEmpty() ? null : CollectionUtils.immutableMap(nameSpaces);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Map<String, XPathVariable> buildScopeMap(@NotNull Set<XPathVariable> scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathLiteralGenerator.buildScopeMap must not be null");
        }
        Map<String, XPathVariable> result = CollectionUtils.hashMap(scope.size());
        for (XPathVariable variable : scope) {
            result.put(variable.getName(), variable);
        }
        Map<String, XPathVariable> map = result;
        if (map == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathLiteralGenerator.buildScopeMap must not return null");
        }
        return map;
    }
}

