/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.xpath;

import fuego.parser.CharScanner;
import fuego.parser.CharStreamException;
import fuego.parser.LexerSharedInputState;
import fuego.parser.Token;
import fuego.parser.TokenStream;
import fuego.parser.TokenStreamException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.compiler.xpath.NamespaceResolver;
import oracle.bpm.compiler.xpath.SimpleXPathLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class XPathLexer
implements TokenStream {
    @Nullable
    private Token nextToken;
    @NotNull
    private final Set<String> nodeTypes = XPathLexer.buildNodeTypes();
    @Nullable
    private Token prevToken;
    @NotNull
    private final CharScanner simpleLexer = new SimpleXPathLexer((LexerSharedInputState)null);

    XPathLexer() {
    }

    public Token nextToken() throws TokenStreamException {
        try {
            return this.innerNextToken();
        }
        catch (TokenStreamException e) {
            this.consume();
            throw e;
        }
    }

    static NamespaceResolver asResolver(final Map<String, URI> namespaces) {
        return new NamespaceResolver(){

            @Override
            @Nullable
            public String findNamespaceURI(@NotNull String prefix) {
                URI uri = (URI)namespaces.get(prefix);
                return uri == null ? null : uri.toString();
            }
        };
    }

    void setInputString(String expression) {
        this.clear();
        this.simpleLexer.setInputState(new LexerSharedInputState((Reader)new StringReader(expression)));
    }

    void clear() {
        this.prevToken = null;
        this.nextToken = null;
        this.simpleLexer.setInputState(null);
    }

    private static boolean isOperatorName(int token) {
        switch (token) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Set<String> buildNodeTypes() {
        Set<String> set = CollectionUtils.immutableSet(Arrays.asList("comment", "text", "processing-instruction", "node"));
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathLexer.buildNodeTypes must not return null");
        }
        return set;
    }

    private Token innerNextToken() throws TokenStreamException {
        Token token = this.getNextToken();
        this.checkSpecialRule1(token);
        this.checkSpecialRule2(token);
        this.checkSpecialRule3(token);
        if (token.getType() == 37) {
            token.setType(13);
        }
        this.prevToken = token;
        return token;
    }

    private void consume() {
        try {
            this.simpleLexer.consume();
        }
        catch (CharStreamException charStreamException) {
            // empty catch block
        }
    }

    private boolean isSpecialRule1() {
        Token prev = this.prevToken;
        if (prev == null) {
            return false;
        }
        int type = prev.getType();
        switch (type) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return false;
            }
        }
        return !XPathLexer.isOperatorName(type);
    }

    private void checkSpecialRule1(Token token) {
        if (!this.isSpecialRule1()) {
            int tokenType = token.getType();
            if (tokenType == 22) {
                token.setType(13);
            } else if (XPathLexer.isOperatorName(tokenType)) {
                token.setType(37);
            }
        }
    }

    private void checkSpecialRule2(Token token) throws TokenStreamException {
        if (token.getType() == 37 && this.lookAhead() == 24) {
            String text = token.getText();
            if (this.nodeTypes.contains(text)) {
                token.setType(8);
            } else {
                token.setType(9);
            }
        }
    }

    private int lookAhead() throws TokenStreamException {
        return this.peekNextToken().getType();
    }

    private void checkSpecialRule3(Token token) throws TokenStreamException {
        if (token.getType() == 37 && this.lookAhead() == 32 && token.getText().indexOf(58) == -1) {
            token.setType(10);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Token peekNextToken() throws TokenStreamException {
        Token token = this.nextToken;
        if (token == null) {
            this.nextToken = token = this.simpleLexer.nextToken();
        }
        Token token2 = token;
        if (token2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathLexer.peekNextToken must not return null");
        }
        return token2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Token getNextToken() throws TokenStreamException {
        Token token = this.peekNextToken();
        this.nextToken = null;
        Token token2 = token;
        if (token2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathLexer.getNextToken must not return null");
        }
        return token2;
    }
}

