/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.xpath;

import java.io.StringWriter;
import java.util.Set;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SetElement;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.XPathSourceGenerator;
import oracle.bpm.compiler.xpath.XPTypeNormalizer;
import oracle.bpm.compiler.xpath.XPathGeneratorResult;
import oracle.bpm.compiler.xpath.XPathGeneratorUtils;
import oracle.bpm.compiler.xpath.XPathLiteralGenerator;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathGenerator
extends XPathLiteralGenerator {
    @NotNull
    private final FuegoCompiler compiler;
    @NotNull
    private final MethodTypeDescription method;

    public XPathGenerator(@NotNull Set<XPathVariable> scope, @NotNull ComponentCatalog catalog) {
        MethodTypeDescription mtd;
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGenerator.<init> must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGenerator.<init> must not be null");
        }
        super(scope);
        this.method = mtd = XPathGeneratorUtils.buildMethod(scope, catalog);
        this.compiler = XPathGeneratorUtils.buildCompiler(mtd);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public XPathGeneratorResult generate(@NotNull String expression, @Nullable TypeRef targetType, boolean lvalue, boolean ignoreReadOnly) throws CilException {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGenerator.generate must not be null");
        }
        MethodTypeDescription mtd = this.method;
        mtd.setCode(expression, "Fuego");
        XPathGeneratorUtils.setLValue(mtd, targetType, !ignoreReadOnly && lvalue);
        this.compiler.compile((TypeDescription)mtd);
        XPathGeneratorResult xPathGeneratorResult = this.generate(lvalue);
        if (xPathGeneratorResult == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGenerator.generate must not return null");
        }
        return xPathGeneratorResult;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    private XPathGeneratorResult generate(boolean lvalue) throws CompilerException {
        void var9_14;
        void var9_12;
        MethodTypeDescription mtd = this.method;
        FuegoCompiler compiler = this.compiler;
        XPathSourceGenerator sg = this.generator;
        StringWriter sw = new StringWriter();
        sg.init(sw, lvalue, this.currentNameSpaces);
        compiler.generateSource((SourceGenerator)sg, (TypeDescription)mtd);
        XPathExpression xpe = new XPathExpression(sw.toString(), sg.getNsMap());
        Method method = (Method)compiler.findMember((TypeDescription)mtd);
        Node firstStatement = method.getFirstStatement();
        if (firstStatement instanceof MemberAccess) {
            MethodTypeDescription methodTypeDescription = ((MemberAccess)firstStatement).getMemberType();
        } else if (firstStatement instanceof SetElement) {
            TypeDescription typeDescription = firstStatement.getOp1().getTypeDescription().getElementType();
        } else {
            TypeDescription typeDescription = firstStatement.getTypeDescription();
        }
        if (var9_12 instanceof AttributeTypeDescription) {
            TypeDescription typeDescription = ((AttributeTypeDescription)var9_12).getType();
        }
        TypeRef returnType = XPTypeNormalizer.generify((TypeDescription)var9_14).getRef();
        XPathGeneratorResult xPathGeneratorResult = new XPathGeneratorResult(xpe, returnType, sg.getSimpleReferences());
        if (xPathGeneratorResult == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGenerator.generate must not return null");
        }
        return xPathGeneratorResult;
    }
}

