/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.xpath;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oracle.bpm.compiler.xpath.XPTypeNormalizer;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class StaticMethodsHelper {
    private StaticMethodsHelper() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Collection<TypeDescription> getStaticTypes() {
        XPTypeNormalizer xp = new XPTypeNormalizer();
        ObjectTypeDescription stringTD = StaticMethodsHelper.functionalSyntax(xp.canonical(TypeFactory.getString()));
        ObjectTypeDescription realTD = StaticMethodsHelper.functionalSyntax(xp.canonical(TypeFactory.getReal()));
        ObjectTypeDescription timeTD = StaticMethodsHelper.functionalSyntax(xp.canonical(TypeFactory.getTime()));
        List<TypeDescription> list = Arrays.asList(stringTD, realTD, timeTD);
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/StaticMethodsHelper.getStaticTypes must not return null");
        }
        return list;
    }

    public static String getTemplate(MethodTypeDescription method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName()).append('(');
        int count = method.getArgumentCount();
        for (int i = 0; i < count; ++i) {
            Argument arg = method.getArgument(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(arg.getName());
        }
        sb.append(')');
        return sb.toString();
    }

    private static void functionalSyntax(MethodTypeDescription fun) {
        do {
            Argument[] args = fun.getArguments();
            fun.removeAllArguments();
            fun.addArgument(new Argument("value", fun.getParentRef(), 1L));
            for (Argument arg : args) {
                fun.addArgument(arg);
            }
        } while ((fun = fun.getNextMethod()) != null);
    }

    private static ObjectTypeDescription functionalSyntax(TypeRef obj) {
        ObjectTypeDescription origOtd = obj.get().asObject();
        ObjectTypeDescription newOtd = new ObjectTypeDescription(origOtd.getName(), origOtd.getKind(), false);
        for (MethodTypeDescription origMethod : origOtd.getMethods()) {
            MethodTypeDescription newMethod = origMethod.clone();
            newOtd.addMember(newMethod);
            StaticMethodsHelper.functionalSyntax(newMethod);
        }
        return newOtd;
    }
}

