/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.xpath;

import fuego.parser.RecognitionException;
import fuego.parser.TokenStreamException;
import java.util.Set;
import oracle.bpm.compiler.xpath.AbstractXPathParser;
import oracle.bpm.compiler.xpath.ContextVariableNotFoundException;
import oracle.bpm.compiler.xpath.SimpleGeneratorException;
import oracle.bpm.compiler.xpath.XPathLexer;
import oracle.bpm.compiler.xpath.XPathParser;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGenerator {
    private final XPathLexer lexer;
    private final XPathParser parser;

    public SimpleGenerator(@NotNull Set<XPathVariable> scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/SimpleGenerator.<init> must not be null");
        }
        this.lexer = new XPathLexer();
        XPathParser parser = new XPathParser(this.lexer);
        parser.setScope((Set)scope);
        this.parser = parser;
    }

    @Nullable
    public static String makeLiteral(String xpath) {
        AbstractXPathParser.PInfo pInfo;
        XPathLexer lexer = new XPathLexer();
        XPathParser parser = new XPathParser(lexer);
        lexer.setInputString(xpath);
        try {
            pInfo = parser.pathExpr();
            parser.match(1);
            parser.checkErrors();
        }
        catch (RecognitionException ignore) {
            return null;
        }
        catch (TokenStreamException ignore) {
            return null;
        }
        return pInfo.getStringValue();
    }

    @Nullable
    public String makeXMLLiteral(@NotNull XPathExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/SimpleGenerator.makeXMLLiteral must not be null");
        }
        this.initParser(expression);
        try {
            return this.parse(new ParserRule(){

                @Override
                public String parse() throws TokenStreamException, RecognitionException {
                    return SimpleGenerator.this.parser.xmlLiteral();
                }
            });
        }
        catch (SimpleGeneratorException ignore) {
            return null;
        }
    }

    public String generate(@NotNull XPathExpression expression, @Nullable TypeRef targetType) throws SimpleGeneratorException {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/SimpleGenerator.generate must not be null");
        }
        this.initParser(expression);
        this.parser.setTargetType(targetType);
        return this.parse(new ParserRule(){

            @Override
            public String parse() throws TokenStreamException, RecognitionException {
                return SimpleGenerator.this.parser.program();
            }
        });
    }

    private void initParser(XPathExpression expression) {
        this.lexer.setInputString(expression.getExpressionValue());
        this.parser.setNamespaces(XPathLexer.asResolver(expression.getNamespaces()));
    }

    private String parse(ParserRule rule) throws SimpleGeneratorException {
        String result;
        XPathParser parser = this.parser;
        parser.reset();
        try {
            result = rule.parse();
            parser.checkErrors();
        }
        catch (RecognitionException e) {
            throw new SimpleGeneratorException((Exception)((Object)e));
        }
        catch (TokenStreamException e) {
            throw new SimpleGeneratorException((Exception)((Object)e));
        }
        catch (ContextVariableNotFoundException e) {
            throw new SimpleGeneratorException(e);
        }
        return result;
    }

    private static interface ParserRule {
        public String parse() throws TokenStreamException, RecognitionException;
    }
}

