/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.maps.BiMap;
import oracle.bpm.collections.maps.HashBiMap;
import oracle.bpm.compiler.Aggregate;
import oracle.bpm.compiler.Alias;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Arithmetic;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.Cast;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.Comment;
import oracle.bpm.compiler.Comp;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.DecimalConst;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.DefaultConst;
import oracle.bpm.compiler.Delete;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.Display;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.EnumConst;
import oracle.bpm.compiler.Equality;
import oracle.bpm.compiler.Exists;
import oracle.bpm.compiler.Exit;
import oracle.bpm.compiler.ExprIf;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.For;
import oracle.bpm.compiler.ForEach;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.GroupByColumns;
import oracle.bpm.compiler.Having;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.If;
import oracle.bpm.compiler.In;
import oracle.bpm.compiler.IncDecOperator;
import oracle.bpm.compiler.Input;
import oracle.bpm.compiler.InputField;
import oracle.bpm.compiler.InputFields;
import oracle.bpm.compiler.Insert;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.IntervalConst;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.Is;
import oracle.bpm.compiler.JavaFor;
import oracle.bpm.compiler.LabeledStatement;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.Log;
import oracle.bpm.compiler.Logic;
import oracle.bpm.compiler.MappedArrayReference;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.NamedNode;
import oracle.bpm.compiler.NewLine;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.ObjectInput;
import oracle.bpm.compiler.On;
import oracle.bpm.compiler.OnExit;
import oracle.bpm.compiler.OrderBy;
import oracle.bpm.compiler.Parameter;
import oracle.bpm.compiler.Plus;
import oracle.bpm.compiler.QualifiedName;
import oracle.bpm.compiler.Range;
import oracle.bpm.compiler.RealConst;
import oracle.bpm.compiler.RegExpConst;
import oracle.bpm.compiler.Return;
import oracle.bpm.compiler.Select;
import oracle.bpm.compiler.SelectColumns;
import oracle.bpm.compiler.SetElement;
import oracle.bpm.compiler.SetMember;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SqlColumnReference;
import oracle.bpm.compiler.StringCat;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.Switch;
import oracle.bpm.compiler.SwitchCases;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.Tables;
import oracle.bpm.compiler.Term;
import oracle.bpm.compiler.Throw;
import oracle.bpm.compiler.TimeConst;
import oracle.bpm.compiler.TransformCall;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UnaryArithmetic;
import oracle.bpm.compiler.Update;
import oracle.bpm.compiler.While;
import oracle.bpm.compiler.xpath.XPathUsageType;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.CompOperator;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.LogicOperator;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TZTime;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathSourceGenerator
implements SourceGenerator {
    @NotNull
    private final Map<URI, String> currentNamespaces = new HashMap<URI, String>();
    private boolean lvalue;
    private final BiMap<URI, String> nsMap = new HashBiMap<URI, String>();
    private PrintWriter out;
    @NotNull
    private final Set<String> prefixes = new HashSet<String>();
    private final Map<String, XPathVariable> scopeInfo;
    @Nullable
    private List<AttributeTypeDescription> simpleReferences;
    private static final String DATE_TIME_CAST = "dateTime";
    private static final String BOOLEAN_CAST = "boolean";
    private static final String[] DECIMAL_OPERATORS = "add,subtract,multiply,divide,remainder".split(",");
    private static final String[] ARITHMETIC_OPERATORS = "+,-,*,div,mod".split(",");
    private static final Map<URI, String> DEFAULT_PREFIXES;
    private static final String BPM_UTILS_NAMESPACE = "http://xmlns.oracle.com/bpm/utils";
    private static final String XP20_NAMESPACE = "http://www.oracle.com/XSL/Transform/java/oracle.tip.pc.services.functions.Xpath20";
    private static final String EXT_NAMESPACE = "http://www.oracle.com/XSL/Transform/java/oracle.tip.pc.services.functions.ExtFunc";

    public XPathSourceGenerator(Map<String, XPathVariable> scopeInfo) {
        this.scopeInfo = new HashMap<String, XPathVariable>(scopeInfo);
    }

    public static String buildSignature(String ns, String signature) {
        return "xpath;" + ns + ';' + signature;
    }

    public static String makeString(String literal) {
        return XPathSourceGenerator.quoteString(false, literal);
    }

    public Map<String, URI> getNsMap() {
        return CollectionUtils.immutableMap(this.nsMap.inverse());
    }

    public void setOptions(String generatorOptions) {
        throw XPathSourceGenerator.unexpected();
    }

    public void setStyle(CodeStyle style) {
        throw XPathSourceGenerator.unexpected();
    }

    @Nullable
    public CodeStyle getStyle() {
        return null;
    }

    public void setLValue(boolean lvalue) {
        this.lvalue = lvalue;
    }

    public void reset() {
        this.out = null;
        this.nsMap.clear();
        this.simpleReferences = null;
        this.lvalue = false;
        this.prefixes.clear();
        this.currentNamespaces.clear();
    }

    public void init(Writer writer, boolean lvalue, @Nullable Map<String, URI> namespaces) {
        this.reset();
        this.setWriter(writer);
        this.setLValue(lvalue);
        if (namespaces == null) {
            namespaces = Collections.emptyMap();
        }
        assert (namespaces != null);
        this.setPrefixes(namespaces.keySet());
        this.initNameSpaces(namespaces);
    }

    public void makeXMLLiteral(String literal) {
        String str = XPathSourceGenerator.makeString(literal);
        this.out.print(this.qualify(EXT_NAMESPACE) + "parseXML(" + str + ')');
    }

    public void setPrefixes(@NotNull Set<String> newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/XPathSourceGenerator.setPrefixes must not be null");
        }
        Set<String> set = this.prefixes;
        set.clear();
        set.addAll(newValue);
    }

    public void setWriter(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public void close() {
        this.out.close();
    }

    public void generate(Aggregate aggregate, Node operand, int op, boolean distinct) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Alias alias, Node variable, Node aliasName) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Args args) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Arg arg) {
        arg.getValue().generate((SourceGenerator)this);
    }

    public void generate(Arithmetic arithmetic) {
        Node op1 = XPathSourceGenerator.unconversion(arithmetic.getOp1());
        Node op2 = XPathSourceGenerator.unconversion(arithmetic.getOp2());
        if (arithmetic.getTypeDescription().getKind() == 3) {
            String function = DECIMAL_OPERATORS[arithmetic.getOperator()];
            this.generateStaticCall(XPathSourceGenerator.buildSignature("http://xmlns.oracle.com/bpm/decimal", function), op1, op2);
        } else {
            PrintWriter out = this.out;
            int prec0 = XPathSourceGenerator.precedence((Node)arithmetic);
            int prec1 = XPathSourceGenerator.precedence(op1);
            int prec2 = XPathSourceGenerator.precedence(op2);
            if (prec1 < prec0) {
                out.print('(');
            }
            op1.generate((SourceGenerator)this);
            if (prec1 < prec0) {
                out.print(')');
            }
            out.print(' ');
            out.print(ARITHMETIC_OPERATORS[arithmetic.getOperator()]);
            out.print(' ');
            if (prec2 <= prec0) {
                out.print('(');
            }
            op2.generate((SourceGenerator)this);
            if (prec2 <= prec0) {
                out.print(')');
            }
        }
    }

    public void generate(ArrayConst arrayConst, boolean isMap) {
        if (isMap) {
            throw XPathSourceGenerator.unexpected();
        }
        int count = XPathSourceGenerator.childrenCount((Node)arrayConst);
        if (count == 0) {
            this.generateNull();
        } else if (count == 1) {
            arrayConst.getFirst().generate((SourceGenerator)this);
        } else {
            String addNode = this.qualify(BPM_UTILS_NAMESPACE) + "node-set(";
            for (int i = 1; i < count; ++i) {
                this.out.print(addNode);
            }
            Node node = arrayConst.getFirst();
            node.generate((SourceGenerator)this);
            for (node = node.getNext(); node != null; node = node.getNext()) {
                this.out.print(", ");
                node.generate((SourceGenerator)this);
                this.out.print(')');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateArrayRef(Node ref, Node array, Node index) {
        this.checkSimpleExpression(ref);
        array.generate((SourceGenerator)this);
        List<AttributeTypeDescription> savRefs = this.simpleReferences;
        boolean savLValue = this.lvalue;
        this.simpleReferences = null;
        this.lvalue = false;
        try {
            this.out.print('[');
            index.generate((SourceGenerator)this);
            this.out.print(']');
        }
        finally {
            this.simpleReferences = savRefs;
            this.lvalue = savLValue;
        }
    }

    public void generate(ArrayReference ref, Node array, Node index) {
        this.generateArrayRef((Node)ref, array, index);
    }

    public void generate(Assignment assignment, Node target, Node value) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Block block) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(BoolConst bool) {
        this.out.printf("%b()", bool.booleanValue());
    }

    public void generate(Cast cast) {
        Node expr = cast.getExpr();
        if (cast.isSynthetic()) {
            expr.generate((SourceGenerator)this);
        } else {
            this.generateCast((Node)cast, expr);
        }
    }

    public void generate(Comp comp) {
        CompOperator operator = comp.getOperator();
        assert (operator == CompOperator.LT || operator == CompOperator.LE || operator == CompOperator.GT || operator == CompOperator.GE);
        String operStr = operator == CompOperator.LT ? " < " : (operator == CompOperator.LE ? " <= " : (operator == CompOperator.GT ? " > " : " >= "));
        this.out.print('(');
        Node op1 = comp.getOp1();
        Node op2 = comp.getOp2();
        int operKind = XPathSourceGenerator.promote(op1.getTypeDescription(), op2.getTypeDescription());
        String ns = operKind == 5 ? XP20_NAMESPACE : (operKind == 3 ? "http://xmlns.oracle.com/bpm/decimal" : null);
        if (ns != null) {
            this.generateCompare((Node)comp, ns, operStr);
        } else {
            op1.generate((SourceGenerator)this);
            this.out.print(operStr);
            op2.generate((SourceGenerator)this);
        }
        this.out.print(')');
    }

    public void generate(Conversion conversion, Node op) {
        this.generateCast((Node)conversion, op);
    }

    public void generate(DecimalConst decimal) {
        this.out.print("'");
        this.out.print(decimal.value.toPlainString());
        this.out.print("'");
    }

    public void generate(DefaultConst defaultConst) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Deref deref, Node op) {
        op.generate((SourceGenerator)this);
    }

    public void generate(Display display, Node message, Args inargs, Args outargs, Invoke targetInvoke) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(DoBlock doblock) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(EnumConst e) {
        this.out.print(XPathSourceGenerator.quoteString(e.getNativeName()));
    }

    public void generate(Equality eq) {
        Node op1 = eq.getOp1();
        Node op2 = eq.getOp2();
        boolean op1IsNull = op1 instanceof NullConst;
        boolean op2IsNull = op2 instanceof NullConst;
        if (!op1IsNull && !op2IsNull) {
            this.out.print('(');
            String opStr = eq.isEquals() ? " = " : " != ";
            int compKind = XPathSourceGenerator.promote(op1.getTypeDescription(), op2.getTypeDescription());
            if (compKind == 3) {
                this.generateCompare((Node)eq, "http://xmlns.oracle.com/bpm/decimal", opStr);
            } else {
                op1.generate((SourceGenerator)this);
                this.out.print(opStr);
                op2.generate((SourceGenerator)this);
            }
            this.out.print(')');
        } else if (op1IsNull && op2IsNull) {
            this.out.print(eq.isEquals() ? "true()" : "false()");
        } else {
            Node nonNull;
            Node node = nonNull = op1IsNull ? op2 : op1;
            if (eq.isEquals()) {
                this.out.print("not(");
            }
            this.out.print("boolean(");
            nonNull.generate((SourceGenerator)this);
            this.out.print(")");
            if (eq.isEquals()) {
                this.out.print(")");
            }
        }
    }

    public void generate(Exit exit, Node predicate, Node label) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(ExprIf exprIf, Node predicate, Node a, Node b) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(FieldDeclaration decl) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(InputField field, Node label, Node variable, List<Node> options, Node validValues) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(InputFields fields) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(For fornode, Node index, Node range, Node body) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(ForEach foreach, Node index, Node array, Node where, Node body) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Function function) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Identifier id) {
        String name = id.getText();
        XPathVariable variable = this.scopeInfo.get(name);
        assert (variable != null) : "Unexpected variable : " + name;
        this.generateObject(variable);
    }

    public void generate(Identifier.This id) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Identifier.Super id) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Identifier.TokenText id) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(If ifnode) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(In in, Node expr, Node range) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Input input, InputFields fields, Args inargs, Args outargs, Invoke targetInvoke) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(IntConst integer) {
        this.out.print(integer.getValue());
    }

    public void generate(IntervalConst interval) {
        this.out.print(XPathSourceGenerator.quoteString(interval.getValue().toXMLString()));
    }

    public void generate(Invoke invoke, Node object, Args inArgs, Args outArgs, String methodName) {
        this.generateCall(invoke.getMemberType().isStatic(), invoke.getSignature(), object, inArgs);
    }

    public void generate(Is is, Node expr, TypeDescription type, boolean negative) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(JavaFor javaFor) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(LocalVar locarVar, Symbol symbol) {
        if (!locarVar.isCurrentReference()) {
            throw XPathSourceGenerator.unexpected();
        }
    }

    public void generate(Log log, Node message, Args inargs) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Logic logic) {
        LogicOperator operator = logic.getOperator();
        this.out.print('(');
        if (operator != LogicOperator.AND && operator != LogicOperator.OR) {
            throw new AssertionError((Object)("Unexpected logic operator: " + (Object)((Object)operator)));
        }
        logic.getOp1().generate((SourceGenerator)this);
        this.out.print(operator == LogicOperator.AND ? " and " : " or ");
        logic.getOp2().generate((SourceGenerator)this);
        this.out.print(')');
    }

    public void generate(MappedArrayReference ref) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(MemberReference ref, Node object, Node member) {
        this.generateMember((MemberAccess)ref, object, member);
    }

    public void generate(Method method) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(@Nullable Not not, Node op) {
        this.out.print("not(");
        op.generate((SourceGenerator)this);
        this.out.print(')');
    }

    public void generate(NullConst nullConst) {
        this.generateNull();
    }

    public void generate(ObjectClass objectClass) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(On on) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(@Nullable Plus plus, Node op) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(QualifiedName qname) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Range range, Node from, Node to) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(RealConst real) {
        this.out.print(new BigDecimal(String.valueOf(real.value)).toPlainString());
    }

    public void generate(RegExpConst regexp) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Return ret, Node expr) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(SetElement element, Node array, Node index, Node value) {
        this.generateArrayRef((Node)element, array, index);
    }

    public void generate(SetMember setMember, Node object, Node member, Node value) {
        this.generateMember((MemberAccess)setMember, object, member);
    }

    public void generate(StringCat cat, Node left, Node right) {
        this.out.print("concat(");
        this.dumpCatList((Node)cat);
        this.out.print(')');
    }

    public void generate(StringConst string) {
        boolean withinConcat = string.getParent() instanceof StringCat;
        this.out.print(XPathSourceGenerator.quoteString(withinConcat, string.getText()));
    }

    public void generate(Throw node, Node exception) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(TimeConst time) {
        if (time.isNow()) {
            this.out.print(this.qualify(XP20_NAMESPACE) + "current-dateTime()");
        } else {
            this.out.print(XPathSourceGenerator.quoteString(TZTime.valueOf(time.getText()).toXMLString()));
        }
    }

    public void generate(While whileNode, Node predicate, Node body) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(OnExit onExit) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Term add) {
        Node op2;
        Node op1 = add.getOp1();
        if (op1.getTypeDescription().getKind() == 6 && (op2 = add.getOp2()).getTypeDescription().getKind() == 7) {
            String function = add.isSubstraction ? "subtract-dayTimeDuration-from-dateTime" : "add-dayTimeDuration-to-dateTime";
            this.out.print(this.qualify(XP20_NAMESPACE) + function + '(');
            op1.generate((SourceGenerator)this);
            this.out.print(", ");
            op2.generate((SourceGenerator)this);
            this.out.print(")");
            return;
        }
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(TypeSpec typeSpec) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(UnaryArithmetic node) {
        Node op1 = XPathSourceGenerator.unconversion(node.getOp1());
        int prec = XPathSourceGenerator.precedence(op1);
        if (node.isMinus()) {
            if (node.getTypeDescription().getKind() == 3) {
                this.out.print(this.qualify("http://xmlns.oracle.com/bpm/decimal") + "negative");
                prec = 0;
            } else {
                this.out.print('-');
            }
        }
        if (prec < 9) {
            this.out.print('(');
        }
        op1.generate((SourceGenerator)this);
        if (prec < 9) {
            this.out.print(')');
        }
    }

    public void generate(NamedNode namedNode) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Select select) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Insert insert) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Delete delete) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Update update) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Update.SetValues setValues) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Insert.Values values) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Insert.Columns columns) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Tables tables) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(SelectColumns selectColumns) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(GroupByColumns groupByColumns) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(OrderBy orderBy) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(SqlColumnReference sqlColumnReference) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(LabeledStatement label) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Switch switchNode, Node expr, Node cases) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Switch.Case caseNode, Node cond, Node body) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Switch.Default defaultNode, Node body) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(SwitchCases switchCases) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Exists exists, Node op, boolean negate) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(ObjectInput objectInput, Node object, Args inargs, Args outargs) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Comment comment) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(NewLine newLine) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Having having) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Parameter parameter) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(TransformCall transformCall, Node source, Node target, Node library) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(Declaration declaration) {
        throw XPathSourceGenerator.unexpected();
    }

    public void generate(IncDecOperator incDecOperator) {
        throw XPathSourceGenerator.unexpected();
    }

    @Nullable
    public List<AttributeTypeDescription> getSimpleReferences() {
        return CollectionUtils.immutableList(this.simpleReferences);
    }

    private static int childrenCount(Node node) {
        int count = 0;
        for (Node child = node.getFirst(); child != null; child = child.getNext()) {
            ++count;
        }
        return count;
    }

    private static int promote(int kind1, int kind2) {
        return kind1 > kind2 ? kind1 : kind2;
    }

    private static int promote(TypeRef type1, TypeRef type2) {
        return XPathSourceGenerator.promote(type1.getKind(), type2.getKind());
    }

    private static Node unconversion(Node node) {
        while (node instanceof Conversion || node instanceof Cast) {
            node = node.getFirst();
        }
        return node;
    }

    private static boolean isXmlType(@NotNull TypeDescription objType) {
        if (objType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/XPathSourceGenerator.isXmlType must not be null");
        }
        String signature = objType.getSignature();
        return signature == null || !signature.startsWith("xpath;");
    }

    private static int precedence(Node node) {
        if (!(node instanceof Arithmetic)) {
            return 10;
        }
        Arithmetic arithmetic = (Arithmetic)node;
        int operator = arithmetic.getOperator();
        return operator >= 2 ? 2 : 1;
    }

    private static String quoteString(boolean withinConcat, String value) {
        StringBuilder sb;
        int quotePos = -1;
        int aposPos = value.indexOf(39);
        char delimiter = aposPos == -1 ? (char)'\'' : ((quotePos = value.indexOf(34)) == -1 ? (char)'\"' : '\u0000');
        if (delimiter != '\u0000') {
            sb = new StringBuilder(value.length() + 2).append(delimiter).append(value).append(delimiter);
        } else {
            delimiter = aposPos < quotePos ? (char)'\"' : '\'';
            sb = XPathSourceGenerator.splitString(withinConcat, value, delimiter);
        }
        return sb.toString();
    }

    private static StringBuilder splitString(boolean withinConcat, String value, char preferredDelimiter) {
        StringBuilder sb = new StringBuilder(value.length() + (withinConcat ? 10 : 20));
        if (!withinConcat) {
            sb.append("concat(");
        }
        char delimiter = preferredDelimiter;
        sb.append(delimiter);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == delimiter) {
                sb.append(delimiter).append(", ");
                delimiter = delimiter == '\'' ? (char)'\"' : '\'';
                sb.append(delimiter);
            }
            sb.append(c);
        }
        sb.append(delimiter);
        if (!withinConcat) {
            sb.append(')');
        }
        return sb;
    }

    private static boolean getBoolean(MethodTypeDescription type, String property) {
        return Boolean.parseBoolean(type.getProperty(property));
    }

    private static IllegalStateException unexpected() {
        return new IllegalStateException("Unexpected operation");
    }

    private static int getTimeKind(TypeDescription type) {
        assert (type.getKind() == 6);
        int scale = type.getScale();
        return scale < 0 ? 2 : scale;
    }

    @Nullable
    private static String getCastFunction(Node conversion) {
        Node parent = conversion.getParent();
        if (parent instanceof Conversion) {
            return null;
        }
        if (parent instanceof Cast) {
            return null;
        }
        TypeDescription toType = conversion.getTypeDescription();
        TypeDescription fromType = XPathSourceGenerator.unconversion(conversion).getTypeDescription();
        if (toType.getKind() == fromType.getKind() && (toType.getKind() != 6 || XPathSourceGenerator.getTimeKind(toType) == XPathSourceGenerator.getTimeKind(fromType))) {
            return null;
        }
        switch (toType.getKind()) {
            case 2: 
            case 4: {
                if (fromType.isNumber()) {
                    return null;
                }
                if (parent instanceof Arithmetic) {
                    return null;
                }
                if (parent instanceof Return) {
                    return null;
                }
                if (XPathSourceGenerator.isConstComparison(conversion)) {
                    return null;
                }
                return "number";
            }
            case 1: {
                return BOOLEAN_CAST;
            }
            case 5: 
            case 6: 
            case 7: {
                if (toType.getKind() == 6 && conversion.getFirst().getKind() == 6) {
                    return DATE_TIME_CAST;
                }
                if (parent instanceof StringCat) {
                    return null;
                }
                if (parent instanceof Equality && toType.isString()) {
                    return null;
                }
                if (XPathSourceGenerator.isConstComparison(conversion)) {
                    return null;
                }
                if (parent instanceof Return) {
                    return null;
                }
                int opKind = fromType.getKind();
                if (opKind == 6 || opKind == 7) {
                    return null;
                }
                if (toType.getKind() == 6 && XPathSourceGenerator.getTimeKind(toType) != 2) {
                    return DATE_TIME_CAST;
                }
                return "string";
            }
        }
        return null;
    }

    private static boolean isConstComparison(Node conversion) {
        Node parent = conversion.getParent();
        if (parent instanceof Equality || parent instanceof Comp && conversion.getTypeDescription().isNumber()) {
            Node other = parent.getOp1();
            if (other == conversion) {
                other = parent.getOp2();
            }
            if (other.getTypeDescription().getKind() == 3) {
                return true;
            }
            while (other instanceof Conversion) {
                other = other.getFirst();
            }
            if (other instanceof Const) {
                return true;
            }
        }
        return false;
    }

    private static String quoteString(String str) {
        return XPathSourceGenerator.quoteString(false, str);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static String defaultPrefix(URI uri) {
        String prefix = DEFAULT_PREFIXES.get(uri);
        if (prefix == null) {
            return "ns";
        }
        String string = prefix;
        if (string == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/XPathSourceGenerator.defaultPrefix must not return null");
        return string;
    }

    private static boolean isParentReturn(Node node) {
        return XPathSourceGenerator.getRealParent(node) instanceof Return;
    }

    private static Node getRealParent(Node node) {
        while ((node = node.getParent()) instanceof Conversion && ((Conversion)node).isSyntheticCast()) {
        }
        return node;
    }

    private static boolean isTestForNull(Node parent) {
        return parent instanceof Equality && (parent.getOp1() instanceof NullConst || parent.getOp2() instanceof NullConst);
    }

    private static Node[] asArray(@Nullable Args inArgs) {
        Node arg;
        ArrayList<Node> args = new ArrayList<Node>();
        Node node = arg = inArgs == null ? null : inArgs.getFirst();
        while (arg != null) {
            args.add(arg);
            arg = arg.getNext();
        }
        return args.toArray(new Node[args.size()]);
    }

    private void generateObject(XPathVariable variable) {
        XPathUsageType usageType = variable.getUsageType();
        if (usageType == XPathUsageType.DATA_CONTEXT) {
            this.generateContextData(variable);
        } else {
            this.generateBpmData(variable, usageType);
        }
    }

    private void generateBpmData(XPathVariable variable, XPathUsageType usageType) {
        assert (variable.getUsageType() != XPathUsageType.DATA_CONTEXT);
        String functionName = usageType.functionName;
        assert (!Str.isEmpty(functionName));
        PrintWriter writer = this.out;
        writer.print(this.qualify("http://www.omg.org/bpmn20"));
        writer.print(functionName);
        writer.print('(');
        if (usageType == XPathUsageType.ACTIVITY_INSTANCE_ATTRIBUTE) {
            writer.print(XPathSourceGenerator.quoteString(variable.getContainerName()));
            writer.print(", ");
        }
        writer.print(XPathSourceGenerator.quoteString(variable.getName()));
        writer.print(')');
    }

    private void generateContextData(XPathVariable variable) {
        assert (variable.getUsageType() == XPathUsageType.DATA_CONTEXT);
        QName[] path = variable.getDataContextPath();
        PrintWriter writer = this.out;
        if (path.length == 0) {
            writer.print("/.");
        } else {
            for (QName name : path) {
                writer.print('/');
                writer.print(this.qualify(name.getNamespaceURI()));
                writer.print(name.getLocalPart());
            }
        }
    }

    private void generateMember(MemberAccess ref, Node object, Node member) {
        if (ref.getOp1() instanceof Deref) {
            this.checkSimpleExpression((Node)ref);
            member.generate((SourceGenerator)this);
            this.addSimpleReference(ref.getMemberType());
        } else {
            MethodTypeDescription memberTD = ref.getMemberType();
            if (XPathSourceGenerator.isXmlType(memberTD)) {
                this.generateXmlNode(ref, object);
            } else {
                this.generateCall(memberTD.isStatic(), memberTD.getSignature(), object, null);
            }
        }
    }

    private void generateNull() {
        this.out.print("null[false()]");
    }

    private void generateCompare(Node comp, String ns, String operStr) {
        this.out.print(this.qualify(ns));
        this.out.print("compare(");
        comp.getOp1().generate((SourceGenerator)this);
        this.out.print(", ");
        comp.getOp2().generate((SourceGenerator)this);
        this.out.print(") ");
        this.out.print(operStr);
        this.out.print(" 0");
    }

    private void initNameSpaces(@NotNull Map<String, URI> nameSpaces) {
        if (nameSpaces == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/XPathSourceGenerator.initNameSpaces must not be null");
        }
        Map<URI, String> current = this.currentNamespaces;
        current.clear();
        for (Map.Entry<String, URI> entry : nameSpaces.entrySet()) {
            String prefix = entry.getKey();
            URI uri = entry.getValue();
            current.put(uri, prefix);
        }
    }

    private void generateStaticCall(String signature, Node ... args) {
        this.generateCall(signature, null, args);
    }

    private void generateCall(String signature, @Nullable Node object, Node ... args) {
        String[] parts = signature.split(";");
        if (parts.length < 3 || !"xpath".equals(parts[0])) {
            throw new RuntimeException("Invalid signature: " + signature);
        }
        this.out.print(this.qualify(parts[1]) + parts[2] + '(');
        boolean first = true;
        if (object != null) {
            object.generate((SourceGenerator)this);
            first = false;
        }
        for (Node arg : args) {
            if (!first) {
                this.out.print(", ");
            }
            arg.generate((SourceGenerator)this);
            first = false;
        }
        this.out.print(")");
    }

    private void generateCall(boolean isStatic, String signature, Node object, @Nullable Args inArgs) {
        if (isStatic) {
            object = null;
        }
        this.generateCall(signature, object, XPathSourceGenerator.asArray(inArgs));
    }

    private void generateXmlNode(MemberAccess ref, Node object) {
        this.checkSimpleExpression((Node)ref);
        object.generate((SourceGenerator)this);
        MethodTypeDescription type = ref.getMemberType();
        String signature = type.getSignature();
        this.addSimpleReference(type);
        PrintWriter out = this.out;
        if (signature != null && (signature.startsWith("X;") || signature.startsWith("C"))) {
            if (this.lvalue) {
                out.print("/.");
            }
            return;
        }
        out.print('/');
        String namespace = type.getProperty(Literals.ELEMENT_NAMESPACE);
        if (XPathSourceGenerator.getBoolean(type, Literals.IS_XSD_ATTRIBUTE)) {
            out.print('@');
            if (!XPathSourceGenerator.getBoolean(type, Literals.FORM_QUALIFIED)) {
                namespace = null;
            }
        }
        if (!Str.isEmpty(namespace)) {
            out.print(this.qualify(namespace));
        }
        String nativeName = type.getNativeName();
        assert (!Str.isEmpty(nativeName));
        out.print(nativeName);
    }

    private void addSimpleReference(MethodTypeDescription type) {
        List<AttributeTypeDescription> references = this.simpleReferences;
        if (references != null) {
            references.add((AttributeTypeDescription)type);
        }
    }

    private void checkSimpleExpression(Node node) {
        if (this.simpleReferences != null) {
            return;
        }
        if (node instanceof SetMember || XPathSourceGenerator.isParentReturn(node)) {
            this.simpleReferences = new ArrayList<AttributeTypeDescription>();
        }
    }

    private void generateCastToBoolean(Node expr) {
        this.out.print(this.qualify(XP20_NAMESPACE) + "matches(");
        this.generateCast("string", expr);
        this.out.print(", '\\s*(?i:true|1)\\s*')");
    }

    private void generateCastToDateTime(Node conversion, Node expr) {
        Node parent = conversion.getParent();
        int newScale = parent instanceof Return ? XPathSourceGenerator.getTimeKind(conversion.getTypeDescription()) : 2;
        this.out.print(this.qualify(BPM_UTILS_NAMESPACE) + "convert(");
        expr.generate((SourceGenerator)this);
        this.out.print(", 6, -1, " + newScale + ')');
    }

    private void generateCast(Node conversion, Node expr) {
        String castFunction;
        if (this.lvalue) {
            castFunction = null;
        } else if (XPathSourceGenerator.isTestForNull(XPathSourceGenerator.getRealParent(conversion))) {
            castFunction = null;
        } else {
            castFunction = XPathSourceGenerator.getCastFunction(conversion);
            if (BOOLEAN_CAST.equals(castFunction)) {
                this.generateCastToBoolean(expr);
                return;
            }
            if (DATE_TIME_CAST.equals(castFunction)) {
                this.generateCastToDateTime(conversion, expr);
                return;
            }
        }
        this.generateCast(castFunction, expr);
    }

    private void generateCast(@Nullable String castFunction, Node expr) {
        if (castFunction != null) {
            this.out.print(castFunction);
            this.out.print('(');
        }
        expr.generate((SourceGenerator)this);
        if (castFunction != null) {
            this.out.print(')');
        }
    }

    private void dumpCatList(Node node) {
        while (node instanceof StringCat) {
            this.dumpCatList(node.getOp1());
            this.out.print(", ");
            node = node.getOp2();
        }
        node.generate((SourceGenerator)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private String qualify(@Nullable String namespace) {
        String prefix = this.getPrefix(namespace);
        if (Str.isEmpty(prefix)) {
            return "";
        }
        String string = prefix + ':';
        if (string == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/XPathSourceGenerator.qualify must not return null");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private String newPrefix(@NotNull URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/XPathSourceGenerator.newPrefix must not be null");
        }
        StringBuilder sb = new StringBuilder(XPathSourceGenerator.defaultPrefix(uri));
        int sbLen = sb.length();
        Set<String> used = this.prefixes;
        int i = 0;
        while (!used.add(sb.toString())) {
            sb.setLength(sbLen);
            sb.append(++i);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/XPathSourceGenerator.newPrefix must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private String getPrefix(@Nullable String ns) {
        String string;
        if (Str.isEmpty(ns)) {
            return "";
        }
        BiMap<URI, String> map = this.nsMap;
        URI uri = URI.create(ns);
        String prefix = (String)map.get(uri);
        if (prefix != null) {
            String string2 = prefix;
            string = string2;
            if (string2 == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/XPathSourceGenerator.getPrefix must not return null");
            return string;
        }
        prefix = this.currentNamespaces.get(uri);
        if (prefix == null) {
            prefix = this.newPrefix(uri);
        }
        map.put(uri, prefix);
        String string3 = prefix;
        string = string3;
        if (string3 == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/XPathSourceGenerator.getPrefix must not return null");
        return string;
    }

    static {
        HashBiMap<URI, String> map = new HashBiMap<URI, String>();
        map.put(URI.create("http://www.omg.org/bpmn20"), "bpmn");
        map.put(URI.create(XP20_NAMESPACE), "xp20");
        map.put(URI.create(BPM_UTILS_NAMESPACE), "utl");
        map.put(URI.create("http://xmlns.oracle.com/bpm/decimal"), "dec");
        map.put(URI.create(EXT_NAMESPACE), "oraext");
        DEFAULT_PREFIXES = Collections.unmodifiableMap(map);
    }
}

