/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xml;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Literals;
import oracle.bpm.xml.BaseSerializer;
import oracle.bpm.xml.Serializer;
import oracle.bpm.xml.XMLSerializerWriter;

public class XMLSerializer
extends BaseSerializer {
    public static XMLSerializerWriter createWriter(OutputStream os) throws IOException {
        return XMLSerializer.createWriter(os, Literals.DEFAULT_ENCODING);
    }

    public static XMLSerializerWriter createWriter(OutputStream os, String encoding) throws IOException {
        String header = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n";
        os.write(header.getBytes());
        return new XMLSerializerWriter((Writer)new BufferedWriter(new OutputStreamWriter(os, encoding)), (Serializer)new XMLSerializer());
    }

    @Deprecated
    public static String serializeObjectToString(Object object) {
        return XMLSerializer.serializeObjectToString(object, Literals.DEFAULT_ENCODING);
    }

    public static String serializeObjectToString(Object object, String encoding) {
        if (encoding == null) {
            encoding = System.getProperty("file.encoding", "UTF8");
        }
        CharArrayWriter writer = new CharArrayWriter();
        XMLSerializer xmlSerializer = new XMLSerializer();
        XMLSerializerWriter xmlWriter = new XMLSerializerWriter(writer, (Serializer)xmlSerializer, encoding);
        xmlWriter.write("<?xml version=\"1.0\" encoding=\"");
        xmlWriter.write(encoding);
        xmlWriter.write("\" ?>");
        xmlWriter.println();
        xmlWriter.write("object", DynamicObject.valueOf(object));
        return writer.toString();
    }
}

