/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.data;

import fuego.directory.msg.DirectoryMsg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Migrator;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum Frequency implements I18nProvider,
Migrator
{
    DAILY(DirectoryMsg.DAILY){

        @Override
        public Interval getInterval() {
            Interval interval = new Interval();
            interval.addDays(1);
            return interval;
        }
    }
    ,
    WEEKLY(DirectoryMsg.WEEKLY){

        @Override
        public Interval getInterval() {
            Interval interval = new Interval();
            interval.addDays(7);
            return interval;
        }
    }
    ,
    FORTNIGHTLY(DirectoryMsg.FORTNIGHTLY){

        @Override
        public Interval getInterval() {
            Interval interval = new Interval();
            interval.addDays(15);
            return interval;
        }
    }
    ,
    MONTHLY(DirectoryMsg.MONTHLY){

        @Override
        public Interval getInterval() {
            Interval interval = new Interval();
            interval.addMonths(1);
            return interval;
        }
    }
    ,
    QUARTERLY(DirectoryMsg.QUARTERLY){

        @Override
        public Interval getInterval() {
            Interval interval = new Interval();
            interval.addMonths(3);
            return interval;
        }
    }
    ,
    EVERY_FOUR_MONTHS(DirectoryMsg.EVERY_FOUR_MONTHS){

        @Override
        public Interval getInterval() {
            Interval interval = new Interval();
            interval.addMonths(4);
            return interval;
        }
    }
    ,
    HALF_YEARLY(DirectoryMsg.HALF_YEARLY){

        @Override
        public Interval getInterval() {
            Interval interval = new Interval();
            interval.addMonths(6);
            return interval;
        }
    }
    ,
    YEARLY(DirectoryMsg.YEARLY){

        @Override
        public Interval getInterval() {
            Interval interval = new Interval();
            interval.addYears(1);
            return interval;
        }
    };

    private transient Msg msg;

    private Frequency(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public Interval getInterval() {
        return new Interval();
    }

    @Override
    public Enum migrate(String value) {
        if (value.equals("SEMESTRAL")) {
            value = "HALF_YEARLY";
        } else if (value.equals("TRIMESTRAL")) {
            value = "QUARTERLY";
        } else if (value.equals("ANNUAL")) {
            value = "YEARLY";
        }
        return Frequency.valueOf(value);
    }

    public static Collection<Frequency> getBAMSnapshotResolutionValidFrequencies() {
        ArrayList<Frequency> list = new ArrayList<Frequency>();
        list.add(DAILY);
        list.add(WEEKLY);
        list.add(FORTNIGHTLY);
        list.add(MONTHLY);
        return list;
    }

    public static Collection<Frequency> getBAMSnapshotDisposingValidFrequencies() {
        ArrayList<Frequency> list = new ArrayList<Frequency>();
        list.add(MONTHLY);
        list.add(QUARTERLY);
        list.add(EVERY_FOUR_MONTHS);
        list.add(HALF_YEARLY);
        list.add(YEARLY);
        return list;
    }
}

