/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.data;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class EngineAccessInfo {
    public String address;
    public int maxConnections;
    public int port;
    public String protocol;
    public int sessionTimeout;
    public static final int DEFAULT_PORT = 10099;
    public static final int DEFAULT_SESSION_TIMEOUT = 60;
    public static final int DEFAULT_MAX_CONNECTIONS = 100;

    public EngineAccessInfo() {
    }

    public EngineAccessInfo(String protocol, String address, int port, int sessionTimeout, int maxConnections) {
        this.protocol = protocol;
        this.address = address;
        this.port = port;
        this.sessionTimeout = sessionTimeout;
        this.maxConnections = maxConnections;
    }

    public static EngineAccessInfo createDefaultInfo(String hostName) {
        return new EngineAccessInfo("ssl", hostName, 10099, 60, 100);
    }

    public static EngineAccessInfo createDefaultLocalInfo(String hostName) {
        return new EngineAccessInfo("local", hostName, 10099, 60, 100);
    }

    public String getAddress() {
        try {
            if (this.address != null && this.address.equals("$LOCALHOST$")) {
                this.address = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return this.address;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public String getUrl() {
        return this.getProtocol() + "://" + this.getAddress() + ":" + this.getPort();
    }

    public String toString() {
        return "EngineAccessInfo[protocol=" + this.protocol + ", address=" + this.address + ", port=" + this.port + ", sessionTimeout=" + this.sessionTimeout + ", maxConnections= " + this.maxConnections + "]";
    }
}

