/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.validator;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.IntegerPreference;
import fuego.prefs.Preference;
import fuego.prefs.validator.PrefValidator;
import oracle.bpm.resources.Msg;

public class IntegerValidator
implements PrefValidator {
    int highWarningValue;
    int inc;
    int lowWarningValue;
    int max;
    int min;

    public IntegerValidator(int max, int min, int increment) {
        this(max, min, increment, max, min);
    }

    public IntegerValidator(int max, int min, int increment, int highWarningValue, int lowWarningValue) {
        this.max = max;
        this.min = min;
        this.inc = increment;
        this.lowWarningValue = lowWarningValue;
        this.highWarningValue = highWarningValue;
    }

    public int getLowWarningValue() {
        return this.lowWarningValue;
    }

    public int getHighWarningValue() {
        return this.highWarningValue;
    }

    @Override
    public Msg getErrorMsg(String value) {
        return this.getErrorMsg(Integer.parseInt(value));
    }

    @Override
    public Msg getErrorMsg(Preference preference) {
        assert (!this.validate(preference));
        int value = ((IntegerPreference)preference).getValue();
        return this.getErrorMsg(value);
    }

    public int getIncrement() {
        return this.inc;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public boolean validate(Preference ep) {
        return this.validate(((IntegerPreference)ep).getValue());
    }

    @Override
    public boolean validate(String value) {
        return this.validate(Integer.parseInt(value));
    }

    private Msg getErrorMsg(int value) {
        if (value > this.max) {
            return DirectoryMsg.HIGHER_THAN_MAXIMUM(this.max);
        }
        if (value < this.min) {
            return DirectoryMsg.LOWER_THAN_MINIMUM(this.min);
        }
        assert (false) : "Unreachable reached!!!";
        return null;
    }

    private boolean validate(int value) {
        return value >= this.min && value <= this.max;
    }
}

