/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.standalone;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.BooleanPreference;
import fuego.prefs.CategoryPreference;
import fuego.prefs.IntegerPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.validator.ArgumentsValidator;
import fuego.prefs.validator.ErrorMsg;
import oracle.bpm.resources.Msg;

public class StandaloneStartupPreferences
extends CategoryPreference {
    protected StringPreference arguments;
    protected BooleanPreference autoStartable = new BooleanPreference("autoStartable", this, DirectoryMsg.AUTOSTARTABLE, null, null, false);
    protected StringPreference javaArguments;
    private BooleanPreference shutDownServiceEnabled;
    private IntegerPreference shutDownServicePort;
    public static final boolean AUTOSTARTABLE_DEF = false;
    public static final String ARGUMENTS_DEF = "";
    public static final String JAVA_ARGUMENTS = "";
    public static final boolean SHUT_DOWN_SERVICE_ENABLE_DEF = Boolean.getBoolean("fuego.engine.shutdownservice.enabled");
    public static final int SHUT_DOWN_SERVICE_PORT_DEF = StandaloneStartupPreferences.getDefaultStopServicePort();

    public StandaloneStartupPreferences(CategoryPreference parent) {
        this("startup", parent, null, null, null);
    }

    public StandaloneStartupPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        super(id, parent, label, help, hint);
        this.autoStartable.setModifiableInRuntime(false);
        this.arguments = new StringPreference("arguments", (CategoryPreference)this, DirectoryMsg.START_ARGUMENTS, null, null, new ArgumentsValidator(DirectoryMsg.INVALID_START_ARGUMENTS), "");
        this.arguments.setModifiableInRuntime(false);
        this.javaArguments = new StringPreference("javaArguments", (CategoryPreference)this, DirectoryMsg.JAVA_START_ARGUMENTS, null, null, new ArgumentsValidator(DirectoryMsg.INVALID_START_JAVA_ARGUMENTS), "");
        this.shutDownServiceEnabled = new BooleanPreference("shutDownServiceEnabled", this, DirectoryMsg.SHUT_DOWN_SERVICE_ENABLE, null, null, SHUT_DOWN_SERVICE_ENABLE_DEF);
        this.shutDownServicePort = new IntegerPreference("shutDownServicePort", (CategoryPreference)this, null, null, null, null, SHUT_DOWN_SERVICE_PORT_DEF);
        this.javaArguments.setModifiableInRuntime(false);
    }

    public StringPreference getArguments() {
        return this.arguments;
    }

    public BooleanPreference getAutoStartable() {
        return this.autoStartable;
    }

    public StringPreference getJavaArguments() {
        return this.javaArguments;
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = this.autoStartable.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.arguments.validate();
        if (msg != null) {
            return msg;
        }
        return this.javaArguments.validate();
    }

    public BooleanPreference getShutDownServiceEnabled() {
        return this.shutDownServiceEnabled;
    }

    public IntegerPreference getShutDownServicePort() {
        return this.shutDownServicePort;
    }

    private static int getDefaultStopServicePort() {
        int result;
        int defaultValue = 10101;
        String portValue = System.getProperty("fuego.engine.shutdownservice.port");
        if (portValue == null) {
            result = defaultValue;
        } else {
            try {
                result = Integer.parseInt(portValue);
            }
            catch (NumberFormatException e) {
                result = defaultValue;
            }
        }
        return result;
    }
}

