/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.standalone;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.CategoryPreference;
import fuego.prefs.IntegerPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.validator.ErrorMsg;
import oracle.bpm.resources.Msg;

public class StandaloneAccessInfoPreferences
extends CategoryPreference {
    protected IntegerPreference externalRequestQueueSize;
    protected IntegerPreference handshakeTimeout;
    protected IntegerPreference maxConnectionsPerEngine;
    protected IntegerPreference maxConnectionsPerExternalAgent;
    protected IntegerPreference maxExternalRequestLatency;
    protected IntegerPreference port;
    protected StringPreference protocol = new StringPreference("protocol", this, null, null, null, "ssl");
    protected StringPreference protocolAdditionalParams;
    public static final String PROTOCOL_DEF = "ssl";
    public static final int PORT_DEF = 10099;
    private static final int HANDSHAKE_TIMEOUT_DEF = 60;
    private static final int MAX_CONNECTIONS_PER_ENGINE_DEF = 50;
    private static final int MAX_CONNECTIONS_PER_EXTERNAL_AGENT_DEF = 5;
    private static final int MAX_EXTERNAL_REQUEST_LATENCY_DEF = 30;
    private static final int MIN_MAX_EXTERNAL_REQUEST_LATENCY = 1;
    private static final int EXTERNAL_REQUEST_QUEUE_SIZE_DEF = 300;

    public StandaloneAccessInfoPreferences(String id, CategoryPreference parent) {
        this(id, parent, null, null, null);
    }

    public StandaloneAccessInfoPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        super(id, parent, label, help, hint);
        this.port = new IntegerPreference("port", this, null, null, null, 10099, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
        this.externalRequestQueueSize = new IntegerPreference("externalRequestQueueSize", this, DirectoryMsg.EXTERNAL_REQUEST_QUEUE_SIZE, null, null, 300, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
        this.maxExternalRequestLatency = new IntegerPreference("maxExternalRequestLatency", this, DirectoryMsg.MAX_EXTERNAL_REQUEST_LATENCY, null, DirectoryMsg.SECONDS, 30, 1, Integer.MAX_VALUE, 1);
        this.maxConnectionsPerExternalAgent = new IntegerPreference("maxConnectionsPerExternalAgent", this, DirectoryMsg.MAX_CONNECTIONS_PER_EXTERNAL_AGENT, null, null, 5, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
        this.maxConnectionsPerEngine = new IntegerPreference("maxConnectionsPerEngine", this, DirectoryMsg.MAX_CONNECTIONS_PER_ENGINE, null, null, 50, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
        this.handshakeTimeout = new IntegerPreference("handshakeTimeout", this, DirectoryMsg.HANDSHAKE_TIMEOUT, null, DirectoryMsg.SECONDS, 60, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
        this.protocolAdditionalParams = new StringPreference("protocolAdditionalParams", this, null, null, null, "");
    }

    public IntegerPreference getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public IntegerPreference getMaxConnectionsPerEngine() {
        return this.maxConnectionsPerEngine;
    }

    public IntegerPreference getMaxConnectionsPerExternalAgent() {
        return this.maxConnectionsPerExternalAgent;
    }

    public IntegerPreference getPort() {
        return this.port;
    }

    public StringPreference getProtocol() {
        return this.protocol;
    }

    public StringPreference getProtocolAdditionalParams() {
        return this.protocolAdditionalParams;
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = this.externalRequestQueueSize.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.handshakeTimeout.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.maxConnectionsPerEngine.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.maxConnectionsPerExternalAgent.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.maxExternalRequestLatency.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.port.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.protocol.validate();
        if (msg != null) {
            return msg;
        }
        return this.protocolAdditionalParams.validate();
    }
}

