/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.j2ee;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.BooleanPreference;
import fuego.prefs.CategoryPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.engine.EngineType;
import fuego.prefs.engine.base.BaseBAMPreferences;
import fuego.prefs.engine.base.BaseDisposerPreferences;
import fuego.prefs.engine.base.BaseEngineLocationPreferences;
import fuego.prefs.engine.base.BaseEnginePreferences;
import fuego.prefs.engine.base.BaseExecutionPreferences;
import fuego.prefs.engine.base.BaseIPCPreferences;
import fuego.prefs.engine.base.BaseJMXPreferences;
import fuego.prefs.engine.base.BaseLogPreferences;
import fuego.prefs.engine.base.BaseMemoryPreferences;
import fuego.prefs.engine.base.BaseNetworkingPreferences;
import fuego.prefs.engine.base.BasePAPIPreferences;
import fuego.prefs.engine.base.BaseRoundTripPreferences;
import fuego.prefs.engine.base.BaseSNMPPreferences;
import fuego.prefs.engine.base.BaseTimeoutsPreferences;
import fuego.prefs.engine.base.BaseWSPreferences;
import fuego.prefs.engine.j2ee.J2EEBAMPreferences;
import fuego.prefs.engine.j2ee.J2EEClusterPreferences;
import fuego.prefs.engine.j2ee.J2EEDeploymentPreferences;
import fuego.prefs.engine.j2ee.J2EEDisposerPreferences;
import fuego.prefs.engine.j2ee.J2EEEngineLocationPreferences;
import fuego.prefs.engine.j2ee.J2EEExecutionPreferences;
import fuego.prefs.engine.j2ee.J2EEIPCPreferences;
import fuego.prefs.engine.j2ee.J2EEJMXPreferences;
import fuego.prefs.engine.j2ee.J2EEJmxEngineManagementPreferences;
import fuego.prefs.engine.j2ee.J2EELogPreferences;
import fuego.prefs.engine.j2ee.J2EEMemoryPreferences;
import fuego.prefs.engine.j2ee.J2EENetworkingPreferences;
import fuego.prefs.engine.j2ee.J2EEPAPIPreferences;
import fuego.prefs.engine.j2ee.J2EESNMPPreferences;
import fuego.prefs.engine.j2ee.J2EETimeoutsPreferences;
import fuego.prefs.engine.j2ee.J2EEWSPreferences;
import fuego.prefs.engine.j2ee.websphere.J2EERoundTripPreferences;
import fuego.prefs.engine.storage.EnginePreferencesNode;
import fuego.prefs.validator.ErrorMsg;
import fuego.prefs.validator.PrefValidatorFactory;
import java.util.Map;

public abstract class J2EEEnginePreferences
extends BaseEnginePreferences {
    protected J2EEClusterPreferences clusterPreferences = new J2EEClusterPreferences(this);
    protected J2EEDeploymentPreferences deploymentPreferences = this.createDeploymentPreferences();
    protected StringPreference directoryConfiguration;
    protected BooleanPreference isClusterEnabled;
    protected J2EEJmxEngineManagementPreferences jmxEngineManagementPreferences = this.createJmxEngineManagementPreferences();
    public static final String DIRECTORY_CONFIGURATION_DEF = "";
    public static final boolean IS_CLUSTER_ENABLED_DEF = false;

    protected J2EEEnginePreferences(EngineType engineType, String engineId, String configuration, EnginePreferencesNode root) {
        super(engineType, null, null, null, engineId, configuration, root);
        this.directoryConfiguration = new StringPreference("directoryConfiguration", (CategoryPreference)this, null, null, null, PrefValidatorFactory.createNotEmptyValidator(DirectoryMsg.MISSING_DIRECTORY_CONFIGURATION), DIRECTORY_CONFIGURATION_DEF);
        this.isClusterEnabled = new BooleanPreference("isClusterEnabled", this, null, null, null, false);
    }

    public J2EEBAMPreferences getBAM() {
        return (J2EEBAMPreferences)this.bamPreferences;
    }

    public J2EEClusterPreferences getCluster() {
        return this.clusterPreferences;
    }

    public BooleanPreference getClusterEnabled() {
        return this.isClusterEnabled;
    }

    public J2EEDeploymentPreferences getDeployment() {
        return this.deploymentPreferences;
    }

    public StringPreference getDirectoryConfiguration() {
        return this.directoryConfiguration;
    }

    @Override
    public J2EEDisposerPreferences getDisposer() {
        return (J2EEDisposerPreferences)this.disposerPreferences;
    }

    public J2EEEngineLocationPreferences getEngineLocation() {
        String localhost = this.getLocalhost();
        Map<String, BaseEngineLocationPreferences> locations = this.getLocationsMap();
        assert (locations.size() == 1 && locations.containsKey(localhost)) : "J2EE engine supports only one location";
        return (J2EEEngineLocationPreferences)locations.get(localhost);
    }

    public J2EEJmxEngineManagementPreferences getJmxEngineManagement() {
        return this.jmxEngineManagementPreferences;
    }

    @Override
    public J2EEExecutionPreferences getExecution() {
        return (J2EEExecutionPreferences)this.executionPreferences;
    }

    public J2EEIPCPreferences getIPC() {
        return (J2EEIPCPreferences)this.ipcPreferences;
    }

    public J2EEJMXPreferences getJMX() {
        return (J2EEJMXPreferences)this.jmxPreferences;
    }

    @Override
    public J2EELogPreferences getLog() {
        return (J2EELogPreferences)this.logPreferences;
    }

    @Override
    public J2EEMemoryPreferences getMemory() {
        return (J2EEMemoryPreferences)this.memoryPreferences;
    }

    @Override
    public J2EENetworkingPreferences getNetworking() {
        return (J2EENetworkingPreferences)this.networkingPreferences;
    }

    public J2EEPAPIPreferences getPapi() {
        return (J2EEPAPIPreferences)this.papiPreferences;
    }

    public J2EESNMPPreferences getSNMP() {
        return (J2EESNMPPreferences)this.snmpPreferences;
    }

    @Override
    public J2EETimeoutsPreferences getTimeouts() {
        return (J2EETimeoutsPreferences)this.timeoutsPreferences;
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = super.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.isClusterEnabled.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.clusterPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.deploymentPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.jmxEngineManagementPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.directoryConfiguration.validate();
        if (msg != null) {
            return msg;
        }
        return null;
    }

    protected abstract J2EEDeploymentPreferences createDeploymentPreferences();

    protected abstract J2EEJmxEngineManagementPreferences createJmxEngineManagementPreferences();

    @Override
    protected BaseBAMPreferences createBamPreferences() {
        return new J2EEBAMPreferences(this);
    }

    @Override
    protected BaseDisposerPreferences createDisposerPreferences() {
        return new J2EEDisposerPreferences(this);
    }

    @Override
    protected BaseRoundTripPreferences createRoundTripPreferences() {
        return new J2EERoundTripPreferences(this);
    }

    @Override
    protected BaseEngineLocationPreferences createEngineLocationPreferences(String localhost) {
        return new J2EEEngineLocationPreferences(localhost, this);
    }

    @Override
    protected BaseExecutionPreferences createExecutionPreferences() {
        return new J2EEExecutionPreferences(this);
    }

    @Override
    protected BaseIPCPreferences createIpcPreferences() {
        return new J2EEIPCPreferences(this);
    }

    @Override
    protected BaseJMXPreferences createJmxPreferences() {
        return new J2EEJMXPreferences(this);
    }

    @Override
    protected BaseLogPreferences createLogPreferences() {
        return new J2EELogPreferences(this);
    }

    @Override
    protected BaseMemoryPreferences createMemoryPreferences() {
        return new J2EEMemoryPreferences(this);
    }

    @Override
    protected BaseNetworkingPreferences createNetworkingPreferences() {
        return new J2EENetworkingPreferences(this);
    }

    @Override
    protected BasePAPIPreferences createPapiPreferences() {
        return new J2EEPAPIPreferences(this);
    }

    @Override
    protected BaseSNMPPreferences createSnmpPreferences() {
        return new J2EESNMPPreferences(this);
    }

    @Override
    protected BaseTimeoutsPreferences createTimeoutPreferences() {
        return new J2EETimeoutsPreferences(this);
    }

    @Override
    protected BaseWSPreferences createWSPreferences() {
        return new J2EEWSPreferences(this);
    }
}

