/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.base;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.BooleanPreference;
import fuego.prefs.CategoryPreference;
import fuego.prefs.IntegerPreference;
import fuego.prefs.LocalhostPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.validator.ErrorMsg;
import oracle.bpm.resources.Msg;

public abstract class BaseSNMPPreferences
extends CategoryPreference {
    protected IntegerPreference agentPort;
    protected IntegerPreference logLevel;
    protected StringPreference managerHost;
    protected IntegerPreference managerPort;
    protected StringPreference readCommunity;
    protected BooleanPreference serviceEnabled = new BooleanPreference("serviceEnabled", this, DirectoryMsg.SNMP_SERVICE_ENABLED, null, null, false);
    protected StringPreference writeCommunity;
    public static final boolean SERVICE_ENABLED_DEF = false;
    public static final int AGENT_PORT_DEF = 161;
    public static final int MANAGER_PORT_DEF = 162;
    public static final String READ_COMMUNITY = "<encrypted>gKamANwB";
    public static final String WRITE_COMMUNITY = "<encrypted>gH3ihhFgHQ==";

    public BaseSNMPPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        super(id, parent, label, help, hint);
        this.serviceEnabled.setModifiableInRuntime(false);
        this.agentPort = new IntegerPreference("agentPort", this, DirectoryMsg.SNMP_AGENT_PORT, null, null, 161, 1, 65535, 10);
        this.agentPort.setModifiableInRuntime(false);
        this.managerPort = new IntegerPreference("managerPort", this, DirectoryMsg.SNMP_MANAGER_PORT, null, null, 162, 1, 65535, 10);
        this.managerPort.setModifiableInRuntime(false);
        this.managerHost = new StringPreference("managerHost", this, DirectoryMsg.SNMP_MANAGER_HOST, null, null, LocalhostPreference.getLocalhost());
        this.managerHost.setModifiableInRuntime(false);
        this.readCommunity = new StringPreference("readCommunity", this, DirectoryMsg.SNMP_READ_COMMUNITY, null, DirectoryMsg.SNMP_COMMUNITY_HINT, READ_COMMUNITY);
        this.readCommunity.setModifiableInRuntime(false);
        this.writeCommunity = new StringPreference("writeCommunity", this, DirectoryMsg.SNMP_WRITE_COMMUNITY, null, DirectoryMsg.SNMP_COMMUNITY_HINT, WRITE_COMMUNITY);
        this.writeCommunity.setModifiableInRuntime(false);
        this.logLevel = new IntegerPreference("logLevel", this, DirectoryMsg.SNMP_LOG_LEVEL, null, null, 3, 1, 10, 1);
        this.logLevel.setModifiableInRuntime(false);
    }

    protected BaseSNMPPreferences(CategoryPreference parent) {
        this("snmp", parent, null, null, null);
    }

    public IntegerPreference getAgentPort() {
        return this.agentPort;
    }

    public StringPreference getManagerHost() {
        return this.managerHost;
    }

    public IntegerPreference getManagerPort() {
        return this.managerPort;
    }

    public BooleanPreference getServiceEnabled() {
        return this.serviceEnabled;
    }

    public StringPreference getReadCommunity() {
        return this.readCommunity;
    }

    public StringPreference getWriteCommunity() {
        return this.writeCommunity;
    }

    public IntegerPreference getLogLevel() {
        return this.logLevel;
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = this.serviceEnabled.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.agentPort.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.managerPort.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.managerHost.validate();
        if (msg != null) {
            return msg;
        }
        if (this.serviceEnabled.getValue() && (this.managerHost.getValue() == null || "".equals(this.managerHost.getValue()))) {
            return new ErrorMsg(DirectoryMsg.SNMP_MANAGER_HOST_NOT_NULL);
        }
        return null;
    }
}

