/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.base;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.BooleanPreference;
import fuego.prefs.CategoryPreference;
import fuego.prefs.IntegerPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.validator.ErrorMsg;
import java.util.regex.Pattern;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;

public abstract class BaseExecutionPreferences
extends CategoryPreference {
    protected BooleanPreference greedyExecutionMode;
    protected IntegerPreference maxAcquiredInstances;
    protected BooleanPreference persistInstanceData;
    protected IntegerPreference retryInterval;
    protected IntegerPreference retryTimes = new IntegerPreference("retryTimes", this, DirectoryMsg.RETRY_TIMES, null, null, 3, 0, 100, 1);
    protected BooleanPreference traceComponents;
    protected StringPreference tracePattern;
    public static final int RETRY_TIMES_DEF = 3;
    public static final int RETRY_INTERVAL_DEF = 600;
    public static final boolean TRACE_COMPONENTS_DEF = false;
    public static final boolean GREEDY_MODE_DEFAULT_VALUE = Boolean.getBoolean("fuego.engine.greedy");
    public static final int MAX_ACQUIRED_INSTANCES_DEF = 1000;
    public static final boolean PERSIST_INSTANCE_DATA_DEF = Boolean.getBoolean("persistInstanceData");

    public BaseExecutionPreferences(CategoryPreference parent) {
        this("execution", parent, null, null, null);
    }

    public BaseExecutionPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        super(id, parent, label, help, hint);
        this.retryInterval = new IntegerPreference("retryInterval", this, DirectoryMsg.RETRY_INTERVAL, null, CoreMsg.SECONDS, 600, 15, 100000, 15);
        this.traceComponents = new BooleanPreference("traceComponents", this, DirectoryMsg.TRACE_COMPONENTS, null, null, false);
        this.tracePattern = new StringPreference("tracePattern", this, DirectoryMsg.TRACE_PATTERN, null, null, ""){

            @Override
            public ErrorMsg validate() {
                return this.validate(this.getValue());
            }

            @Override
            public ErrorMsg validate(String value) {
                ErrorMsg error = null;
                try {
                    Pattern.compile(value);
                    error = null;
                }
                catch (Exception e) {
                    error = new ErrorMsg(DirectoryMsg.INVALID_TRACE_PATTERN(value, e.getMessage()));
                }
                return error;
            }
        };
        this.maxAcquiredInstances = new IntegerPreference("maxAcquiredInstances", this, DirectoryMsg.MAX_ACQUIRED_INSTANCES, null, null, 1000, 5, 100000, 1);
        this.persistInstanceData = new BooleanPreference("persistInstanceData", this, DirectoryMsg.PERSIST_INSTANCE_DATA, null, null, PERSIST_INSTANCE_DATA_DEF);
        this.greedyExecutionMode = new BooleanPreference("greedyExecutionMode", this, DirectoryMsg.GREEDY_EXECUTION_MODE, null, null, GREEDY_MODE_DEFAULT_VALUE);
    }

    public BooleanPreference getPersistInstanceData() {
        return this.persistInstanceData;
    }

    public IntegerPreference getRetryInterval() {
        return this.retryInterval;
    }

    public IntegerPreference getRetryTimes() {
        return this.retryTimes;
    }

    public BooleanPreference getTraceComponents() {
        return this.traceComponents;
    }

    public StringPreference getTracePattern() {
        return this.tracePattern;
    }

    public IntegerPreference getMaxAcquiredInstances() {
        return this.maxAcquiredInstances;
    }

    public BooleanPreference getGreedyExecutionMode() {
        return this.greedyExecutionMode;
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = this.traceComponents.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.retryInterval.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.tracePattern.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.retryTimes.validate();
        if (msg != null) {
            return msg;
        }
        return this.maxAcquiredInstances.validate();
    }
}

