/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine;

import fuego.prefs.engine.base.BaseEnginePreferences;
import fuego.prefs.engine.j2ee.jboss.JBossEnginePreferences;
import fuego.prefs.engine.j2ee.oracleas.OracleasEnginePreferences;
import fuego.prefs.engine.j2ee.weblogic.WeblogicEnginePreferences;
import fuego.prefs.engine.j2ee.websphere.WebsphereEnginePreferences;
import fuego.prefs.engine.standalone.enterprise.EnterpriseEnginePreferences;
import fuego.prefs.engine.standalone.express.ExpressEnginePreferences;
import fuego.prefs.engine.standalone.studio.StudioEnginePreferences;
import fuego.prefs.engine.storage.EnginePreferencesNode;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.util.Feature;

public enum EngineType {
    ENTERPRISE{

        @Override
        public BaseEnginePreferences createPreferences(String engineId, String configuration, EnginePreferencesNode root) {
            return new EnterpriseEnginePreferences(engineId, configuration, root);
        }

        @Override
        public Feature getFeature() {
            return Feature.ENGINE_ENTERPRISE;
        }
    }
    ,
    STUDIO{

        @Override
        public BaseEnginePreferences createPreferences(String engineId, String configuration, EnginePreferencesNode root) {
            return new StudioEnginePreferences(engineId, configuration, root);
        }

        @Override
        public Feature getFeature() {
            return Feature.ENGINE_STUDIO;
        }
    }
    ,
    EXPRESS{

        @Override
        public BaseEnginePreferences createPreferences(String engineId, String configuration, EnginePreferencesNode root) {
            return new ExpressEnginePreferences(engineId, configuration, root);
        }

        @Override
        public Feature getFeature() {
            return Feature.ENGINE_EXPRESS;
        }
    }
    ,
    J2EE_JBOSS{

        @Override
        public BaseEnginePreferences createPreferences(String engineId, String configuration, EnginePreferencesNode root) {
            return new JBossEnginePreferences(engineId, configuration, root);
        }

        @Override
        public Feature getFeature() {
            return Feature.ENGINE_J2EE_JBOSS;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }
    ,
    J2EE_ORACLEAS{

        @Override
        public BaseEnginePreferences createPreferences(String engineId, String configuration, EnginePreferencesNode root) {
            return new OracleasEnginePreferences(engineId, configuration, root);
        }

        @Override
        public Feature getFeature() {
            return Feature.ENGINE_J2EE_ORACLEAS;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }
    ,
    J2EE_WEBSPHERE{

        @Override
        public BaseEnginePreferences createPreferences(String engineId, String configuration, EnginePreferencesNode root) {
            return new WebsphereEnginePreferences(engineId, configuration, root);
        }

        @Override
        public Feature getFeature() {
            return Feature.ENGINE_J2EE_WEBSPHERE;
        }
    }
    ,
    J2EE_WEBLOGIC{

        @Override
        public BaseEnginePreferences createPreferences(String engineId, String configuration, EnginePreferencesNode root) {
            return new WeblogicEnginePreferences(engineId, configuration, root);
        }

        @Override
        public Feature getFeature() {
            return Feature.ENGINE_J2EE_WEBLOGIC;
        }
    };


    public boolean isEmbedded() {
        return this == STUDIO || this == EXPRESS;
    }

    public boolean isEnterprise() {
        return this == ENTERPRISE;
    }

    public boolean isStandalone() {
        return this.isEmbedded() || this.isEnterprise();
    }

    public boolean isJ2EE() {
        return this == J2EE_JBOSS || this == J2EE_WEBSPHERE || this == J2EE_WEBLOGIC || this == J2EE_ORACLEAS;
    }

    public String getShortName() {
        if (this.isJ2EE()) {
            return this.name().substring(5).toLowerCase();
        }
        return this.name().toLowerCase();
    }

    public String getEngineAccessClassName() {
        return this.isJ2EE() ? "fuego.papi.impl.j2ee.J2EEEngineAccessImpl" : "fuego.papi.impl.rmi.RMIEngineAccessImpl";
    }

    private String getAdminEngineAccessClassName() {
        return this.isJ2EE() ? "fuego.mami.engine.j2ee.J2EEAdminEngineAccessImpl" : "fuego.mami.engine.rmi.RMIAdminEngineAccessImpl";
    }

    public Object createAdminEngineAccess(Class[] parameterTypes, Object[] initArgs) throws Exception {
        return this.createObject(this.getAdminEngineAccessClassName(), parameterTypes, initArgs);
    }

    public Object createEngineAccess(Class[] parameterTypes, Object[] initArgs) throws Exception {
        return this.createObject(this.getEngineAccessClassName(), parameterTypes, initArgs);
    }

    private Object createObject(String className, Class[] parameterTypes, Object[] initArgs) throws Exception {
        Class<?> engineAccessClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        Constructor<?> constructor = engineAccessClass.getConstructor(parameterTypes);
        return constructor.newInstance(initArgs);
    }

    public abstract BaseEnginePreferences createPreferences(String var1, String var2, EnginePreferencesNode var3);

    public boolean isEnabled() {
        return this.getFeature().isEnabled();
    }

    public boolean isClusterEnabled() {
        return !this.isStandalone();
    }

    public abstract Feature getFeature();

    public static List<EngineType> getEnabledValues() {
        EngineType[] etypes = EngineType.values();
        ArrayList<EngineType> enabledValues = new ArrayList<EngineType>();
        for (int i = 0; i < etypes.length; ++i) {
            EngineType engineType = etypes[i];
            if (engineType.isEmbedded() || !engineType.isEnabled()) continue;
            enabledValues.add(engineType);
        }
        return enabledValues;
    }
}

