/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs;

import fuego.prefs.CategoryPreference;
import fuego.prefs.Preference;
import fuego.prefs.validator.ErrorMsg;
import fuego.prefs.validator.PrefValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.resources.Msg;

public abstract class ValueHolderPreference
extends Preference {
    protected PrefValidator validator;
    private String cachedValue;
    private String defaultValue;
    private boolean isModifiableInRuntime;
    private List<String> oldNames;

    public ValueHolderPreference(String name, CategoryPreference parent, Msg label, Msg help, Msg hint, PrefValidator validator, String defaultValue) {
        super(name, parent, label, help, hint);
        this.defaultValue = defaultValue;
        this.validator = validator;
        this.isModifiableInRuntime = true;
        this.oldNames = new ArrayList<String>();
    }

    public ValueHolderPreference(String name, CategoryPreference parent, Msg label, Msg help, Msg hint, PrefValidator validator, String defaultValue, String[] oldNames) {
        this(name, parent, label, help, hint, validator, defaultValue);
        this.oldNames = Arrays.asList(oldNames);
    }

    public ValueHolderPreference(String name, CategoryPreference parent, Msg label, Msg help, Msg hint, PrefValidator validator, String defaultValue, String oldName) {
        this(name, parent, label, help, hint, validator, defaultValue, new String[]{oldName});
    }

    public void setModifiableInRuntime(boolean modifiableInRuntime) {
        this.isModifiableInRuntime = modifiableInRuntime;
    }

    public boolean isModifiableInRuntime() {
        return this.isModifiableInRuntime;
    }

    public String getStringDefaultValue() {
        return this.defaultValue;
    }

    public void setStringValue(String value) {
        if (value != null) {
            this.cachedValue = value;
            this.getParent().put(this.getName(), value);
            this.getRoot().setExport(true);
        }
    }

    public String getStringValue() {
        if (this.cachedValue == null) {
            String value = this.getParent().get(this.getName(), null);
            if (value == null) {
                for (String prefName : this.oldNames) {
                    value = this.getParent().get(prefName, null);
                    if (value == null) continue;
                    break;
                }
                if (value == null) {
                    value = this.defaultValue;
                }
            }
            this.cachedValue = value;
        }
        return this.cachedValue;
    }

    public void restoreToDefault() {
        boolean export = this.getRoot().getExport();
        this.setStringValue(this.getStringDefaultValue());
        this.getRoot().setExport(export);
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public ErrorMsg validate() {
        return this.validator == null || this.validator.validate(this) ? null : new ErrorMsg(this.validator.getErrorMsg(this));
    }

    @Override
    public ErrorMsg validate(String value) {
        return this.validator == null || this.validator.validate(value) ? null : new ErrorMsg(this.validator.getErrorMsg(value));
    }
}

