/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs;

import fuego.prefs.CategoryPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.validator.EnumValidator;
import oracle.bpm.lang.Migrator;
import oracle.bpm.resources.Msg;

public abstract class EnumPreferences
extends StringPreference {
    private Enum defaultValue;

    public EnumPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint, Enum defaultValue) {
        super(id, parent, label, help, hint, new EnumValidator(EnumPreferences.getArrayFromEnum(defaultValue), defaultValue), defaultValue.toString());
        this.defaultValue = defaultValue;
    }

    public abstract Enum getEnumValue();

    public abstract void setEnumValue(Enum var1);

    @Override
    public String getValue() {
        String value = super.getValue();
        if (this.defaultValue instanceof Migrator) {
            Enum newValue = ((Migrator)((Object)this.defaultValue)).migrate(value);
            value = newValue.toString();
        }
        return value;
    }

    private static String[] getArrayFromEnum(Enum defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultvalue required");
        }
        Enum[] enums = (Enum[])defaultValue.getClass().getEnumConstants();
        String[] values = new String[enums.length];
        for (int i = 0; i < enums.length; ++i) {
            values[i] = enums[i].toString();
        }
        return values;
    }
}

