/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.util;

import fuego.directory.msg.DirectoryMsg;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.lang.Id;
import oracle.bpm.log.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaVersionParser
extends DefaultHandler {
    private String currentSchemaVersion = Id.getVersionTag();
    private File parseFile_d;
    public static final String FINISH_FLAG = "finished-parsing";
    public static final String VERSION_41 = "4.1";
    public static final String VERSION_42 = "4.2";
    public static final String VERSION_45 = "4.5";
    public static final String SCHEMA_VERSION = "SchemaVersion";
    public static final String SCHEMA_ID = "SchemaId";
    public static final String ORGANIZATION_NAME = "Organization";

    private SchemaVersionParser(String inFileName) {
        this.parseFile_d = new File(inFileName);
    }

    public static String getSchemaVersion(String fileName) {
        SchemaVersionParser parser = new SchemaVersionParser(fileName);
        parser.parseExportFile();
        return parser.currentSchemaVersion;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        super.error(e);
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if (qName.equalsIgnoreCase("FDIObject")) {
            this.currentSchemaVersion = attrs.getValue(SCHEMA_VERSION);
            throw new RuntimeException(FINISH_FLAG);
        }
        if (qName.equalsIgnoreCase("java.util.HashMap")) {
            this.currentSchemaVersion = VERSION_41;
            throw new RuntimeException(FINISH_FLAG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseExportFile() {
        FileInputStream source = null;
        try {
            source = new FileInputStream(this.parseFile_d);
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            InputSource inputSource = new InputSource(source);
            saxParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            Log.logWarning(DirectoryMsg.DII_00003);
            Log.logInfo(e);
        }
        catch (SAXException e) {
            if (e.getException() != null && e.getException() instanceof RuntimeException) {
                if (e.getException().getMessage().equals(FINISH_FLAG)) {
                    return;
                }
                Log.logWarning(DirectoryMsg.DII_00003);
                Log.logInfo(e);
            }
        }
        catch (IOException e) {
            Log.logWarning(DirectoryMsg.DII_00003);
            Log.logInfo(e);
        }
        finally {
            if (source != null) {
                try {
                    ((InputStream)source).close();
                }
                catch (IOException ignore) {}
            }
        }
        this.currentSchemaVersion = Id.getVersionTag();
    }
}

