/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider.notifiers;

import fuego.directory.DirObject;
import fuego.directory.DirectoryException;
import fuego.directory.provider.notifiers.DirectoryEventGeneratorImpl;
import fuego.directory.provider.notifiers.DirectoryNotificationEvent;
import java.util.List;
import oracle.bpm.lang.Time;

public class DirectoryObjectProxy {
    private DirectoryEventGeneratorImpl generator;
    private final String id;
    private final int in;
    private final Time modified;
    private final Comparable ownerId;
    private final boolean propertyProxy;

    private DirectoryObjectProxy(DirectoryEventGeneratorImpl generator, Time modified, String id, int in, boolean propertyProxy, Comparable ownerId) {
        this.generator = generator;
        this.modified = modified;
        this.id = id;
        this.propertyProxy = propertyProxy;
        this.in = in;
        this.ownerId = ownerId;
    }

    public static DirectoryObjectProxy createObjectProxy(DirectoryEventGeneratorImpl generator, Time modified, String id, int in, Comparable ownerId) {
        return new DirectoryObjectProxy(generator, modified, id, in, false, ownerId);
    }

    public static DirectoryObjectProxy createPropertiesProxy(DirectoryEventGeneratorImpl generator, Time modified, Comparable ownerId) {
        return new DirectoryObjectProxy(generator, modified, null, -1, true, ownerId);
    }

    public String getId() {
        return this.id;
    }

    public int getIn() {
        return this.in;
    }

    public Time getModified() {
        return this.modified;
    }

    public Comparable getOwnerId() {
        return this.ownerId;
    }

    public boolean isPropertyProxy() {
        return this.propertyProxy;
    }

    public DirectoryNotificationEvent createAddEvent() throws DirectoryException {
        assert (!this.isPropertyProxy()) : "Property proxies cannot create events!";
        DirObject object = this.getObject();
        return DirectoryNotificationEvent.newAddEvent(object, this.generator.getObjectType(), "");
    }

    public DirectoryNotificationEvent createChangeEvent() throws DirectoryException {
        assert (!this.isPropertyProxy()) : "Property proxies cannot create events!";
        DirObject object = this.getObject();
        return DirectoryNotificationEvent.newUpdateEvent(object, this.generator.getObjectType(), "");
    }

    public DirectoryNotificationEvent createDeleteEvent() throws DirectoryException {
        assert (!this.isPropertyProxy()) : "Property proxies cannot create events!";
        return DirectoryNotificationEvent.newDeleteEvent(this.id, this.generator.getObjectType(), "");
    }

    public boolean equals(Object anObject) {
        return anObject instanceof DirectoryObjectProxy && this.toString().equals(anObject.toString());
    }

    public DirectoryObjectProxy findOwnerProxy(List<DirectoryObjectProxy> proxies) {
        assert (this.isPropertyProxy()) : "Object proxies cannot do this!";
        for (DirectoryObjectProxy proxy : proxies) {
            if (proxy.isPropertyProxy() || this.ownerId.compareTo(proxy.ownerId) != 0) continue;
            return proxy;
        }
        return null;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.generator.getObjectType().name() + ":" + (this.isPropertyProxy() ? "Property (id): " + this.ownerId : "Object(in:id): " + this.in + ":" + this.id);
    }

    public boolean wasModifiedSince(Time timestamp) {
        return this.getModified().compareTo(timestamp) > 0;
    }

    private DirObject getObject() throws DirectoryException {
        assert (!this.isPropertyProxy()) : "Property proxies cannot return objects!";
        return this.generator.getObjectType().fetchDirObjectFor(this.generator.getSession(), this.id);
    }
}

