/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider.notifiers;

import fuego.directory.DirObject;
import fuego.directory.provider.notifiers.Constants;
import fuego.directory.provider.notifiers.DirObjectType;

public class DirectoryNotificationEvent
implements Comparable<DirectoryNotificationEvent>,
Constants {
    protected DirObject object;
    final String eventId;
    final String objectId;
    final DirObjectType objectType;
    private final String eventkey;
    private final String eventkeyNoIn;
    private final int eventType;
    private final int objectIn;

    protected DirectoryNotificationEvent(DirObject object, String objectId, DirObjectType objectType, int eventType, String eventId, int objectIn) {
        assert (objectType != null);
        assert (eventId != null);
        assert (eventType == 2 || eventType == 1 || eventType == 4);
        this.eventId = eventId;
        this.eventType = eventType;
        this.object = object;
        this.objectType = objectType;
        this.objectId = objectId;
        this.objectIn = objectIn;
        this.eventkey = objectType.name() + ":@:" + eventType + ":@:" + objectId + ":@:" + objectIn;
        this.eventkeyNoIn = objectType.name() + ":@:" + eventType + ":@:" + objectId + ":@:";
    }

    public static DirectoryNotificationEvent newAddEvent(DirObject object, DirObjectType objectType, String eventId) {
        if (object != null) {
            return new DirectoryNotificationEvent(object, object.getId(), objectType, 2, eventId, objectType.isInConsideredForEvents() ? object.getIn() : -1);
        }
        return null;
    }

    public static DirectoryNotificationEvent newDeleteEvent(String objectId, DirObjectType objectType, String eventId) {
        assert (objectId != null) : "The object id of removed object must not be null to create a delete event";
        return new DirectoryNotificationEvent(null, objectId, objectType, 1, eventId, -1);
    }

    public static DirectoryNotificationEvent newUpdateEvent(DirObject object, DirObjectType objectType, String eventId) {
        if (object != null) {
            return new DirectoryNotificationEvent(object, object.getId(), objectType, 4, eventId, objectType.isInConsideredForEvents() ? object.getIn() : -1);
        }
        return null;
    }

    public boolean isChange() {
        return this.eventType == 4;
    }

    public boolean isCreate() {
        return this.eventType == 2;
    }

    public boolean isDelete() {
        return this.eventType == 1;
    }

    public final int getMask() {
        return this.getObjectType().getMask() | this.getEventType();
    }

    public int getEventType() {
        return this.eventType;
    }

    public DirObject getObject() {
        return this.object;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public int getObjectIn() {
        return this.objectIn;
    }

    public DirObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public int compareTo(DirectoryNotificationEvent o) {
        assert (o != null);
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object o) {
        return o instanceof DirectoryNotificationEvent && this.compareTo((DirectoryNotificationEvent)o) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.eventkey;
    }

    public boolean isSameEventIgnoringIn(DirectoryNotificationEvent otherEvent) {
        return this.eventkeyNoIn.equals(otherEvent.eventkeyNoIn);
    }

    protected String eventId() {
        return this.eventId;
    }

    DirectoryNotificationEvent clone(int newEventType) {
        assert (!this.isDelete()) : "Cannot clone delete events";
        return this.eventType == newEventType ? this : new DirectoryNotificationEvent(this.object, this.objectId, this.objectType, newEventType, this.eventId, newEventType == 1 ? -1 : this.objectIn);
    }
}

