/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider.notifiers;

import fuego.directory.DirObject;
import fuego.directory.DirectoryException;
import fuego.directory.listener.DirectoryListenerInterface;
import fuego.directory.provider.DirectorySessionImpl;
import fuego.directory.provider.notifiers.AddDirectoryNotificationEventMethod;
import fuego.directory.provider.notifiers.BusinessParameterNotifier;
import fuego.directory.provider.notifiers.CalendarRuleNotifier;
import fuego.directory.provider.notifiers.DirObjectNotifier;
import fuego.directory.provider.notifiers.DirectoryEventGenerator;
import fuego.directory.provider.notifiers.DirectoryNotificationEvent;
import fuego.directory.provider.notifiers.HolidayRuleNotifier;
import fuego.directory.provider.notifiers.HumanParticipantNotifier;
import fuego.directory.provider.notifiers.OrganizationalGroupNotifier;
import fuego.directory.provider.notifiers.OrganizationalRoleNotifier;
import fuego.directory.provider.notifiers.PresentationNotifier;
import fuego.directory.provider.notifiers.ProcessVariableNotifier;
import fuego.directory.provider.notifiers.ViewNotifier;
import java.util.List;

public enum DirObjectType {
    OU{

        @Override
        public int getMask() {
            return 2048;
        }
    }
    ,
    ROLE{

        @Override
        public int getMask() {
            return 4096;
        }

        @Override
        public DirectoryEventGenerator createEventGenerator(DirectorySessionImpl session) {
            return session.getOrganizationAccessor().createRoleEventsGenerator();
        }

        @Override
        public DirObject fetchDirObjectFor(DirectorySessionImpl session, String id) throws DirectoryException {
            return session.getOrganizationAccessor().fetchRole(id);
        }

        @Override
        public DirObject fetchDirObjectFor(DirectorySessionImpl session, int in) throws DirectoryException {
            return session.getOrganizationAccessor().fetchRole(in);
        }

        @Override
        public DirObjectNotifier createNotifier(DirectoryListenerInterface listener) {
            return new OrganizationalRoleNotifier(listener);
        }

        @Override
        public boolean isInConsideredForEvents() {
            return true;
        }
    }
    ,
    PARTICIPANT{

        @Override
        public int getMask() {
            return 8192;
        }

        @Override
        public DirectoryEventGenerator createEventGenerator(DirectorySessionImpl session) {
            return session.getParticipantAccessor().createParticipantEventsGenerator();
        }

        @Override
        public DirObject fetchDirObjectFor(DirectorySessionImpl session, String id) throws DirectoryException {
            return session.getParticipantAccessor().fetchHumanParticipant(id);
        }

        @Override
        public DirObject fetchDirObjectFor(DirectorySessionImpl session, int in) throws DirectoryException {
            return session.getParticipantAccessor().fetchHumanParticipant(in);
        }

        @Override
        public DirObjectNotifier createNotifier(DirectoryListenerInterface listener) {
            return new HumanParticipantNotifier(listener);
        }

        @Override
        public boolean isInConsideredForEvents() {
            return true;
        }

        @Override
        public void addEvent(List<DirectoryNotificationEvent> events, DirectoryNotificationEvent newEvent) {
            AddDirectoryNotificationEventMethod.addParticipantEvent(events, newEvent);
        }
    }
    ,
    GROUP{

        @Override
        public int getMask() {
            return 16384;
        }

        @Override
        public DirectoryEventGenerator createEventGenerator(DirectorySessionImpl session) {
            return session.getGroupAccessor().createGroupEventsGenerator();
        }

        @Override
        public DirObject fetchDirObjectFor(DirectorySessionImpl session, String id) throws DirectoryException {
            return session.getGroupAccessor().fetchGroup(id);
        }

        @Override
        public DirObjectNotifier createNotifier(DirectoryListenerInterface listener) {
            return new OrganizationalGroupNotifier(listener);
        }

        @Override
        public boolean isInConsideredForEvents() {
            return true;
        }
    }
    ,
    BUSINESS_PARAMETER{

        @Override
        public int getMask() {
            return 32768;
        }

        @Override
        public DirectoryEventGenerator createEventGenerator(DirectorySessionImpl session) {
            return session.getProcessAccessor().createBusinessParameterEventGenerator();
        }

        @Override
        public DirObject fetchDirObjectFor(DirectorySessionImpl session, String id) throws DirectoryException {
            return session.getProcessAccessor().fetchBusinessParameter(id);
        }

        @Override
        public DirObjectNotifier createNotifier(DirectoryListenerInterface listener) {
            return new BusinessParameterNotifier(listener);
        }
    }
    ,
    PROCESS_VARIABLE{

        @Override
        public int getMask() {
            return 65536;
        }

        @Override
        public DirectoryEventGenerator createEventGenerator(DirectorySessionImpl session) {
            return session.getProcessAccessor().createVariableEventGenerator();
        }

        @Override
        public DirObject fetchDirObjectFor(DirectorySessionImpl session, String id) throws DirectoryException {
            return session.getProcessAccessor().fetchVariable(id);
        }

        @Override
        public DirObjectNotifier createNotifier(DirectoryListenerInterface listener) {
            return new ProcessVariableNotifier(listener);
        }
    }
    ,
    CALENDAR_RULE{

        @Override
        public int getMask() {
            return 131072;
        }

        @Override
        public DirectoryEventGenerator createEventGenerator(DirectorySessionImpl session) {
            return session.getOrganizationAccessor().createCalendarEventsGenerator();
        }

        @Override
        public DirObject fetchDirObjectFor(DirectorySessionImpl session, String id) throws DirectoryException {
            return session.getOrganizationAccessor().fetchCalendarRule(id);
        }

        @Override
        public DirObjectNotifier createNotifier(DirectoryListenerInterface listener) {
            return new CalendarRuleNotifier(listener);
        }
    }
    ,
    HOLIDAY_RULE{

        @Override
        public int getMask() {
            return 262144;
        }

        @Override
        public DirectoryEventGenerator createEventGenerator(DirectorySessionImpl session) {
            return session.getOrganizationAccessor().createHolidayEventsGenerator();
        }

        @Override
        public DirObject fetchDirObjectFor(DirectorySessionImpl session, String id) throws DirectoryException {
            return session.getOrganizationAccessor().fetchHolidayRule(id);
        }

        @Override
        public DirObjectNotifier createNotifier(DirectoryListenerInterface listener) {
            return new HolidayRuleNotifier(listener);
        }
    }
    ,
    PRESENTATION{

        @Override
        public int getMask() {
            return 524288;
        }

        @Override
        public DirectoryEventGenerator createEventGenerator(DirectorySessionImpl session) {
            return session.getOrganizationAccessor().createPresentationEventsGenerator();
        }

        @Override
        public DirObject fetchDirObjectFor(DirectorySessionImpl session, String id) throws DirectoryException {
            return session.getOrganizationAccessor().fetchPresentation(id);
        }

        @Override
        public DirObjectNotifier createNotifier(DirectoryListenerInterface listener) {
            return new PresentationNotifier(listener);
        }
    }
    ,
    VIEW{

        @Override
        public int getMask() {
            return 0x100000;
        }

        @Override
        public DirectoryEventGenerator createEventGenerator(DirectorySessionImpl session) {
            return session.getOrganizationAccessor().createViewEventsGenerator();
        }

        @Override
        public DirObject fetchDirObjectFor(DirectorySessionImpl session, String id) throws DirectoryException {
            return session.getOrganizationAccessor().fetchView(id);
        }

        @Override
        public DirObjectNotifier createNotifier(DirectoryListenerInterface listener) {
            return new ViewNotifier(listener);
        }
    };


    public int getMask() {
        return 0;
    }

    public DirectoryEventGenerator createEventGenerator(DirectorySessionImpl session) {
        return null;
    }

    public DirObject fetchDirObjectFor(DirectorySessionImpl session, String id) throws DirectoryException {
        throw new IllegalStateException("This object type " + (Object)((Object)this) + " do not support this operation");
    }

    public DirObject fetchDirObjectFor(DirectorySessionImpl session, int in) throws DirectoryException {
        throw new IllegalStateException("This object type " + (Object)((Object)this) + " do not support this operation");
    }

    public DirObjectNotifier createNotifier(DirectoryListenerInterface listener) {
        throw new IllegalStateException("This object type " + (Object)((Object)this) + " do not support this operation");
    }

    public boolean isInConsideredForEvents() {
        return false;
    }

    public void addEvent(List<DirectoryNotificationEvent> events, DirectoryNotificationEvent newEvent) {
        AddDirectoryNotificationEventMethod.addEvent(events, newEvent);
    }
}

