/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider.notifiers;

import fuego.directory.provider.notifiers.DirObjectType;
import fuego.directory.provider.notifiers.DirectoryNotificationEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class AddDirectoryNotificationEventMethod {
    AddDirectoryNotificationEventMethod() {
    }

    public static void addEvent(List<DirectoryNotificationEvent> events, DirectoryNotificationEvent newEvent) {
        DirectoryNotificationEvent result;
        if (newEvent == null) {
            return;
        }
        if (newEvent.isChange()) {
            result = AddDirectoryNotificationEventMethod.addChangeEvent(events, newEvent);
        } else if (newEvent.isCreate()) {
            result = AddDirectoryNotificationEventMethod.addCreateEvent(events, newEvent);
        } else {
            assert (newEvent.isDelete());
            result = AddDirectoryNotificationEventMethod.addDeleteEvent(events, newEvent);
        }
        if (result != null) {
            events.add(result);
        }
    }

    public static void addParticipantEvent(List<DirectoryNotificationEvent> events, DirectoryNotificationEvent newEvent) {
        DirectoryNotificationEvent result;
        if (newEvent == null) {
            return;
        }
        assert (newEvent.objectType == DirObjectType.PARTICIPANT);
        if (newEvent.isChange()) {
            result = AddDirectoryNotificationEventMethod.addParticipantChangeEvent(events, newEvent);
        } else if (newEvent.isCreate()) {
            result = AddDirectoryNotificationEventMethod.addParticipantCreateEvent(events, newEvent);
        } else {
            assert (newEvent.isDelete());
            result = AddDirectoryNotificationEventMethod.addParticipantDeleteEvent(events, newEvent);
        }
        if (result != null) {
            events.add(result);
        }
    }

    private static DirectoryNotificationEvent addChangeEvent(List events, DirectoryNotificationEvent newEvent) {
        DirectoryNotificationEvent result;
        DirectoryNotificationEvent newCreateEvent = newEvent.clone(2);
        if (events.contains(newEvent)) {
            events.remove(newEvent);
            result = newEvent;
        } else if (events.contains(newCreateEvent)) {
            events.remove(newCreateEvent);
            result = newCreateEvent;
        } else {
            result = newEvent;
        }
        return result;
    }

    private static DirectoryNotificationEvent addCreateEvent(List events, DirectoryNotificationEvent newEvent) {
        DirectoryNotificationEvent result;
        boolean inConsidered = newEvent.getObjectType().isInConsideredForEvents();
        if (events.contains(newEvent)) {
            events.remove(newEvent);
            result = newEvent;
        } else if (inConsidered) {
            result = newEvent;
        } else {
            DirectoryNotificationEvent newUpdateEvent = newEvent.clone(4);
            DirectoryNotificationEvent newDeleteEvent = newEvent.clone(1);
            if (events.contains(newDeleteEvent)) {
                events.remove(newDeleteEvent);
                result = newUpdateEvent;
            } else {
                result = newEvent;
            }
        }
        return result;
    }

    private static DirectoryNotificationEvent addDeleteEvent(List events, DirectoryNotificationEvent newEvent) {
        DirectoryNotificationEvent result = null;
        DirectoryNotificationEvent sameObjectEvent = AddDirectoryNotificationEventMethod.findSameObjectEvent(events, newEvent);
        if (sameObjectEvent != null) {
            events.remove(sameObjectEvent);
            if (!sameObjectEvent.isCreate()) {
                result = newEvent;
            }
        } else {
            result = newEvent;
        }
        return result;
    }

    private static DirectoryNotificationEvent addParticipantChangeEvent(List<DirectoryNotificationEvent> events, DirectoryNotificationEvent newEvent) {
        DirectoryNotificationEvent result;
        DirectoryNotificationEvent newCreateEvent = newEvent.clone(2);
        DirectoryNotificationEvent participantCreateEvent = new DirectoryNotificationEvent(newEvent.object, newEvent.objectId, newEvent.objectType, 2, newEvent.eventId, -1);
        DirectoryNotificationEvent invalidChangeEvent = new DirectoryNotificationEvent(newEvent.object, newEvent.objectId, newEvent.objectType, 4, newEvent.eventId, -1);
        if (events.contains(participantCreateEvent)) {
            events.remove(participantCreateEvent);
            events.add(newCreateEvent);
        }
        if (events.contains(newEvent)) {
            events.remove(newEvent);
            result = newEvent;
        } else if (AddDirectoryNotificationEventMethod.isSameEventIgnoringIN(events, newEvent)) {
            result = null;
        } else if (events.contains(invalidChangeEvent)) {
            events.remove(invalidChangeEvent);
            result = newEvent;
        } else if (events.contains(newCreateEvent)) {
            events.remove(newCreateEvent);
            result = newCreateEvent;
        } else {
            result = AddDirectoryNotificationEventMethod.isSameEventIgnoringIN(events, newCreateEvent) ? null : newEvent;
        }
        return result;
    }

    private static boolean isSameEventIgnoringIN(List events, DirectoryNotificationEvent newEvent) {
        boolean result = false;
        for (int i = 0; i < events.size() && !result; ++i) {
            DirectoryNotificationEvent event = (DirectoryNotificationEvent)events.get(i);
            if (!event.isSameEventIgnoringIn(newEvent)) continue;
            result = true;
        }
        return result;
    }

    private static DirectoryNotificationEvent addParticipantCreateEvent(List<DirectoryNotificationEvent> events, DirectoryNotificationEvent newEvent) {
        DirectoryNotificationEvent result;
        boolean inConsidered = newEvent.getObjectType().isInConsideredForEvents();
        Iterator sameObjectEventsIterator = AddDirectoryNotificationEventMethod.findSameObjectEvents(events, newEvent);
        while (sameObjectEventsIterator.hasNext()) {
            DirectoryNotificationEvent sameObjectEvent = (DirectoryNotificationEvent)sameObjectEventsIterator.next();
            if (sameObjectEvent.getEventType() != 2 || sameObjectEvent.getObjectIn() != -1) continue;
            events.remove(sameObjectEvent);
        }
        if (events.contains(newEvent)) {
            events.remove(newEvent);
            result = newEvent;
        } else if (inConsidered) {
            result = newEvent;
        } else {
            DirectoryNotificationEvent newUpdateEvent = newEvent.clone(4);
            DirectoryNotificationEvent newDeleteEvent = newEvent.clone(1);
            if (events.contains(newDeleteEvent)) {
                events.remove(newDeleteEvent);
                result = newUpdateEvent;
            } else {
                result = newEvent;
            }
        }
        return result;
    }

    private static Iterator findSameObjectEvents(List<DirectoryNotificationEvent> events, DirectoryNotificationEvent newEvent) {
        ArrayList<DirectoryNotificationEvent> result = new ArrayList<DirectoryNotificationEvent>();
        for (DirectoryNotificationEvent event : events) {
            if (event.getObjectType() != newEvent.getObjectType() || !event.getObjectId().equals(newEvent.getObjectId())) continue;
            result.add(event);
        }
        return result.iterator();
    }

    private static DirectoryNotificationEvent addParticipantDeleteEvent(List events, DirectoryNotificationEvent newEvent) {
        DirectoryNotificationEvent result = null;
        DirectoryNotificationEvent sameObjectEvent = AddDirectoryNotificationEventMethod.findSameObjectEvent(events, newEvent);
        if (sameObjectEvent != null) {
            events.remove(sameObjectEvent);
            if (!sameObjectEvent.isCreate()) {
                result = newEvent;
            }
        } else {
            result = newEvent;
        }
        return result;
    }

    private static DirectoryNotificationEvent findSameObjectEvent(List events, DirectoryNotificationEvent newEvent) {
        for (Object event1 : events) {
            DirectoryNotificationEvent event = (DirectoryNotificationEvent)event1;
            if (event.getObjectType() != newEvent.getObjectType() || !event.getObjectId().equals(newEvent.getObjectId())) continue;
            return event;
        }
        return null;
    }
}

