/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider;

import fuego.directory.DirectoryException;
import fuego.directory.provider.Factory;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.log.Log;
import oracle.bpm.util.Properties;

public abstract class FuegoSchemaBuilder {
    private final Factory factory;
    private final Properties properties;

    protected FuegoSchemaBuilder(Factory factory, Properties properties) {
        this.factory = factory;
        this.properties = properties;
    }

    public abstract boolean isCompatible() throws DirectoryException;

    public abstract boolean isCreated() throws DirectoryException;

    public abstract boolean isSchemaPresent() throws DirectoryException;

    public StringList getPropertiesKeysToExport() {
        StringList answer = StringList.create("HOST", "PORT", "ROOT", "ORGNAME");
        answer.addAll(this.getPropertiesKeysToEncrypt());
        return answer;
    }

    protected abstract StringList getPropertiesKeysToEncrypt();

    protected static void printProperties(Properties p) {
        if (Log.isDebugging()) {
            Log.logDebug("Properties:");
        }
        for (Object o : p.values()) {
            if (!Log.isDebugging()) continue;
            Log.logDebug(o.toString());
        }
    }

    protected Factory getFactory() {
        return this.factory;
    }

    protected Properties getProperties() {
        return this.properties;
    }

    protected boolean mustWritePropertiesFile() {
        return Boolean.valueOf(this.getProperties().getProperty("write.schema.properties.file", "true")) != false && this.getSchemaName() != null;
    }

    protected void writePropertiesToFile() {
    }

    private String getPropertiesFilename() {
        return this.getSchemaName() + ".properties";
    }

    private Properties getPropertiesToExport() {
        Properties toExport = new Properties();
        Properties properties = (Properties)this.getProperties().clone();
        for (String o : this.getPropertiesKeysToExport()) {
            String key = o;
            String value = properties.getProperty(key);
            if (value == null) continue;
            toExport.put(key, value);
        }
        toExport.put("PROTOCOL", this.getFactory().getProtocolProvided());
        return toExport;
    }

    private String getSchemaName() {
        return this.getProperties().getProperty("DEFAULT_NAME");
    }
}

