/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider;

import fuego.directory.AuthenticationException;
import fuego.directory.DirHumanParticipant;
import fuego.directory.DirObject;
import fuego.directory.DirectoryException;
import fuego.directory.DirectoryFeatures;
import fuego.directory.DirectoryPassport;
import fuego.directory.DirectoryRuntimeException;
import fuego.directory.DirectorySession;
import fuego.directory.SimpleUserPasswordInterface;
import fuego.directory.exception.CouldNotCleanSchemaException;
import fuego.directory.exception.CouldNotCreateSchemaException;
import fuego.directory.exception.CouldNotRebuildSchemaException;
import fuego.directory.listener.DirectoryNotifierInterface;
import fuego.directory.provider.AttributeValidator;
import fuego.directory.provider.AuthenticationAccessor;
import fuego.directory.provider.DirectoryFeaturesImpl;
import fuego.directory.provider.DirectoryPersistenceManager;
import fuego.directory.provider.DirectoryPreferencesAccessor;
import fuego.directory.provider.EngineAccessor;
import fuego.directory.provider.Factory;
import fuego.directory.provider.GroupAccessor;
import fuego.directory.provider.ObjectClassInstanceAccessor;
import fuego.directory.provider.ObjectPropertiesAccessor;
import fuego.directory.provider.OrganizationAccessor;
import fuego.directory.provider.ParticipantAccessor;
import fuego.directory.provider.Preferences;
import fuego.directory.provider.ProcessAccessor;
import fuego.directory.provider.ProcessManagerAccessor;
import fuego.directory.provider.ProjectAccessor;
import fuego.directory.provider.TransactionSupport;
import fuego.directory.provider.ValidationAccessor;
import fuego.directory.provider.notifiers.DirectoryNotifier;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.util.Properties;

public class DirectorySessionImpl<T>
extends DirectorySession<T>
implements SimpleUserPasswordInterface {
    protected boolean connected = false;
    private boolean administrator;
    private final AttributeValidator attributeValidator;
    private final AuthenticationAccessor authenticationAccessor;
    private final DirectoryNotifier directoryNotifier;
    private DirectoryPreferencesAccessor directoryPreferenceAccessor;
    private final EngineAccessor engineAccessor;
    private final GroupAccessor groupAccessor;
    private final Map<Integer, Object> internalObjects;
    private final ObjectClassInstanceAccessor objectInstanceAccessor;
    private final ObjectPropertiesAccessor objectPropertiesAccessor;
    private final OrganizationAccessor organizationAccessor;
    private final ParticipantAccessor participantAccessor;
    private String password;
    private final DirectoryPersistenceManager persistenceManager;
    private Preferences preferences;
    private final ProcessAccessor processAccessor;
    private final ProcessManagerAccessor processManagerAccessor;
    private final ProjectAccessor projectAccessor;
    private SchemaInfo schemaInfo;
    private DirHumanParticipant sessionParticipant;
    private final DirectoryFeaturesImpl supports;
    private final TransactionSupport transactionSupport;
    private final ValidationAccessor validationAccessor;
    public static final String PROPERTY_SEPARATOR = ";";
    protected static Class<AuthenticationAccessor> authenticationAccessorProxyClass = DirectorySessionImpl.getProxy(AuthenticationAccessor.class);
    protected static Class<ProjectAccessor> projectAccessorProxyClass = DirectorySessionImpl.getProxy(ProjectAccessor.class);
    protected static Class<OrganizationAccessor> organizationAccessorProxyClass = DirectorySessionImpl.getProxy(OrganizationAccessor.class);
    protected static Class<ParticipantAccessor> participantAccessorProxyClass = DirectorySessionImpl.getProxy(ParticipantAccessor.class);
    protected static Class<GroupAccessor> groupAccessorProxyClass = DirectorySessionImpl.getProxy(GroupAccessor.class);
    protected static Class<EngineAccessor> engineAccessorProxyClass = DirectorySessionImpl.getProxy(EngineAccessor.class);
    protected static Class<ObjectPropertiesAccessor> objectPropertiesAccessorProxyClass = DirectorySessionImpl.getProxy(ObjectPropertiesAccessor.class);
    protected static Class<ProcessAccessor> processAccessorProxyClass = DirectorySessionImpl.getProxy(ProcessAccessor.class);
    protected static Class<DirectoryPreferencesAccessor> directoryPreferenceAccessorProxyClass = DirectorySessionImpl.getProxy(DirectoryPreferencesAccessor.class);
    protected static Class<ProcessManagerAccessor> processManagerAccessorProxyClass = DirectorySessionImpl.getProxy(ProcessManagerAccessor.class);
    protected static Class<ObjectClassInstanceAccessor> objectClassInstanceAccessorProxyClass = DirectorySessionImpl.getProxy(ObjectClassInstanceAccessor.class);

    protected DirectorySessionImpl(DirectoryPassport passport, Factory<T> factory) {
        super(passport, factory);
        this.password = passport.getPassword();
        this.internalObjects = new HashMap<Integer, Object>();
        this.persistenceManager = factory.createPersistenceManager(this);
        this.directoryNotifier = new DirectoryNotifier(this);
        factory.initializeSession(this, passport);
        this.transactionSupport = factory.createTransactionSupport(this);
        this.directoryPreferenceAccessor = AccessorProxy.newProxyInstance(factory.createDirectoryPreferencesAccessor(this), directoryPreferenceAccessorProxyClass, this.transactionSupport);
        this.authenticationAccessor = AccessorProxy.newProxyInstance(factory.createAuthenticationAccessor(this), authenticationAccessorProxyClass, this.transactionSupport);
        this.projectAccessor = AccessorProxy.newProxyInstance(factory.createProjectAccessor(this), projectAccessorProxyClass, this.transactionSupport);
        this.objectPropertiesAccessor = AccessorProxy.newProxyInstance(factory.createObjectPropertiesAccessor(this), objectPropertiesAccessorProxyClass, this.transactionSupport);
        this.organizationAccessor = AccessorProxy.newProxyInstance(factory.createOrganizationAccessor(this), organizationAccessorProxyClass, this.transactionSupport);
        this.participantAccessor = AccessorProxy.newProxyInstance(factory.createParticipantAccessor(this), participantAccessorProxyClass, this.transactionSupport);
        this.groupAccessor = AccessorProxy.newProxyInstance(factory.createGroupAccessor(this), groupAccessorProxyClass, this.transactionSupport);
        this.engineAccessor = AccessorProxy.newProxyInstance(factory.createEngineAccessor(this), engineAccessorProxyClass, this.transactionSupport);
        this.processAccessor = AccessorProxy.newProxyInstance(factory.createProcessAccessor(this), processAccessorProxyClass, this.transactionSupport);
        this.processManagerAccessor = AccessorProxy.newProxyInstance(factory.createProcessManagerAccessor(this), processManagerAccessorProxyClass, this.transactionSupport);
        this.objectInstanceAccessor = AccessorProxy.newProxyInstance(factory.createObjectClassInstanceAccessor(this), objectClassInstanceAccessorProxyClass, this.transactionSupport);
        this.validationAccessor = factory.createValidationAccessor(this);
        this.attributeValidator = factory.createAttributeValidator(this);
        this.supports = new DirectoryFeaturesImpl(this);
    }

    protected DirectorySessionImpl(DirectoryPassport passport, Factory<T> factory, boolean administrator) {
        this(passport, factory);
        this.administrator = administrator;
    }

    /*
     * Exception decompiling
     */
    public DirHumanParticipant authenticate() throws AuthenticationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void cleanStructure(Properties properties) throws CouldNotCleanSchemaException, AuthenticationException {
        boolean transactionStarted = this.isTransactionStarted();
        if (!transactionStarted) {
            this.startTransaction();
        }
        try {
            this.getPersistenceManager().cleanStructure(properties);
            this.loadSchemaInfo();
            this.connected = true;
            this.getAuthenticationAccessor().cleanStructure(properties);
            this.getOrganizationAccessor().cleanStructure(properties);
            this.getParticipantAccessor().cleanStructure(properties);
            this.getGroupAccessor().cleanStructure(properties);
            this.getProjectAccessor().cleanStructure(properties);
            this.getProcessAccessor().cleanStructure(properties);
            this.getObjectPropertiesAccessor().cleanStructure(properties);
            this.getEngineAccessor().cleanStructure(properties);
            if (!transactionStarted) {
                this.commitTransaction();
            }
        }
        catch (DirectoryRuntimeException e) {
            throw CouldNotCleanSchemaException.cleanException(this, (Throwable)e);
        }
        finally {
            if (!transactionStarted) {
                this.rollbackTransaction();
            }
        }
    }

    @Override
    public void commitTransaction() {
        if (this.transactionSupport != null) {
            this.transactionSupport.commitTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws AuthenticationException {
        boolean transactionStarted = this.isTransactionStarted();
        if (!transactionStarted) {
            this.startTransaction();
        }
        try {
            this.getPersistenceManager().checkConnectivity();
            this.loadSchemaInfo();
            this.connected = true;
            DirHumanParticipant sp = this.getAuthenticationAccessor().connect();
            assert (this.isAnonymous() == (sp == null)) : "connect is not returning the appropiate value: session is anonymous? " + this.isAnonymous();
            if (!this.isAnonymous()) {
                assert (sp != null);
                if (!sp.isEnabled()) {
                    throw new AuthenticationException(this.getDirectoryId(), this.getParticipant());
                }
                this.setSessionParticipant(sp);
                this.setAdministrator(sp.isAdministrator());
            }
            if (this.directoryNotifier != null) {
                this.directoryNotifier.sessionConnected();
            }
            if (!transactionStarted) {
                this.commitTransaction();
            }
        }
        finally {
            if (!transactionStarted) {
                this.rollbackTransaction();
            }
        }
    }

    @Override
    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        if (this.directoryNotifier != null) {
            this.directoryNotifier.sessionDisconnected();
        }
        this.getAuthenticationAccessor().disconnect();
        this.connected = false;
    }

    @Override
    public AttributeValidator getAttributeValidator() {
        return this.attributeValidator;
    }

    @Override
    public AuthenticationAccessor getAuthenticationAccessor() {
        return this.authenticationAccessor;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        return Boolean.valueOf(this.lookupProperty(key));
    }

    @Override
    public DirectoryNotifierInterface getDirectoryNotifier() {
        return this.directoryNotifier;
    }

    public DirectoryNotifier getDirectoryNotifierImpl() {
        return this.directoryNotifier;
    }

    public String getDirectoryProperty(String key) {
        return this.getDirectoryPreferences().getSingleValue(key);
    }

    @Override
    public GroupAccessor getGroupAccessor() {
        return this.groupAccessor;
    }

    public Object getInternalObject(int key) {
        return this.internalObjects.get(key);
    }

    @Override
    public ObjectPropertiesAccessor getObjectPropertiesAccessor() {
        return this.objectPropertiesAccessor;
    }

    @Override
    public OrganizationAccessor getOrganizationAccessor() {
        return this.organizationAccessor;
    }

    @Override
    public String getOrganizationName() {
        if (this.schemaInfo == null) {
            throw new IllegalStateException("schemaInfo not assigned");
        }
        return this.schemaInfo.organizationName;
    }

    @Override
    public String getParticipant() {
        return this.sessionParticipant != null ? this.sessionParticipant.getId() : super.getParticipant();
    }

    @Override
    public ParticipantAccessor getParticipantAccessor() {
        return this.participantAccessor;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getSessionPassword() {
        return this.getPassword();
    }

    public DirectoryPersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    @Override
    public ProcessAccessor getProcessAccessor() {
        return this.processAccessor;
    }

    @Override
    public ProjectAccessor getProjectAccessor() {
        return this.projectAccessor;
    }

    @Override
    public String getSchemaId() {
        if (this.schemaInfo == null) {
            throw new IllegalStateException("schemaInfo not assigned");
        }
        return this.schemaInfo.schemaId;
    }

    @Override
    public boolean hasSchemaInfo() {
        return this.schemaInfo != null;
    }

    @Override
    public String getSchemaVersion() {
        if (this.schemaInfo == null) {
            throw new IllegalStateException("schemaInfo not assigned");
        }
        return this.schemaInfo.schemaVersion;
    }

    public Properties getSessionProperties() {
        return this.sessionProperties;
    }

    public Object getSessionProperty(String key) {
        return this.sessionProperties.get(key);
    }

    public void initializeStructure(Properties properties) throws CouldNotCreateSchemaException {
        boolean transactionStarted = this.isTransactionStarted();
        if (!transactionStarted) {
            this.startTransaction();
        }
        try {
            this.getPersistenceManager().initializeStructure(properties);
            try {
                this.loadSchemaInfo();
                this.connected = true;
                this.getAuthenticationAccessor().initializeStructure(properties);
                this.getOrganizationAccessor().initializeStructure(properties);
                this.getParticipantAccessor().initializeStructure(properties);
                this.getGroupAccessor().initializeStructure(properties);
                this.getProjectAccessor().initializeStructure(properties);
                this.getProcessAccessor().initializeStructure(properties);
                this.getObjectPropertiesAccessor().initializeStructure(properties);
                this.getEngineAccessor().initializeStructure(properties);
            }
            catch (CouldNotCreateSchemaException ex) {
                this.getPersistenceManager().rollbackInitialization(properties);
                throw ex;
            }
            catch (AuthenticationException e) {
                this.getPersistenceManager().rollbackInitialization(properties);
                throw CouldNotCreateSchemaException.create((DirectorySession)this, (Throwable)e);
            }
            if (!transactionStarted) {
                this.commitTransaction();
            }
        }
        catch (CouldNotCreateSchemaException ex) {
            this.getPersistenceManager().rollbackInitialization(properties);
            throw ex;
        }
        finally {
            if (!transactionStarted) {
                this.rollbackTransaction();
            }
        }
    }

    @Override
    public boolean isAdministrator() {
        return this.administrator;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isTransactionStarted() {
        return this.transactionSupport != null && this.transactionSupport.isTransactionStarted();
    }

    public void loadSchemaInfo() throws AuthenticationException {
        if (this.schemaInfo == null) {
            this.getFactory().obtainSchemaInfo(this);
        }
    }

    @Override
    public String lookupProperty(String key) {
        return super.lookupProperty(key);
    }

    public void rebuildStructure(Properties properties) throws CouldNotRebuildSchemaException, AuthenticationException {
        this.getPersistenceManager().rebuildStructure(properties);
        this.loadSchemaInfo();
        this.connected = true;
        this.getAuthenticationAccessor().rebuildStructure(properties);
        this.getOrganizationAccessor().rebuildStructure(properties);
        this.getParticipantAccessor().rebuildStructure(properties);
        this.getGroupAccessor().rebuildStructure(properties);
        this.getProjectAccessor().rebuildStructure(properties);
        this.getProcessAccessor().rebuildStructure(properties);
        this.getObjectPropertiesAccessor().rebuildStructure(properties);
        this.getEngineAccessor().rebuildStructure(properties);
    }

    @Override
    public void rollbackTransaction() {
        if (this.transactionSupport != null) {
            this.transactionSupport.rollbackTransaction();
        }
    }

    public Object setInternalObject(int key, Object value) {
        return this.internalObjects.put(key, value);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void startTransaction() {
        if (this.transactionSupport != null) {
            this.transactionSupport.startTransaction();
        }
    }

    @Override
    public DirectoryFeatures supports() {
        return this.supports;
    }

    @Override
    public EngineAccessor getEngineAccessor() {
        return this.engineAccessor;
    }

    @Override
    public ValidationAccessor getValidationAccessor() {
        return this.validationAccessor;
    }

    public Preferences getDirectoryPreferences() {
        try {
            if (this.preferences == null) {
                this.preferences = this.directoryPreferenceAccessor.loadPreferences();
            }
        }
        catch (DirectoryException e) {
            throw DirectoryRuntimeException.wrapException(e);
        }
        return this.preferences;
    }

    public void setSchemaInfo(SchemaInfo schemaInfo) {
        if (schemaInfo == null) {
            throw new NullPointerException("schemaInfo");
        }
        if (this.schemaInfo != null) {
            throw new IllegalStateException("schemaInfo already assigned, cannot be modified");
        }
        this.schemaInfo = schemaInfo;
    }

    public String getSessionKey() {
        return this.getFactory().getSessionKey(this);
    }

    @Override
    protected ObjectClassInstanceAccessor getObjectClassInstanceAccessor() {
        return this.objectInstanceAccessor;
    }

    @Override
    protected ProcessManagerAccessor getProcessManagerAccessor() {
        return this.processManagerAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillAuditInfo(DirObject object) throws DirectoryException {
        boolean transactionStarted = this.isTransactionStarted();
        if (!transactionStarted) {
            this.startTransaction();
        }
        try {
            this.getPersistenceManager().fillAuditInfo(object);
            if (!transactionStarted) {
                this.commitTransaction();
            }
        }
        finally {
            if (!transactionStarted) {
                this.rollbackTransaction();
            }
        }
    }

    @Override
    protected DirHumanParticipant getSessionParticipant() {
        return this.sessionParticipant;
    }

    protected void setAdministrator(boolean administrator) {
        this.administrator = administrator;
    }

    protected void setSessionParticipant(DirHumanParticipant sessionParticipant) {
        this.sessionParticipant = sessionParticipant;
    }

    private static <C> Class<C> getProxy(Class<C> clazz) {
        return Proxy.getProxyClass(clazz.getClassLoader(), clazz);
    }

    public static class SchemaInfo
    implements Serializable {
        public final String organizationName;
        public final String schemaId;
        public final String schemaVersion;
        private static final long serialVersionUID = -2094832005417651767L;

        public SchemaInfo(String organizationName, String schemaVersion, String schemaId) {
            assert (organizationName != null) : "Organization name must not be null";
            assert (schemaVersion != null) : "Version must not be null";
            assert (schemaId != null) : "Schema ID must not be null";
            this.organizationName = organizationName;
            this.schemaVersion = schemaVersion;
            this.schemaId = schemaId;
        }
    }

    public static class AccessorProxy
    implements InvocationHandler {
        private Object accessor;
        private TransactionSupport transactionSupport;

        public AccessorProxy(Object accessor, TransactionSupport transactionSupport) {
            this.accessor = accessor;
            this.transactionSupport = transactionSupport;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean transactionStarted = this.transactionSupport == null || this.transactionSupport.isTransactionStarted();
            try {
                if (!transactionStarted) {
                    this.transactionSupport.startTransaction();
                }
                Object result = method.invoke(this.accessor, args);
                if (!transactionStarted) {
                    this.transactionSupport.commitTransaction();
                }
                Object object = result;
                return object;
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = e.getCause();
                }
                throw e;
            }
            finally {
                if (!transactionStarted) {
                    this.transactionSupport.rollbackTransaction();
                }
            }
        }

        public Object getAccessor() {
            return this.accessor;
        }

        protected static <T> T newProxyInstance(Object accessor, Class<T> proxyClass, TransactionSupport transactionSupport) {
            AccessorProxy accessorProxy = new AccessorProxy(accessor, transactionSupport);
            try {
                return proxyClass.getConstructor(InvocationHandler.class).newInstance(accessorProxy);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

