/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider;

import fuego.directory.DirectorySession;
import fuego.directory.provider.AttributeValidator;
import fuego.directory.provider.DirectorySessionImpl;
import fuego.directory.provider.ValidationAccessor;
import java.util.StringTokenizer;

public class BaseValidationAccessor
implements ValidationAccessor {
    private final DirectorySessionImpl session;

    protected BaseValidationAccessor(DirectorySessionImpl session) {
        this.session = session;
    }

    public AttributeValidator getAttributeValidator() {
        return this.session.getAttributeValidator();
    }

    public DirectorySessionImpl getSession() {
        return this.session;
    }

    @Override
    public boolean isValidDescriptionValue(String value) {
        return value == null || DirectorySession.isExtendedASCII(value) && DirectorySession.isValidValue(value, DirectorySession.invalidCharacters());
    }

    @Override
    public boolean isValidFullIdValue(String value) {
        if (value == null) {
            return true;
        }
        if (!DirectorySession.isASCII(value)) {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(value, "/");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (this.isValidIdValue(token)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidIdValue(String value) {
        return value != null && !value.trim().equals("") && DirectorySession.isASCII(value) && DirectorySession.isValidValue(value, DirectorySession.invalidIDCharacters()) && !value.startsWith(" ") && !value.endsWith(" ");
    }

    @Override
    public boolean isValidPropertyKeyValue(String value) {
        return value == null || DirectorySession.isValidValue(value, DirectorySession.invalidKeyCharacters());
    }
}

