/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.PasswordPolicy;
import fuego.directory.PasswordPolicyContext;
import fuego.directory.exception.InvalidPasswordException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class PasswordPolicyChecker {
    private List<PasswordPolicy> policies = new ArrayList<PasswordPolicy>();
    private static PasswordPolicyChecker instance = new PasswordPolicyChecker("default");
    private static PasswordPolicyChecker nullPolicy = new PasswordPolicyChecker(null);
    @NonNls
    private static final String NO_POLICY_PROPERTY = "fuego.directory.password.nopolicy";

    private PasswordPolicyChecker(String policyId) {
        if (policyId != null) {
            this.policies.add(new PasswordLengthPolicy(6));
            this.policies.add(new PasswordEqualsToUserPolicy());
        }
    }

    public static PasswordPolicyChecker getDefault() {
        PasswordPolicyChecker result = Boolean.getBoolean(NO_POLICY_PROPERTY) ? nullPolicy : instance;
        return result;
    }

    public void validatePassword(String password, PasswordPolicyContext context) throws InvalidPasswordException {
        if (!context.isHybrid()) {
            for (PasswordPolicy policy : this.policies) {
                policy.validatePassword(password, context);
            }
        }
    }

    private static class PasswordLengthPolicy
    implements PasswordPolicy {
        private int length;

        private PasswordLengthPolicy(int length) {
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        @Override
        public void validatePassword(String password, PasswordPolicyContext context) throws InvalidPasswordException {
            if (password.length() < this.length) {
                throw InvalidPasswordException.passwordTooShort(this.length);
            }
        }
    }

    private static class PasswordEqualsToUserPolicy
    implements PasswordPolicy {
        private PasswordEqualsToUserPolicy() {
        }

        @Override
        public void validatePassword(String password, PasswordPolicyContext context) throws InvalidPasswordException {
            if (context.getUsername().equals(password)) {
                throw InvalidPasswordException.passwordSameAsUser();
            }
        }
    }
}

