/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.StudioConstants;
import fuego.directory.exception.InvalidAttributeValueException;
import fuego.directory.exception.OperationNotSupportedException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.xml.XmlWriter;

public class DirView
extends DirObject
implements StudioConstants {
    private String id;
    private String[] processes;
    private String properties;
    private String[] roles;
    private int type;
    public static final String ELEM_VIEW = "DirView";
    public static final String ELEM_ID = "id";
    public static final String ELEM_PROCESSES = "processes";
    public static final String ELEM_PROCESS = "process";
    public static final String ELEM_ROLES = "roles";
    public static final String ELEM_ROLE = "role";
    public static final String ELEM_PROPERTIES = "properties";
    public static final String ELEM_TYPE = "type";
    public static final String ELEM_PROPS = "viewProperties";
    public static final String ELEM_PROP = "viewProperty";
    static final long serialVersionUID = 189048577595312869L;
    static final long serialCheck = -984993285294658853L;

    public DirView(DirectorySession session, String id, int type, String[] processes, String[] roles, String properties, String internalId) {
        this(session, -1, id, type, processes, roles, properties, internalId);
    }

    public DirView(DirectorySession session, int in, String id, int type, String[] processes, String[] roles, String properties, String internalId) {
        super(session, in, internalId);
        this.id = id;
        this.setProcesses(processes);
        this.setRoles(roles);
        this.properties = properties;
        this.type = type;
    }

    public static DirView create(DirectorySession session, String id, int type, String[] processes, String[] roles, String properties) throws DirectoryException {
        Directory.checkAdministratorSession(session);
        session.getAttributeValidator().validateViewId(id);
        return session.getOrganizationAccessor().createView(id, type, processes, roles, properties);
    }

    public static DirView fetch(DirectorySession session, String id) throws DirectoryException {
        Directory.checkSession(session);
        try {
            session.getAttributeValidator().validateViewId(id);
        }
        catch (InvalidAttributeValueException e) {
            return null;
        }
        return session.getOrganizationAccessor().fetchView(id);
    }

    public static DirView[] fetchAll(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getOrganizationAccessor().fetchAllViews();
    }

    public static DirView[] fetchByProcessId(DirectorySession session, String partialProcessId) throws DirectoryException {
        Directory.checkSession(session);
        return session.getOrganizationAccessor().fetchViewByProcessId(partialProcessId);
    }

    public static DirView[] fetchByRoleId(DirectorySession session, String roleId) throws DirectoryException {
        Directory.checkSession(session);
        return session.getOrganizationAccessor().fetchViewByRoleId(roleId);
    }

    @Override
    public String getDisplayName() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setProcesses(String[] processes) {
        this.processes = processes;
        if (this.processes == null) {
            this.processes = new String[0];
        }
    }

    public String[] getProcesses() {
        return this.processes;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
        if (this.roles == null) {
            this.roles = new String[0];
        }
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectoryAdministratorSession().getOrganizationAccessor().deleteView(this);
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectoryAdministratorSession().getOrganizationAccessor().refreshView(this);
    }

    @Override
    public Map<String, Object> retrieveAllProperties(String category) throws DirectoryException, OperationNotSupportedException {
        return this.retrieveAllPropertiesImpl(category);
    }

    @Override
    public Object retrieveProperty(String category, String key) throws DirectoryException, OperationNotSupportedException {
        return this.retrievePropertyImpl(category, key);
    }

    @Override
    public void storeProperty(String category, String key, Serializable value) throws DirectoryException, OperationNotSupportedException {
        this.storePropertyImpl(category, key, value);
    }

    @Override
    public String toString() {
        return "type:" + this.getType() + ",properties:" + this.getProperties() + "|" + super.toString();
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectoryAdministratorSession().getOrganizationAccessor().updateView(this);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter, StringList categories) throws IOException {
        int i;
        xmlWriter.startElement(ELEM_VIEW);
        xmlWriter.printValuedElement(ELEM_ID, this.getId());
        xmlWriter.printValuedElement(ELEM_TYPE, String.valueOf(this.getType()));
        if (this.processes != null && this.processes.length > 0) {
            xmlWriter.startElement(ELEM_PROCESSES);
            for (i = 0; i < this.processes.length; ++i) {
                xmlWriter.printValuedElement(ELEM_PROCESS, this.processes[i]);
            }
            xmlWriter.endElement();
        }
        if (this.roles != null && this.roles.length > 0) {
            xmlWriter.startElement(ELEM_ROLES);
            for (i = 0; i < this.roles.length; ++i) {
                xmlWriter.printValuedElement(ELEM_ROLE, this.roles[i]);
            }
            xmlWriter.endElement();
        }
        xmlWriter.printValuedElement(ELEM_PROPERTIES, this.getProperties());
        if (categories != null && categories.size() > 0) {
            xmlWriter.startElement(ELEM_PROPS);
            for (String category : categories) {
                try {
                    Map<String, Object> properties = this.retrieveAllProperties(category);
                    properties.putAll(this.retrieveAllProperties(null));
                    for (Map.Entry<String, Object> entry : properties.entrySet()) {
                        this.printProperty(xmlWriter, ELEM_PROP, category, entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
                    }
                }
                catch (DirectoryException e) {
                    e.printStackTrace();
                }
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }
}

