/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import java.io.IOException;
import oracle.bpm.xml.XmlWriter;

public class DirReferral
extends DirObject
implements Cloneable {
    protected String organization_d;
    protected String properties_d;
    public static final String ELEM_REFERRAL = "DirReferral";
    public static final String ATTR_ORGANIZATION = "organization";
    public static final String ATTR_PROPERTIES = "properties";
    static final long serialVersionUID = 6527091057264635080L;
    static final long serialCheck = 6214830524761770926L;

    public DirReferral(DirectorySession session, int in, String organization, String properties, String internalID) {
        super(session, in, internalID);
        this.organization_d = organization;
        this.properties_d = properties;
    }

    public static DirReferral create(DirectorySession session, String organization, String properties) throws DirectoryException {
        Directory.checkSession(session);
        assert (organization != null);
        session.getAttributeValidator().validateOrganizationName(organization);
        return session.getEngineAccessor().createReferral(organization, properties);
    }

    public static DirReferral fetch(DirectorySession session, String organization) throws DirectoryException {
        Directory.checkSession(session);
        return session.getEngineAccessor().fetchReferral(organization);
    }

    public static DirReferral[] fetchAll(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getEngineAccessor().fetchAllReferrals();
    }

    @Override
    public String getDisplayName() {
        return this.getOrganization();
    }

    @Override
    public String getId() {
        return this.getOrganization();
    }

    @Override
    public String getOrganization() {
        return this.organization_d;
    }

    public void setProperties(String properties) {
        this.properties_d = properties;
    }

    public String getProperties() {
        return this.properties_d;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectorySession().getEngineAccessor().deleteReferral(this);
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectorySession().getEngineAccessor().refreshReferral(this);
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectorySession().getEngineAccessor().updateReferral(this);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement(ELEM_REFERRAL);
        xmlWriter.printValuedElement(ATTR_ORGANIZATION, this.getOrganization());
        xmlWriter.printCDATAElement(ATTR_PROPERTIES, this.getProperties());
        xmlWriter.endElement();
    }
}

