/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirHumanParticipant;
import fuego.directory.DirObject;
import fuego.directory.DirOrganizationalRole;
import fuego.directory.DirOrganizationalUnit;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.FilterFields;
import fuego.directory.exception.InvalidAttributeValueException;
import fuego.directory.exception.OperationNotSupportedException;
import fuego.directory.msg.DirectoryMsg;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.xml.XmlWriter;

public class DirOrganizationalGroup
extends DirObject
implements DynamicObject.Dynamizable {
    protected boolean allowRolesAssigned;
    protected String[] assignedGroups_d;
    protected String[] assignedParticipants_d;
    protected String description_d;
    protected String displayName;
    protected String name_d;
    protected String ou;
    protected DirHumanParticipant.RoleAssignment[] rolesAssignment_d;
    protected String status_d;
    private static final DirHumanParticipant.RoleAssignment[] EMPTY_ROLE_ASSIGNMENT = new DirHumanParticipant.RoleAssignment[0];
    private static final String[] EMPTY_STRING = new String[0];
    public static final String ELEM_GROUP = "DirOrganizationalGroup";
    static final long serialVersionUID = 8232214042344089616L;
    static final long serialCheck = 4258252027636125236L;

    public DirOrganizationalGroup(DirectorySession session, int in, String id, String description, String status, String internalId, boolean allowRolesAssigned) {
        this(session, in, id, id, description, status, internalId, allowRolesAssigned);
    }

    public DirOrganizationalGroup(DirectorySession session, int in, String id, String displayName, String description, String status, String internalId, boolean allowRolesAssigned) {
        this(session, in, id, displayName, description, status, internalId, allowRolesAssigned, DirOrganizationalUnit.getRootId());
    }

    public DirOrganizationalGroup(DirectorySession session, int in, String id, String displayName, String description, String status, String internalId, boolean allowRolesAssigned, String ou) {
        super(session, in, internalId);
        this.name_d = id;
        this.displayName = displayName;
        this.setDescription(description);
        this.status_d = status;
        this.assignedParticipants_d = EMPTY_STRING;
        this.assignedGroups_d = EMPTY_STRING;
        this.rolesAssignment_d = EMPTY_ROLE_ASSIGNMENT;
        this.allowRolesAssigned = allowRolesAssigned;
        this.ou = ou;
    }

    public static DirHumanParticipant.RoleAssignment[] getRolesAssignmentForParticipant(DirOrganizationalGroup[] groups, DirHumanParticipant participant) throws DirectoryException {
        TreeMap<String, DirHumanParticipant.RoleAssignment> roles = new TreeMap<String, DirHumanParticipant.RoleAssignment>(String.CASE_INSENSITIVE_ORDER);
        for (DirHumanParticipant.RoleAssignment roleAssignment : participant.getRolesAssignment()) {
            String roleId = DirOrganizationalRole.makeRoleId(roleAssignment.role, roleAssignment.parametricValue);
            roles.put(roleId, roleAssignment);
        }
        TreeMap<String, DirOrganizationalGroup> sortedGroups = new TreeMap<String, DirOrganizationalGroup>(String.CASE_INSENSITIVE_ORDER);
        for (DirOrganizationalGroup group : groups) {
            sortedGroups.put(group.getId(), group);
        }
        TreeSet<String> assignedGroups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (DirOrganizationalGroup group : groups) {
            if (assignedGroups.contains(group.getId()) || !group.hasParticipantAssigned(participant.getId())) continue;
            assignedGroups.add(group.getId());
            DirOrganizationalGroup.getAssignedGroups(group, sortedGroups, assignedGroups);
        }
        for (String assignedGroup : assignedGroups) {
            DirOrganizationalGroup group = (DirOrganizationalGroup)sortedGroups.get(assignedGroup);
            if (group == null) continue;
            for (DirHumanParticipant.RoleAssignment roleAssignment : group.getRolesAssignment()) {
                String roleId = DirOrganizationalRole.makeRoleId(roleAssignment.role, roleAssignment.parametricValue);
                DirHumanParticipant.RoleAssignment assignedRole = (DirHumanParticipant.RoleAssignment)roles.get(roleId);
                if (assignedRole == null) {
                    roles.put(roleId, roleAssignment);
                    continue;
                }
                int permissions = roleAssignment.permissions | assignedRole.permissions;
                DirHumanParticipant.RoleAssignment newRoleAssignment = new DirHumanParticipant.RoleAssignment(assignedRole.role, assignedRole.parametricValue, permissions, assignedRole.roleIn);
                roles.put(roleId, newRoleAssignment);
            }
        }
        return roles.values().toArray(new DirHumanParticipant.RoleAssignment[roles.size()]);
    }

    public static DirHumanParticipant.RoleAssignment[] getRolesAssignmentForParticipant(Map<String, DirOrganizationalGroup> groups, DirHumanParticipant participant, String[] participantGroups) throws DirectoryException {
        String roleId;
        TreeMap<String, DirHumanParticipant.RoleAssignment> roles = new TreeMap<String, DirHumanParticipant.RoleAssignment>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < participant.getRolesAssignment().length; ++i) {
            DirHumanParticipant.RoleAssignment roleAssignment = participant.getRolesAssignment()[i];
            roleId = DirOrganizationalRole.makeRoleId(roleAssignment.role, roleAssignment.parametricValue);
            roles.put(roleId, roleAssignment);
        }
        TreeSet<String> assignedGroups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        assignedGroups.addAll(Arrays.asList(participantGroups));
        for (String participantGroup : participantGroups) {
            DirOrganizationalGroup group = groups.get(participantGroup);
            if (group == null) continue;
            if (!group.hasParticipantAssigned(participant.getId())) {
                String[] assignedParticipants = group.getAssignedParticipants();
                if (assignedParticipants != null) {
                    String[] newAssignedParticipants = new String[assignedParticipants.length + 1];
                    System.arraycopy(assignedParticipants, 0, newAssignedParticipants, 0, assignedParticipants.length);
                    newAssignedParticipants[assignedParticipants.length] = participant.getId();
                    group.setAssignedParticipants(newAssignedParticipants);
                } else {
                    group.setAssignedParticipants(new String[]{participant.getId()});
                }
            }
            DirOrganizationalGroup.getAssignedGroups(group, groups, assignedGroups);
        }
        for (String assignedGroup : assignedGroups) {
            DirHumanParticipant.RoleAssignment[] rolesByGroup;
            DirOrganizationalGroup group = groups.get(assignedGroup);
            if (group == null) continue;
            for (DirHumanParticipant.RoleAssignment _roleAssignment : rolesByGroup = group.getRolesAssignment()) {
                roleId = DirOrganizationalRole.makeRoleId(_roleAssignment.role, _roleAssignment.parametricValue);
                DirHumanParticipant.RoleAssignment assignedRole = (DirHumanParticipant.RoleAssignment)roles.get(roleId);
                if (assignedRole == null) {
                    roles.put(roleId, _roleAssignment);
                    continue;
                }
                int permissions = _roleAssignment.permissions | assignedRole.permissions;
                DirHumanParticipant.RoleAssignment newRoleAssignment = new DirHumanParticipant.RoleAssignment(assignedRole.role, assignedRole.parametricValue, permissions, assignedRole.roleIn);
                roles.put(roleId, newRoleAssignment);
            }
        }
        return roles.values().toArray(new DirHumanParticipant.RoleAssignment[roles.size()]);
    }

    public static DirOrganizationalGroup fetch(DirectorySession session, String id) throws DirectoryException {
        Directory.checkSession(session);
        return session.getGroupAccessor().fetchGroup(id);
    }

    public static DirOrganizationalGroup fetchMinimal(DirectorySession session, String id) throws DirectoryException {
        Directory.checkSession(session);
        return session.getGroupAccessor().fetchGroupMinimal(id);
    }

    public static DirOrganizationalGroup fetch(DirectorySession session, int in) throws DirectoryException {
        Directory.checkSession(session);
        return session.getGroupAccessor().fetchGroup(in);
    }

    public static DirOrganizationalGroup[] fetchAll(DirectorySession session) throws DirectoryException {
        return DirOrganizationalGroup.fetchAll(session, true);
    }

    public static DirOrganizationalGroup[] fetchAll(DirectorySession session, boolean enabledOnly) throws DirectoryException {
        Directory.checkSession(session);
        return session.getGroupAccessor().fetchAllGroups(enabledOnly);
    }

    public static DirOrganizationalGroup[] fetchAllByFilter(DirectorySession session, FilterFields filterFields, String filter, int max) throws DirectoryException {
        Directory.checkSession(session);
        if (filterFields != FilterFields.NONE && (filter == null || filter.trim().length() == 0)) {
            throw new IllegalArgumentException("Filters must not be empty");
        }
        return session.getGroupAccessor().fetchAllByFilter(filterFields, filter, max);
    }

    public static DirOrganizationalGroup[] fetchAllMinimal(DirectorySession session, boolean enabledOnly) throws DirectoryException {
        Directory.checkSession(session);
        return session.getGroupAccessor().fetchAllGroupsMinimal(enabledOnly);
    }

    public static DirOrganizationalGroup create(DirectorySession session, String id, String description, String[] assignedParticipants, String[] assignedGroups, boolean allowRolesAssigned) throws DirectoryException {
        return DirOrganizationalGroup.create(session, id, description, assignedParticipants, assignedGroups, allowRolesAssigned, true);
    }

    public static DirOrganizationalGroup create(DirectorySession session, String id, String description, String[] assignedParticipants, String[] assignedGroups, boolean allowRolesAssigned, boolean enabled) throws DirectoryException {
        return DirOrganizationalGroup.create(session, id, description, assignedParticipants, assignedGroups, allowRolesAssigned, enabled, DirOrganizationalUnit.getRootId());
    }

    public static DirOrganizationalGroup create(DirectorySession session, String id, String description, String[] assignedParticipants, String[] assignedGroups, boolean allowRolesAssigned, boolean enabled, String ou) throws DirectoryException {
        return DirOrganizationalGroup.create(session, id, id, description, assignedParticipants, assignedGroups, allowRolesAssigned, enabled, ou);
    }

    public static DirOrganizationalGroup create(DirectorySession session, String id, String displayName, String description, String[] assignedParticipants, String[] assignedGroups, boolean allowRolesAssigned, boolean enabled, String ou) throws DirectoryException {
        Directory.checkSession(session);
        session.getAttributeValidator().validateNewGroupName(id);
        description = session.getAttributeValidator().validateDescription(description);
        DirOrganizationalGroup.check(displayName != null && displayName.length() > 0, DirectoryMsg.DIR_00051);
        if (!(session.supports().emptyGroup() || assignedParticipants != null && assignedParticipants.length >= 1)) {
            throw InvalidAttributeValueException.groupRequiresParticipants();
        }
        return session.getGroupAccessor().createGroup(id, displayName, description, assignedParticipants, assignedGroups, allowRolesAssigned, enabled, ou);
    }

    public void setAssignedGroups(String[] groups) {
        this.assignedGroups_d = groups;
    }

    public String[] getAssignedGroups() {
        return this.assignedGroups_d;
    }

    public void setAssignedParticipants(String[] participants) {
        this.assignedParticipants_d = participants;
    }

    public String[] getAssignedParticipants() {
        return this.assignedParticipants_d;
    }

    public void setDescription(String description) {
        this.description_d = this.getDirectorySession().getAttributeValidator().validateDescription(description);
    }

    public String getDescription() {
        return this.description_d;
    }

    public void setInternalId(String newID) {
        this.internalProviderId_d = newID;
    }

    public String getName() {
        return this.name_d;
    }

    public String getOU() {
        return this.ou;
    }

    public void setOU(String ou) {
        DirOrganizationalGroup.check(ou != null, DirectoryMsg.DIR_00102);
        this.ou = ou;
    }

    public void setRolesAssignment(DirHumanParticipant.RoleAssignment[] rolesAssignment) throws DirectoryException {
        DirOrganizationalGroup.checkSupports(this.isAllowRolesAssigned(), DirectoryMsg.DIR_00140);
        this.rolesAssignment_d = ArrayUtils.trim(rolesAssignment);
    }

    public DirHumanParticipant.RoleAssignment[] getRolesAssignment() throws DirectoryException {
        DirOrganizationalGroup.checkSupports(this.isAllowRolesAssigned(), DirectoryMsg.DIR_00140);
        return this.rolesAssignment_d;
    }

    public void setAllowRolesAssigned(boolean allowRolesAssigned) {
        this.allowRolesAssigned = allowRolesAssigned;
    }

    public boolean isAllowRolesAssigned() {
        if (this.getIn() < 0) {
            return true;
        }
        return this.allowRolesAssigned;
    }

    public String getStatus() {
        return this.status_d;
    }

    public void setEnabled(boolean enabled) {
        this.status_d = enabled ? "A" : "D";
    }

    public boolean isEnabled() {
        return !"D".equalsIgnoreCase(this.status_d);
    }

    public void becomeFuegoGroup(int newIn, String newId) {
        this.in_d = newIn;
        this.internalProviderId_d = newId;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        DirOrganizationalGroup.check(displayName != null && displayName.length() > 0, DirectoryMsg.DIR_00051);
        this.displayName = displayName;
    }

    @Override
    public String getId() {
        return this.name_d;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectorySession().getGroupAccessor().deleteGroup(this, true);
    }

    public boolean hasGroupAssigned(String group) {
        for (int i = 0; i < this.getAssignedGroups().length; ++i) {
            if (!this.getAssignedGroups()[i].equalsIgnoreCase(group)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParticipantAssigned(String participant) {
        for (int i = 0; i < this.getAssignedParticipants().length; ++i) {
            if (!this.getAssignedParticipants()[i].equalsIgnoreCase(participant)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRoleAssigned(String role) throws DirectoryException {
        DirOrganizationalGroup.checkSupports(this.isAllowRolesAssigned(), DirectoryMsg.DIR_00140);
        for (int i = 0; i < this.getRolesAssignment().length; ++i) {
            if (!this.getRolesAssignment()[i].role.equalsIgnoreCase(role)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRoleAssigned(String role, String parametricValue) throws DirectoryException {
        DirOrganizationalGroup.checkSupports(this.isAllowRolesAssigned(), DirectoryMsg.DIR_00140);
        assert (parametricValue != null);
        for (int i = 0; i < this.getRolesAssignment().length; ++i) {
            if (!this.getRolesAssignment()[i].role.equalsIgnoreCase(role) || !parametricValue.equals(this.getRolesAssignment()[i].parametricValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectorySession().getGroupAccessor().refreshGroup(this);
    }

    @Override
    public Map<String, Object> retrieveAllProperties(String category) throws DirectoryException, OperationNotSupportedException {
        return this.retrieveAllPropertiesImpl(category);
    }

    @Override
    public String retrieveEncryptedProperty(String category, String key, String encryptionKey) throws DirectoryException, OperationNotSupportedException {
        return this.retrieveEncryptedPropertyImpl(category, key, encryptionKey);
    }

    @Override
    public Object retrieveProperty(String category, String key) throws DirectoryException, OperationNotSupportedException {
        return this.retrievePropertyImpl(category, key);
    }

    @Override
    public void storeEncryptedProperty(String category, String key, String value, String encryptionKey) throws DirectoryException, OperationNotSupportedException {
        this.storeEncryptedPropertyImpl(category, key, value, encryptionKey);
    }

    @Override
    public void storeProperty(String category, String key, Serializable value) throws DirectoryException, OperationNotSupportedException {
        this.storePropertyImpl(category, key, value);
    }

    @Override
    public String toString() {
        return "name:" + this.name_d + "|description:" + this.description_d + "|status:" + this.status_d + "|" + this.ou + "|" + super.toString();
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectorySession().getGroupAccessor().updateGroup(this);
    }

    public DynamicObject writeDynamicObject() {
        DynamicObject answer = DynamicObject.create();
        answer.setField("name", this.getId());
        answer.setField("description", this.getDescription());
        answer.setField("ou", this.getOU());
        answer.setJavaClassName(this.getClass().getName());
        return answer;
    }

    @Override
    public void writeXML(XmlWriter xmlWriter, StringList categories) throws IOException {
        xmlWriter.startElement(ELEM_GROUP);
        xmlWriter.printValuedElement("name", this.getId());
        xmlWriter.printValuedElement("displayName", this.getDisplayName());
        xmlWriter.printValuedElement("description", this.getDescription());
        xmlWriter.printValuedElement("status", this.getStatus());
        xmlWriter.printValuedElement("ou", this.getOU());
        xmlWriter.printValuedElement("allowRolesAssigned", String.valueOf(this.isAllowRolesAssigned()));
        DirHumanParticipant.RoleAssignment[] roles = this.rolesAssignment_d;
        if (roles != null && roles.length > 0) {
            xmlWriter.startElement("rolesAssignment");
            for (DirHumanParticipant.RoleAssignment role : roles) {
                role.writeXML(xmlWriter);
            }
            xmlWriter.endElement();
        }
        if (this.assignedGroups_d != null && this.assignedGroups_d.length > 0) {
            xmlWriter.startElement("assignedGroups");
            for (String groupId : this.assignedGroups_d) {
                xmlWriter.printValuedElement("groupId", groupId);
            }
            xmlWriter.endElement();
        }
        if (this.assignedParticipants_d != null && this.assignedParticipants_d.length > 0) {
            xmlWriter.startElement("assignedParticipants");
            for (String participantId : this.assignedParticipants_d) {
                xmlWriter.printValuedElement("participantId", participantId);
            }
            xmlWriter.endElement();
        }
        if (categories != null && categories.size() > 0) {
            xmlWriter.startElement("groupProperties");
            for (String category : categories) {
                try {
                    Map<String, Object> properties = this.retrieveAllProperties(category);
                    properties.putAll(this.retrieveAllProperties(null));
                    for (Map.Entry<String, Object> entry : properties.entrySet()) {
                        this.printProperty(xmlWriter, "groupProperty", category, entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
                    }
                }
                catch (DirectoryException e) {
                    e.printStackTrace();
                }
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    private static void getAssignedGroups(DirOrganizationalGroup group, Map<String, DirOrganizationalGroup> groups, SortedSet<String> alreadyAssignedGroups) {
        for (String assignedGroup : group.getAssignedGroups()) {
            if (alreadyAssignedGroups.contains(assignedGroup)) continue;
            alreadyAssignedGroups.add(assignedGroup);
            DirOrganizationalGroup subgroup = groups.get(assignedGroup);
            if (subgroup == null) continue;
            DirOrganizationalGroup.getAssignedGroups(subgroup, groups, alreadyAssignedGroups);
        }
    }
}

