/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.exception.OperationNotSupportedException;
import fuego.directory.msg.DirectoryMsg;

public class DirOLAPConfiguration
extends DirObject {
    protected String properties_d;
    static final long serialVersionUID = -3136951429778351114L;
    static final long serialCheck = 5947586511072956104L;

    public DirOLAPConfiguration(DirectorySession session, String properties, String internalId) {
        this(session, -1, properties, internalId);
    }

    public DirOLAPConfiguration(DirectorySession session, int in, String properties, String internalId) {
        super(session, in, internalId);
        DirOLAPConfiguration.check(properties != null, DirectoryMsg.DIR_00116);
        this.properties_d = properties;
    }

    public static DirOLAPConfiguration create(DirectorySession session, String properties) throws DirectoryException {
        Directory.checkSession(session);
        return session.getEngineAccessor().createOLAPConfiguration(properties);
    }

    public static DirOLAPConfiguration fetch(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getEngineAccessor().fetchOLAPConfiguration();
    }

    @Override
    public String getDisplayName() {
        return this.getId();
    }

    @Override
    public String getId() {
        return "OLAP";
    }

    public void setProperties(String properties) {
        DirOLAPConfiguration.check(properties != null, DirectoryMsg.DIR_00116);
        this.properties_d = properties;
    }

    public String getProperties() {
        return this.properties_d;
    }

    @Override
    public void delete() throws DirectoryException {
        throw new OperationNotSupportedException("delete", this.toString());
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectorySession().getEngineAccessor().refreshOLAPConfiguration(this);
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectorySession().getEngineAccessor().updateOLAPConfiguration(this);
    }
}

