/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.msg.DirectoryMsg;

public class DirEngineConfiguration
extends DirObject {
    protected String engineId;
    protected String name;
    protected String properties;
    static final long serialVersionUID = 2961758410575800779L;
    static final long serialCheck = -8204807479217038259L;

    public DirEngineConfiguration(DirectorySession session, String name, String engineId, String properties, String internalId) {
        this(session, -1, name, engineId, properties, internalId);
    }

    public DirEngineConfiguration(DirectorySession session, int in, String name, String engineId, String properties, String internalId) {
        super(session, in, internalId);
        this.name = name;
        this.engineId = engineId;
        this.properties = properties;
    }

    public static DirEngineConfiguration create(DirectorySession session, String name, String server, String properties) throws DirectoryException {
        Directory.checkSession(session);
        session.checkIDAttributeValue("name", name);
        DirectorySession.checkAttributeValue("server", server);
        return session.getEngineAccessor().createEngineConfiguration(name, server, properties);
    }

    public static DirEngineConfiguration fetch(DirectorySession session, String name, String engineId) throws DirectoryException {
        Directory.checkSession(session);
        DirEngineConfiguration.check(engineId != null && engineId.length() > 0, DirectoryMsg.DIR_00126);
        return session.getEngineAccessor().fetchEngineConfiguration(name, engineId);
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getId() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getServer() {
        return this.engineId;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectorySession().getEngineAccessor().deleteEngineConfiguration(this);
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectorySession().getEngineAccessor().refreshEngineConfiguration(this);
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectorySession().getEngineAccessor().updateEngineConfiguration(this);
    }
}

