/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.DirOrganizationalUnit;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.xml.XmlWriter;

public class DirBusinessParameter
extends DirObject
implements Cloneable {
    protected String defaultValue;
    protected String id;
    protected String size;
    protected String type;
    protected Map<String, String> values;
    public static final String ELEM_VAR = "DirBusinessParameter";
    static final long serialVersionUID = 7890789054739950889L;
    static final long serialCheck = 749480773088850240L;

    public DirBusinessParameter(DirectorySession session, String id, String type, String size, String defaultValue, Map<String, String> values, String internalID) {
        this(session, -1, id, type, size, defaultValue, values, internalID);
    }

    public DirBusinessParameter(DirectorySession session, int in, String id, String type, String size, String defaultValue, Map<String, String> values, String internalID) {
        super(session, in, internalID);
        this.id = id;
        this.type = type;
        if (size != null && (size = size.trim()).isEmpty()) {
            size = null;
        }
        this.size = size;
        this.defaultValue = this.fixDefaultValue(defaultValue);
        this.values = values;
    }

    public static DirBusinessParameter create(DirectorySession session, String id, String type, String size, String defaultValue, Map<String, String> values) throws DirectoryException {
        Directory.checkSession(session);
        session.getAttributeValidator().validateBusinessParameterId(id);
        DirectorySession.checkAttributeValue("type", type);
        return session.getProcessAccessor().createBusinessParameter(id, type, size, defaultValue, values);
    }

    public static DirBusinessParameter fetch(DirectorySession session, String id) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchBusinessParameter(id);
    }

    public static DirBusinessParameter[] fetchAll(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchAllBusinessParameters();
    }

    public static boolean checkType(int kind, String value) {
        try {
            DirBusinessParameter.convertToObject(kind, value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (TimeFormatException e) {
            return false;
        }
        return true;
    }

    public static Object convertToObject(int kind, String value) {
        if (kind == 5) {
            return value;
        }
        if (value != null) {
            if (kind == 2) {
                return Integer.valueOf(value);
            }
            if (kind == 4 || kind == 3) {
                return new BigDecimal(value);
            }
            if (kind == 6) {
                return Time.valueOf(value);
            }
            if (kind == 1) {
                return Boolean.valueOf(value);
            }
            throw new IllegalArgumentException("Unkwown data kind [" + kind + "] and type [" + Kind.getName(kind) + "] for a DirBusinessParameter");
        }
        throw new IllegalArgumentException("null is allowed only for string variables");
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = this.fixDefaultValue(defaultValue);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDisplayName() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Object getObjectDefaultValue() {
        return DirBusinessParameter.convertToObject(Kind.getKind(this.getType()), this.defaultValue);
    }

    public Object getObjectValue(String ou) {
        return DirBusinessParameter.convertToObject(Kind.getKind(this.getType()), this.getValueFromOU(ou));
    }

    public void setSize(String size) {
        if (size != null && (size = size.trim()).isEmpty()) {
            size = null;
        }
        this.size = size;
    }

    public String getSize() {
        return this.size;
    }

    public void setType(String type) {
        DirectorySession.checkAttributeValue("type", type);
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setValue(String ou, String value) {
        if (ou == null) {
            throw new IllegalArgumentException("The DirBusinessParameter's Organizational Unit cannot be null");
        }
        this.setValueToOU(ou, this.fixDefaultValue(value));
    }

    public void setValue(String ou, Object value) {
        if (ou == null) {
            throw new IllegalArgumentException("The DirBusinessParameter's Organizational Unit cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("The DirBusinessParameter's value for an Organizational Unit cannot be null");
        }
        String strValue = value.toString();
        if (!this.checkType(strValue)) {
            throw new IllegalArgumentException("The DirBusinessParameter's value '" + value + "' for Organizational Unit '" + ou + "' is of an invalid type.");
        }
        this.setValueToOU(ou, strValue);
    }

    public String getValue(String ou) {
        return this.getValueFromOU(ou);
    }

    public void setValues(Map<String, String> values) {
        this.values = values;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public boolean checkType(String value) {
        return DirBusinessParameter.checkType(Kind.getKind(this.type), value);
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectorySession().getProcessAccessor().deleteBusinessParameter(this);
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectorySession().getProcessAccessor().refreshBusinessParameter(this);
    }

    public Object removeValue(String ou) {
        if (ou == null) {
            throw new IllegalArgumentException("The DirBusinessParameter's Organizational Unit cannot be null");
        }
        return this.getValues().remove(ou);
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectorySession().getProcessAccessor().updateBusinessParameter(this);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement(ELEM_VAR);
        xmlWriter.printValuedElement("id", this.getId());
        xmlWriter.printValuedElement("type", this.getType());
        xmlWriter.printValuedElement("size", this.getSize());
        xmlWriter.printCDATAElement("defaultValue", this.getDefaultValue());
        xmlWriter.startElement("valuesMap");
        for (String key : this.getValues().keySet()) {
            String value = this.getValue(key);
            xmlWriter.startElement("entry");
            xmlWriter.printCDATAElement("key", key);
            xmlWriter.printCDATAElement("value", value.toString());
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    private String getValueFromOU(String ou) {
        String result = null;
        while (result == null && !DirOrganizationalUnit.isRootId(ou)) {
            result = this.getValues().get(ou);
            ou = DirOrganizationalUnit.getParentId(ou);
        }
        if (result == null) {
            result = this.getDefaultValue();
        }
        return result;
    }

    private void setValueToOU(String ou, String value) {
        boolean foundValue = false;
        while (!foundValue && !DirOrganizationalUnit.isRootId(ou)) {
            if (this.getValues().containsKey(ou)) {
                this.getValues().put(ou, value);
                foundValue = true;
            }
            ou = DirOrganizationalUnit.getParentId(ou);
        }
        if (!foundValue) {
            this.setDefaultValue(value);
        }
    }

    private String fixDefaultValue(String deflt) {
        return deflt == null ? null : ("".equals(deflt.trim()) ? null : deflt);
    }
}

