/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.msg.DirectoryMsg;
import oracle.bpm.resources.Msg;

public class AuthenticationException
extends DirectoryException {
    static final long serialVersionUID = 6742381085413788145L;
    static final long serialCheck = -545261700450404244L;

    public AuthenticationException(String id, String participant) {
        super(DirectoryMsg.DIR_00004(id, participant, DirectoryMsg.DIR_00004_REASON_INVALID_USER_OR_PASSWORD), id, participant);
    }

    public AuthenticationException(String id, String participant, Throwable originalException) {
        this(DirectoryMsg.DIR_00004(id, participant, originalException.getMessage()));
        this.initCause(originalException);
    }

    protected AuthenticationException() {
    }

    protected AuthenticationException(Msg msg) {
        super(msg);
    }

    public static AuthenticationException error(String id, String participant, Msg message) {
        AuthenticationException result = new AuthenticationException(DirectoryMsg.DIR_00004(id, participant, message));
        return result;
    }

    public static AuthenticationException invalidAnonymousParticipant(String id, String participant) {
        return AuthenticationException.error(id, participant, DirectoryMsg.DIR_00004_REASON_ANONYMOUS_PARTICIPANT_IS_NULL);
    }

    public static AuthenticationException invalidPassword(String id, String participant) {
        return AuthenticationException.error(id, participant, DirectoryMsg.DIR_00004_REASON_PASSWORD_IS_EMPTY);
    }

    public static AuthenticationException loginIncorrect(DirectorySession session) {
        return AuthenticationException.error(session.getOrganizationName(), session.getParticipant(), DirectoryMsg.DIR_00004_REASON_INVALID_USER_OR_PASSWORD);
    }

    public static AuthenticationException notAdministrator(DirectorySession session) {
        return AuthenticationException.error(session.getOrganizationName(), session.getParticipant(), DirectoryMsg.DIR_00004_REASON_PARTICIPANT_IS_NOT_ADMINISTRATOR);
    }

    public static AuthenticationException notEnoughDataToValidateCredentials() {
        return new AuthenticationException(DirectoryMsg.DIR_01002);
    }

    public static AuthenticationException noServiceEndpointURL() {
        return new AuthenticationException(DirectoryMsg.DIR_01003);
    }

    public static AuthenticationException participantIdIsWrong(String url, String participant) {
        return AuthenticationException.error(url, participant, DirectoryMsg.DIR_00004_REASON_PARTICIPANT_IS_EMPTY);
    }

    public static AuthenticationException passwordCheckFailed() {
        return new AuthenticationException(DirectoryMsg.DIR_00101);
    }

    public static AuthenticationException wrap(DirectorySession session, Throwable cause) {
        return new AuthenticationException(session.getDirectoryId(), session.getParticipant(), cause);
    }
}

