/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.xpdl;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.Coordinate;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.bpmn.Swimlane;
import oracle.tutor.xpdl.InvalidXPDLFormatException;
import oracle.tutor.xpdl.Utility;

public class XPDLReader {
    public static void main(String[] args) throws InvalidXPDLFormatException, FileNotFoundException {
        String fileName = "d:\\Work\\Tutor\\Test\\xpdl\\TestTaskBizagi.xpdl";
        try {
            System.out.println("> Loading BPMN diagram from XPDL file:" + fileName + "...\n");
            BusinessProcessDiagram[] diagram = Utility.importFromXPDL(fileName, "C:\\Tutor\\xml");
            for (int i = 0; i < diagram.length; ++i) {
                XPDLReader.printBPMNDiagram(diagram[i]);
            }
        }
        catch (Exception ex) {
            System.out.println("Error" + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private static void printBPMNDiagram(BusinessProcessDiagram bpd) {
        Iterator i$;
        System.out.println("BPMN Diagram :");
        System.out.println("    Description: " + bpd.getDescription());
        System.out.println("    Creation date: " + bpd.getCreationDate());
        System.out.println("    Tool: " + bpd.getToolID());
        System.out.println("    Tool: " + bpd.getID());
        System.out.println("\nPools:");
        if (bpd.getPools() != null) {
            i$ = bpd.getPools().values().iterator();
            while (i$.hasNext()) {
                Pool opool;
                Pool pool = opool = (Pool)i$.next();
                System.out.println(XPDLReader.indent(1) + XPDLReader.node2str((GraphicalElement)pool, 2));
                XPDLReader.printBPMNNodes(XPDLReader.getLaneNodes((Swimlane)pool), 2);
                if (pool.getLanes() == null) continue;
                System.out.println(XPDLReader.indent(2) + "Lanes:");
                Iterator i$2 = pool.getLanes().values().iterator();
                while (i$2.hasNext()) {
                    Lane olane;
                    Lane lane = olane = (Lane)i$2.next();
                    System.out.println(XPDLReader.indent(3) + XPDLReader.node2str((GraphicalElement)lane, 4));
                    XPDLReader.printBPMNNodes(XPDLReader.getLaneNodes((Swimlane)lane), 4);
                }
            }
        }
        System.out.println("\nNodes without lane/pool:");
        for (FlowObject onode : bpd.getAllNodes().values()) {
            FlowObject node = onode;
            if (node.getLane() != null) continue;
            System.out.println(XPDLReader.node2str((GraphicalElement)node, 2));
        }
        System.out.println("\nConnectors: " + bpd.getAllFlows().size());
        i$ = bpd.getAllFlows().values().iterator();
        while (i$.hasNext()) {
            ConnectingObject obj;
            ConnectingObject connector = obj = (ConnectingObject)i$.next();
            System.out.println(XPDLReader.obj2str(connector) + ":\t" + XPDLReader.obj2str(connector.getFrom()) + " --> " + XPDLReader.obj2str(connector.getTo()));
        }
    }

    private static void printBPMNNodes(Collection<FlowObject> nodes, int indent) {
        System.out.println(XPDLReader.indent(indent) + "Nodes:");
        for (FlowObject node : nodes) {
            System.out.println(XPDLReader.indent(indent + 1) + XPDLReader.node2str((GraphicalElement)node, indent + 2));
            if (!(node instanceof Subprocess)) continue;
            Collection<FlowObject> subNodes = ((Subprocess)node).getAllNodes().values();
            XPDLReader.printBPMNNodes(subNodes, indent + 2);
        }
    }

    private static Collection<FlowObject> getLaneNodes(Swimlane lane) {
        ArrayList<FlowObject> res = new ArrayList<FlowObject>();
        for (FlowObject obj : lane.getModel().getAllNodes().values()) {
            FlowObject node = obj;
            if (node.getLane() != lane) continue;
            res.add(node);
        }
        return res;
    }

    private static String indent(int n) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            s.append("  ");
        }
        return s.toString();
    }

    private static String obj2str(Object o) {
        StringBuilder s = new StringBuilder();
        s.append(o.getClass().getSimpleName());
        s.append(" [").append(XPDLReader.getProperty(o, "id")).append(", ").append(XPDLReader.getProperty(o, "name")).append(']');
        return s.toString();
    }

    private static String obj2str(GraphicalElement o) {
        StringBuilder s = new StringBuilder();
        s.append(o.getClass().getSimpleName());
        s.append(" [id=").append(XPDLReader.getProperty(o, "ID")).append(", name=").append(XPDLReader.getProperty(o, "name")).append(']');
        return s.toString();
    }

    private static String obj2str(ConnectingObject o) {
        StringBuilder s = new StringBuilder();
        s.append(o.getClass().getSimpleName());
        s.append(" [id=").append(XPDLReader.getProperty(o, "ID")).append(", name=").append(XPDLReader.getProperty(o, "name"));
        for (Method m : o.getClass().getMethods()) {
            Class<?> rtype;
            String prefix = null;
            if (m.getName().equals("getID") || m.getName().equals("getName") || m.getName().equals("getPosition") || m.getName().equals("getTextPosition") || m.getName().equals("getWidth") || m.getName().equals("getHeight") || m.getName().equals("getDocumentation") || m.getName().equals("getAttribute")) continue;
            prefix = "get";
            if (!m.getName().startsWith("get")) {
                prefix = "is";
                if (!m.getName().startsWith("is")) continue;
            }
            if (!(rtype = m.getReturnType()).isPrimitive() && !rtype.isEnum() && !String.class.isAssignableFrom(rtype) && !Boolean.class.isAssignableFrom(rtype) && !Number.class.isAssignableFrom(rtype) && !Coordinate.class.isAssignableFrom(rtype)) continue;
            try {
                Object val = m.invoke((Object)o, new Object[0]);
                if (val instanceof Coordinate) {
                    val = "(" + ((Coordinate)val).getX() + "," + ((Coordinate)val).getY() + ")";
                }
                String attrName = m.getName().substring(prefix.length());
                s.append(", ").append(attrName).append('=').append(val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        s.append(']');
        return s.toString();
    }

    private static String node2str(GraphicalElement o, int indent) {
        StringBuilder s = new StringBuilder();
        s.append(o.getClass().getSimpleName());
        s.append(" [id=").append(XPDLReader.getProperty(o, "ID")).append(", name=").append(XPDLReader.getProperty(o, "name")).append(']');
        s.append('\n').append(XPDLReader.indent(indent)).append("Attributes:");
        ++indent;
        for (Method m : o.getClass().getMethods()) {
            Class<?> rtype;
            String prefix = null;
            if (m.getName().equals("getID") || m.getName().equals("getName") || m.getName().equals("getAttribute")) continue;
            prefix = "get";
            if (!m.getName().startsWith("get")) {
                prefix = "is";
                if (!m.getName().startsWith("is")) continue;
            }
            if (!(rtype = m.getReturnType()).isPrimitive() && !rtype.isEnum() && !String.class.isAssignableFrom(rtype) && !Boolean.class.isAssignableFrom(rtype) && !Number.class.isAssignableFrom(rtype) && !Coordinate.class.isAssignableFrom(rtype) && !FlowObject.class.isAssignableFrom(rtype)) continue;
            try {
                Object val = m.invoke((Object)o, new Object[0]);
                if (val instanceof Coordinate) {
                    val = "(" + ((Coordinate)val).getX() + "," + ((Coordinate)val).getY() + ")";
                } else if (val instanceof FlowObject) {
                    val = ((FlowObject)val).getID();
                }
                s.append("\n").append(XPDLReader.indent(indent)).append(m.getName().substring(prefix.length())).append('=').append(val);
            }
            catch (Exception e) {
                System.err.println("Error calling method: " + m.getName());
                e.printStackTrace();
            }
        }
        return s.toString();
    }

    private static Object getProperty(Object o, String prop) {
        String methodName = "get" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
        Object result = null;
        try {
            Method m = o.getClass().getMethod(methodName, new Class[0]);
            result = m.invoke(o, new Object[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return result == null ? "<empty>" : result;
    }
}

