/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.xpdl;

import java.util.ArrayList;
import java.util.Collection;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Swimlane;
import org.wfmc.xpdl21.Activity;
import org.wfmc.xpdl21.ActivitySet;
import org.wfmc.xpdl21.Lane;
import org.wfmc.xpdl21.PackageType;
import org.wfmc.xpdl21.Pool;
import org.wfmc.xpdl21.ProcessType;

public final class Util {
    public static Collection<FlowObject> getSwimlaneNodes(Swimlane lane) {
        ArrayList<FlowObject> res = new ArrayList<FlowObject>();
        for (FlowObject obj : lane.getModel().getAllNodes().values()) {
            FlowObject node = obj;
            if (node.getLane() != lane) continue;
            res.add(node);
        }
        return res;
    }

    public static String getPoolIdByProcessId(PackageType pkg, String processId) {
        String poolId = null;
        if (pkg.getPools() != null) {
            for (Pool p : pkg.getPools().getPool()) {
                if (!processId.equals(p.getProcess())) continue;
                poolId = p.getId();
                break;
            }
        }
        return poolId;
    }

    public static ActivitySet getActivitySetById(ProcessType wfprocess, String activitySetId) {
        if (wfprocess.getActivitySets() != null) {
            for (ActivitySet activitySet : wfprocess.getActivitySets().getActivitySet()) {
                if (!activitySetId.equals(activitySet.getId())) continue;
                return activitySet;
            }
        }
        return null;
    }

    public static Lane getLaneById(PackageType pkg, String laneId) {
        for (Pool pool : pkg.getPools().getPool()) {
            for (Lane lane : pool.getLanes().getLane()) {
                if (!laneId.equals(lane.getId())) continue;
                return lane;
            }
        }
        return null;
    }

    public static Pool getPoolById(PackageType pkg, String poolId) {
        for (Pool pool : pkg.getPools().getPool()) {
            if (!poolId.equals(pool.getId())) continue;
            return pool;
        }
        return null;
    }

    public static Activity getActivityById(ProcessType wfprocess, String activityId) {
        Activity tempActivity = null;
        if (wfprocess.getActivities() != null) {
            for (Activity activity : wfprocess.getActivities().getActivity()) {
                if (!activityId.equals(activity.getId())) continue;
                tempActivity = activity;
            }
        }
        if (tempActivity != null && wfprocess.getActivitySets() != null) {
            for (ActivitySet activitySet : wfprocess.getActivitySets().getActivitySet()) {
                for (Activity activity : activitySet.getActivities().getActivity()) {
                    if (!activityId.equals(activity.getId())) continue;
                    tempActivity = activity;
                }
            }
        }
        return tempActivity;
    }

    private Util() {
    }
}

