/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.resources.BPMServicesResource;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

public class AuditTrail
implements Iterable<Node> {
    private Map<String, Node> nodes = new TreeMap<String, Node>(String.CASE_INSENSITIVE_ORDER);
    private Node rootNode;
    private List<Node> tableNodes;
    private static final String PATH_SEPARATOR = ":";

    private AuditTrail() {
    }

    public static AuditTrail create(List<IAuditInstance> auditInstances) {
        if (auditInstances == null) {
            throw new IllegalArgumentException("Argument auditInstances cannot be null.");
        }
        AuditTrailFactory factory = AuditTrailFactory.create();
        return factory.createAuditTrail(auditInstances);
    }

    public static AuditTrail create(Object auditInstances) {
        if (!(auditInstances instanceof List)) {
            throw new IllegalArgumentException("Argument is not of required type. Argument: '" + auditInstances + "'");
        }
        return AuditTrail.create((List)auditInstances);
    }

    public Node getNode(String id) {
        if (id == null) {
            throw new NullPointerException("Argument id can not be null.");
        }
        String nodeId = id;
        int indexOf = id.lastIndexOf(PATH_SEPARATOR);
        if (indexOf != -1) {
            nodeId = id.substring(indexOf + 1);
        }
        return this.nodes.get(nodeId);
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public List<Node> getTableNodes() {
        return this.tableNodes;
    }

    public List<Node> getTableNodesForActivity(String activityId) {
        ArrayList<Node> result = new ArrayList<Node>();
        TreeMap<Long, Node> candidateList = new TreeMap<Long, Node>();
        for (Node node : this) {
            if (candidateList.containsKey(node.getAuditInstance().getQueryId()) || !node.getAuditInstance().getActivityId().equals(activityId) || node.getType() != NodeType.FLOW_ELEMENT) continue;
            candidateList.put(node.getAuditInstance().getQueryId(), node);
        }
        for (Node node : candidateList.values()) {
            result.add(node);
        }
        return result;
    }

    @Override
    public Iterator<Node> iterator() {
        return this.getRootNode().getDescendants().iterator();
    }

    public String toString() {
        return "AuditTrail : BPMN Component Instance " + this.getRootNode().getAuditInstance().getComponentInstanceId() + '\n' + this.rootNode;
    }

    private static class DummyAuditInstance
    implements IAuditInstance {
        private String activityId;
        private String activityName;
        private String activityType;
        private String auditInstanceType;
        private Long auditLevel;
        private String comment;
        private String componentDn;
        private String componentInstanceId;
        private String componentName;
        private String componentType;
        private String compositeInstanceId;
        private String compositeName;
        private Calendar creationTime;
        private String dn;
        private String dnApplicationName;
        private String dnCompositeName;
        private String dnLabel;
        private String dnRevision;
        private String ecid;
        private String flowElementType;
        private String label;
        private Long loopCount;
        private Long multiInstanceCount;
        private AuditInstanceOperation operation;
        private Long parentThreadId;
        private Calendar partitionDate;
        private Long priority;
        private Calendar processDueDate;
        private String processName;
        private Long queryId;
        private String roleId;
        private String scopeId;
        private String sourceActivityId;
        private Long step;
        private String targetActivityId;
        private long tenantId;
        private Long threadId;
        private String title;
        private Long userTaskNumber;
        private static final long serialVersionUID = 200908041800L;

        private DummyAuditInstance() {
        }

        public static IAuditInstance create() {
            DummyAuditInstance dummyAuditInstance = new DummyAuditInstance();
            dummyAuditInstance.setQueryId(0L);
            dummyAuditInstance.setTitle("");
            dummyAuditInstance.setStep(0L);
            dummyAuditInstance.setLoopCount(0L);
            dummyAuditInstance.setActivityId("");
            dummyAuditInstance.setActivityName("");
            dummyAuditInstance.setActivityType("");
            dummyAuditInstance.setAuditInstanceType("");
            dummyAuditInstance.setComponentInstanceId("");
            dummyAuditInstance.setComponentName("");
            dummyAuditInstance.setComponentType("");
            dummyAuditInstance.setCompositeDn("");
            dummyAuditInstance.setCompositeInstanceId("");
            dummyAuditInstance.setCompositeName("");
            dummyAuditInstance.setProcessName("");
            dummyAuditInstance.setCreateTime(Calendar.getInstance());
            dummyAuditInstance.setDN("");
            dummyAuditInstance.setDNApplicationName("");
            dummyAuditInstance.setDNCompositeName("");
            dummyAuditInstance.setDNLabel("");
            dummyAuditInstance.setDNRevision("");
            dummyAuditInstance.setFlowElementType("");
            dummyAuditInstance.setLabel("");
            dummyAuditInstance.setOperation(AuditInstanceOperation.INSTANCE_CREATED);
            dummyAuditInstance.setParentThreadId(-1L);
            dummyAuditInstance.setProcessDueDate(Calendar.getInstance());
            dummyAuditInstance.setRoleId("");
            dummyAuditInstance.setThreadId(0L);
            dummyAuditInstance.setInstanceCount(0L);
            dummyAuditInstance.setScopeId("");
            dummyAuditInstance.setAuditLevel(0L);
            dummyAuditInstance.setComment("");
            dummyAuditInstance.setUserTaskNumber(0L);
            dummyAuditInstance.setTenantId(0L);
            dummyAuditInstance.setTargetActivity("");
            dummyAuditInstance.setSourceActivity("");
            return dummyAuditInstance;
        }

        public static IAuditInstance create(IAuditInstance auditInstance, String title) {
            DummyAuditInstance dummyAuditInstance = new DummyAuditInstance();
            dummyAuditInstance.setQueryId(auditInstance.getQueryId());
            dummyAuditInstance.setTitle(title);
            dummyAuditInstance.setStep(auditInstance.getStep());
            dummyAuditInstance.setLoopCount(auditInstance.getLoopCount());
            dummyAuditInstance.setActivityId(auditInstance.getActivityId());
            dummyAuditInstance.setActivityName(auditInstance.getActivityName());
            dummyAuditInstance.setActivityType(auditInstance.getActivityType());
            dummyAuditInstance.setAuditInstanceType(auditInstance.getAuditInstanceType());
            dummyAuditInstance.setComponentInstanceId(auditInstance.getComponentInstanceId());
            dummyAuditInstance.setComponentName(auditInstance.getComponentName());
            dummyAuditInstance.setComponentType(auditInstance.getComponentType());
            dummyAuditInstance.setCompositeDn(auditInstance.getCompositeDn());
            dummyAuditInstance.setCompositeInstanceId(auditInstance.getCompositeInstanceId());
            dummyAuditInstance.setCompositeName(auditInstance.getCompositeName());
            dummyAuditInstance.setProcessName(auditInstance.getProcessName());
            dummyAuditInstance.setCreateTime(auditInstance.getCreateTime());
            dummyAuditInstance.setDN(auditInstance.getDN());
            dummyAuditInstance.setDNApplicationName(auditInstance.getDNApplicationName());
            dummyAuditInstance.setDNCompositeName(auditInstance.getDNCompositeName());
            dummyAuditInstance.setDNLabel(auditInstance.getDNLabel());
            dummyAuditInstance.setDNRevision(auditInstance.getDNRevision());
            dummyAuditInstance.setFlowElementType(auditInstance.getFlowElementType());
            dummyAuditInstance.setLabel(auditInstance.getLabel());
            dummyAuditInstance.setOperation(auditInstance.getOperation());
            dummyAuditInstance.setParentThreadId(auditInstance.getParentThreadId());
            dummyAuditInstance.setProcessDueDate(auditInstance.getProcessDueDate());
            dummyAuditInstance.setRoleId(auditInstance.getRoleId());
            dummyAuditInstance.setThreadId(auditInstance.getThreadId());
            dummyAuditInstance.setInstanceCount(auditInstance.getInstanceCount());
            dummyAuditInstance.setScopeId(auditInstance.getScopeId());
            dummyAuditInstance.setAuditLevel(auditInstance.getAuditLevel());
            dummyAuditInstance.setComment(auditInstance.getComment());
            dummyAuditInstance.setUserTaskNumber(auditInstance.getUserTaskNumber());
            dummyAuditInstance.setTenantId(auditInstance.getTenantId());
            dummyAuditInstance.setTargetActivity(auditInstance.getTargetActivity());
            dummyAuditInstance.setSourceActivity(auditInstance.getSourceActivity());
            return dummyAuditInstance;
        }

        public static IAuditInstance createActivity(IAuditInstance auditInstance, String title) {
            return DummyAuditInstance.create(auditInstance, title);
        }

        public static IAuditInstance createGateway(IAuditInstance auditInstance, String title) {
            IAuditInstance dummyAuditInstance = DummyAuditInstance.create(auditInstance, title);
            dummyAuditInstance.setActivityId("");
            dummyAuditInstance.setActivityName("");
            dummyAuditInstance.setLabel("Threads");
            return dummyAuditInstance;
        }

        @Override
        public IAuditVariable getVariable(String name) {
            return null;
        }

        @Override
        public Map<String, IAuditVariable> getVariables() {
            return new TreeMap<String, IAuditVariable>();
        }

        @Override
        public Map<String, IAuditVariable> getAllVariables() {
            return Collections.emptyMap();
        }

        @Override
        public void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @Override
        public String getActivityId() {
            return this.activityId;
        }

        @Override
        public void setActivityName(String activityName) {
            this.activityName = activityName;
        }

        @Override
        public String getActivityName() {
            return this.activityName;
        }

        @Override
        public void setActivityType(String activityType) {
            this.activityType = activityType;
        }

        @Override
        public String getActivityType() {
            return this.activityType;
        }

        @Override
        public void setAuditInstanceType(String auditInstanceType) {
            this.auditInstanceType = auditInstanceType;
        }

        @Override
        public String getAuditInstanceType() {
            return this.auditInstanceType;
        }

        @Override
        public void setComponentInstanceId(String componenetInstanceId) {
            this.componentInstanceId = componenetInstanceId;
        }

        @Override
        public String getComponentInstanceId() {
            return this.componentInstanceId;
        }

        @Override
        public void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public String getComponentName() {
            return this.componentName;
        }

        @Override
        public void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public String getComponentType() {
            return this.componentType;
        }

        @Override
        public void setCompositeDn(String compositeDn) {
            this.componentDn = compositeDn;
        }

        @Override
        public String getCompositeDn() {
            return this.componentDn;
        }

        @Override
        public void setCompositeInstanceId(String compositeInstanceId) {
            this.compositeInstanceId = compositeInstanceId;
        }

        @Override
        public String getCompositeInstanceId() {
            return this.compositeInstanceId;
        }

        @Override
        public void setCompositeName(String compositeName) {
            this.compositeName = compositeName;
        }

        @Override
        public String getCompositeName() {
            return this.compositeName;
        }

        @Override
        public void setProcessName(String processName) {
            this.processName = processName;
        }

        @Override
        public String getProcessName() {
            return this.processName;
        }

        @Override
        public void setStep(Long step) {
            this.step = step;
        }

        @Override
        public Long getStep() {
            return this.step;
        }

        @Override
        public void setLoopCount(Long value) {
            this.loopCount = value;
        }

        @Override
        public Long getLoopCount() {
            return this.loopCount;
        }

        @Override
        public void setCreateTime(Calendar createTime) {
            this.creationTime = createTime;
        }

        @Override
        public Calendar getCreateTime() {
            return this.creationTime;
        }

        @Override
        public void setDueDate(Calendar dueDate) {
        }

        @Override
        public Calendar getDueDate() {
            return null;
        }

        @Override
        public void setFaultIsrecoverable(boolean isFailutRecoverable) {
        }

        @Override
        public boolean getFaultIsrecoverable() {
            return false;
        }

        @Override
        public void setFaultType(String faultType) {
        }

        @Override
        public String getFaultType() {
            return null;
        }

        @Override
        public void setFlowElementType(String flowElementType) {
            this.flowElementType = flowElementType;
        }

        @Override
        public String getFlowElementType() {
            return this.flowElementType;
        }

        @Override
        public void setInvokedComponentName(String invokedComponentName) {
        }

        @Override
        public String getInvokedComponentName() {
            return null;
        }

        @Override
        public void setLabel(String label) {
            this.label = label;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public void setOperation(AuditInstanceOperation operation) {
            this.operation = operation;
        }

        @Override
        public AuditInstanceOperation getOperation() {
            return this.operation;
        }

        @Override
        public void setParentThreadId(Long parentThreadId) {
            this.parentThreadId = parentThreadId;
        }

        @Override
        public Long getParentThreadId() {
            return this.parentThreadId;
        }

        @Override
        public void setParticipant(String participant) {
        }

        @Override
        public String getParticipant() {
            return null;
        }

        @Override
        public void setProcessDueDate(Calendar processDueDate) {
            this.processDueDate = processDueDate;
        }

        @Override
        public Calendar getProcessDueDate() {
            return this.processDueDate;
        }

        @Override
        public void setQueryId(Long queryId) {
            this.queryId = queryId;
        }

        @Override
        public Long getQueryId() {
            return this.queryId;
        }

        @Override
        public void setReferenceId(String referenceId) {
        }

        @Override
        public String getReferenceId() {
            return null;
        }

        @Override
        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        @Override
        public String getRoleId() {
            return this.roleId;
        }

        @Override
        public void setSourceActivity(String sourceActivity) {
            this.sourceActivityId = sourceActivity;
        }

        @Override
        public String getSourceActivity() {
            return this.sourceActivityId;
        }

        @Override
        public void setTargetActivity(String targetActivity) {
            this.targetActivityId = targetActivity;
        }

        @Override
        public String getTargetActivity() {
            return this.targetActivityId;
        }

        @Override
        public void setThreadId(Long threadId) {
            this.threadId = threadId;
        }

        @Override
        public Long getThreadId() {
            return this.threadId;
        }

        @Override
        public void setTitle(String title) {
            this.title = title;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public void setAuditLog(byte[] auditLog) {
        }

        @Override
        public byte[] getAuditLog() {
            return new byte[0];
        }

        @Override
        public String getDNApplicationName() {
            return this.dnApplicationName;
        }

        @Override
        public String getDNCompositeName() {
            return this.dnCompositeName;
        }

        @Override
        public String getDN() {
            return this.dn;
        }

        @Override
        public String getDNLabel() {
            return this.dnLabel;
        }

        @Override
        public String getDNRevision() {
            return this.dnRevision;
        }

        @Override
        public void setPartitionDate(Calendar partitionDate) {
            this.partitionDate = partitionDate;
        }

        @Override
        public Calendar getPartitionDate() {
            return this.partitionDate;
        }

        @Override
        public void setPriority(Long priority) {
            this.priority = priority;
        }

        @Override
        public Long getPriority() {
            return this.priority;
        }

        @Override
        public void addAuditPayloadElement(IAuditVariable element) {
        }

        @Override
        public Map<String, IAuditVariable> getPayloadElements() {
            return Collections.emptyMap();
        }

        @Override
        public Calendar getDateValue(int slot) {
            return null;
        }

        @Override
        public void setDateValue(int slot, Calendar value) {
        }

        @Override
        public BigDecimal getNumberValue(int slot) {
            return null;
        }

        @Override
        public void setNumberValue(int slot, BigDecimal value) {
        }

        @Override
        public String getStringValue(int slot) {
            return null;
        }

        @Override
        public void setStringValue(int slot, String value) {
        }

        @Override
        public void setDateValues(List<Calendar> values) {
        }

        @Override
        public void setNumberValues(List<BigDecimal> values) {
        }

        @Override
        public void setStringValues(List<String> values) {
        }

        @Override
        public List<String> getStringValues() {
            return new ArrayList<String>();
        }

        @Override
        public List<BigDecimal> getNumberValues() {
            return new ArrayList<BigDecimal>();
        }

        @Override
        public List<Calendar> getDateValues() {
            return new ArrayList<Calendar>();
        }

        @Override
        public boolean hasPayload() {
            return false;
        }

        @Override
        public void addAssociatedVariable(String name) {
        }

        @Override
        public void setAssociatedVariables(List<String> associatedVariables) {
        }

        @Override
        public void setInstanceCount(Long multiInstanceCount) {
            this.multiInstanceCount = multiInstanceCount;
        }

        @Override
        public Long getInstanceCount() {
            return this.multiInstanceCount;
        }

        @Override
        public void setScopeId(String scopeId) {
            this.scopeId = scopeId;
        }

        @Override
        public String getScopeId() {
            return this.scopeId;
        }

        @Override
        public void setAuditLevel(Long auditLevel) {
            this.auditLevel = auditLevel;
        }

        @Override
        public Long getAuditLevel() {
            return this.auditLevel;
        }

        @Override
        public String getComment() {
            return null;
        }

        @Override
        public void setComment(String comment) {
        }

        @Override
        public boolean isMinimalInfoAvailable() {
            return true;
        }

        @Override
        public Document getPayloadDoc() {
            return null;
        }

        public void setVariableValue(String name, Object value) throws BPMException {
        }

        @Override
        public void recordDataChange(String name, Object oldValue, Object newValue) throws BPMException {
        }

        @Override
        public String getECID() {
            return this.ecid;
        }

        @Override
        public void setECID(String ecid) {
            this.ecid = ecid;
        }

        @Override
        public long getTenantId() {
            return this.tenantId;
        }

        @Override
        public void setTenantId(long tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public void setUserTaskNumber(Long userTaskNumber) {
            this.userTaskNumber = userTaskNumber;
        }

        @Override
        public Long getUserTaskNumber() {
            return this.userTaskNumber;
        }

        protected void setDNApplicationName(String dnApplicationName) {
            this.dnApplicationName = dnApplicationName;
        }

        protected void setDNCompositeName(String dnCompositeName) {
            this.dnCompositeName = dnCompositeName;
        }

        protected void setDN(String dn) {
            this.dn = dn;
        }

        protected void setDNLabel(String dnLabel) {
            this.dnLabel = dnLabel;
        }

        protected void setDNRevision(String dnRevision) {
            this.dnRevision = dnRevision;
        }
    }

    private static class AuditTrailFactory {
        private Map<Long, SortedSet<IAuditInstance>> auditThreads;
        private AuditTrail auditTrail;
        private Map<Long, SortedSet<Long>> childrenThreads;
        private Map<Long, Calendar> firstThreadEvent;
        private long nodeIndex;
        private Set<Long> processedThreads;

        private AuditTrailFactory() {
        }

        public static AuditTrailFactory create() {
            return new AuditTrailFactory();
        }

        public AuditTrail createAuditTrail(List<IAuditInstance> auditInstances) {
            this.auditTrail = new AuditTrail();
            if (auditInstances != null && !auditInstances.isEmpty()) {
                this.generateAuxiliarObjects(auditInstances);
                this.auditTrail.rootNode = this.generateThreadTree(null, this.auditThreads.get(0L));
                this.auditTrail.tableNodes = this.generateTableList(this.auditTrail.rootNode);
            } else {
                this.auditTrail.rootNode = new Node(DummyAuditInstance.create(), NodeType.ROOT, null, 0L);
                this.auditTrail.tableNodes = new ArrayList();
            }
            this.cleanAuxiliarObjects();
            return this.auditTrail;
        }

        public AuditTrail getAuditTrail() {
            return this.auditTrail;
        }

        List<Node> generateTableList(Node node) {
            ArrayList<Node> auditList = new ArrayList<Node>();
            HashSet<Long> auditIds = new HashSet<Long>();
            return this.buildAuditList(node.getChildren(), auditList, 0, auditIds);
        }

        private Node generateThreadTree(Node parent, SortedSet<IAuditInstance> auditInstances) {
            Node unprocessedGateway;
            IAuditInstance _auditInstance = auditInstances.first();
            this.processedThreads.add(_auditInstance.getThreadId());
            Node rootNode = this.createRootNode(parent, _auditInstance);
            this.auditTrail.nodes.put(rootNode.getId(), rootNode);
            Stack<Node> activityStack = new Stack<Node>();
            activityStack.push(rootNode);
            Node parentNode = rootNode;
            Calendar lastCreationTime = parentNode.getTimestamp();
            IAuditInstance lastAuditInstance = _auditInstance;
            for (IAuditInstance auditInstance : auditInstances) {
                Node _node;
                if (auditInstance.getFlowElementType() != null && FlowElementType.PROCESS.name().equalsIgnoreCase(auditInstance.getFlowElementType())) {
                    switch (auditInstance.getOperation()) {
                        case INSTANCE_CREATED: {
                            _node = new Node(auditInstance, NodeType.AUDIT, rootNode, ++this.nodeIndex);
                            this.auditTrail.nodes.put(_node.getId(), _node);
                            break;
                        }
                        case INSTANCE_SYSTEM_FAULT: 
                        case INSTANCE_FAULT: 
                        case INSTANCE_ABORTED: 
                        case INSTANCE_TERMINATED: 
                        case STALE_ABORTED: 
                        case STALE_COMPLETED: {
                            NodeEvent flowNodeEvent = this.getFlowNodeEvent(auditInstance.getOperation());
                            if (parentNode.getType() == NodeType.FLOW_ELEMENT) {
                                parentNode.setEvent(flowNodeEvent);
                                parentNode.setTimestamp(auditInstance.getCreateTime());
                            }
                            while (!activityStack.isEmpty()) {
                                parentNode = (Node)activityStack.pop();
                                if (parentNode == null) continue;
                                this.terminateInstance(parentNode, auditInstance);
                            }
                            Node auditNode = new Node(auditInstance, NodeType.AUDIT, rootNode, ++this.nodeIndex);
                            this.auditTrail.nodes.put(auditNode.getId(), auditNode);
                            this.terminateInstance(rootNode, auditInstance);
                            break;
                        }
                        case INSTANCE_SUSPENDED: 
                        case INSTANCE_UPDATED: 
                        case INSTANCE_RESUMED: {
                            NodeEvent flowNodeEvent = this.getFlowNodeEvent(auditInstance.getOperation());
                            if (parentNode.getType() == NodeType.FLOW_ELEMENT) {
                                parentNode.setEvent(flowNodeEvent);
                                parentNode.setTimestamp(auditInstance.getCreateTime());
                            }
                            Node auditNode = new Node(auditInstance, NodeType.AUDIT, parentNode, ++this.nodeIndex);
                            this.auditTrail.nodes.put(auditNode.getId(), auditNode);
                            this.terminateInstance(parentNode, auditInstance);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("OPERATION FOR PROCESS FLOW ELEMENT NOT SUPPORTED [" + auditInstance.getOperation().name() + "]");
                        }
                    }
                } else {
                    switch (auditInstance.getOperation()) {
                        case INSTANCE_CREATED: 
                        case FLOW_NODE_IN: {
                            unprocessedGateway = this.generateUnprocessedChildren(parentNode, auditInstance);
                            if (unprocessedGateway != null) {
                                this.auditTrail.nodes.put(unprocessedGateway.getId(), unprocessedGateway);
                                for (Node childNode : unprocessedGateway.getChildren()) {
                                    childNode.setTimestamp(auditInstance.getCreateTime());
                                }
                            }
                            Node activityNode = this.createActivityNode(parentNode, auditInstance);
                            activityStack.push(parentNode);
                            parentNode = activityNode;
                            _node = new Node(auditInstance, NodeType.AUDIT, parentNode, ++this.nodeIndex);
                            this.auditTrail.nodes.put(_node.getId(), _node);
                            break;
                        }
                        case INSTANCE_SYSTEM_FAULT: 
                        case INSTANCE_FAULT: 
                        case INSTANCE_ABORTED: 
                        case INSTANCE_TERMINATED: 
                        case STALE_ABORTED: 
                        case STALE_COMPLETED: 
                        case FLOW_NODE_OUT: 
                        case FLOW_NODE_MOVED: 
                        case FLOW_NODE_CANCELLED: {
                            unprocessedGateway = this.generateUnprocessedChildren(parentNode, auditInstance);
                            if (unprocessedGateway != null) {
                                this.auditTrail.nodes.put(unprocessedGateway.getId(), unprocessedGateway);
                                for (Node childNode : unprocessedGateway.getChildren()) {
                                    childNode.setTimestamp(auditInstance.getCreateTime());
                                }
                            }
                            _node = new Node(auditInstance, NodeType.AUDIT, parentNode, ++this.nodeIndex);
                            this.auditTrail.nodes.put(_node.getId(), _node);
                            this.terminateFlow(parentNode, auditInstance, lastCreationTime);
                            if (activityStack.isEmpty()) break;
                            parentNode = (Node)activityStack.pop();
                            break;
                        }
                        default: {
                            _node = new Node(auditInstance, NodeType.AUDIT, parentNode, ++this.nodeIndex);
                            this.auditTrail.nodes.put(_node.getId(), _node);
                        }
                    }
                }
                lastCreationTime = auditInstance.getCreateTime();
                lastAuditInstance = auditInstance;
            }
            unprocessedGateway = this.generateNotProcessedChildren(rootNode, _auditInstance);
            if (unprocessedGateway != null) {
                this.auditTrail.nodes.put(unprocessedGateway.getId(), unprocessedGateway);
            }
            if (lastAuditInstance != null) {
                String auditInstanceType = lastAuditInstance.getAuditInstanceType();
                if (unprocessedGateway != null || auditInstanceType != null && auditInstanceType.equalsIgnoreCase("END")) {
                    this.terminateFlow(parentNode, lastAuditInstance, lastCreationTime);
                }
            }
            return rootNode;
        }

        private List<Node> buildAuditList(List<Node> nodes, List<Node> auditList, int level, Set<Long> auditIds) {
            for (Node node : nodes) {
                node.setLevel(level);
                AuditInstanceOperation operation = node.getAuditInstance().getOperation();
                if (node.isIntermediate()) {
                    auditList.add(node);
                } else if ((node.getType() == NodeType.FLOW_ELEMENT && !node.isLeaf() || node.getType() == NodeType.AUDIT) && !auditIds.contains(node.getAuditInstance().getQueryId())) {
                    auditIds.add(node.getAuditInstance().getQueryId());
                    if (operation.equals(AuditInstanceOperation.INSTANCE_CREATED) || operation.equals(AuditInstanceOperation.INSTANCE_TERMINATED)) continue;
                    auditList.add(node);
                    this.moveToMainList(auditList, node, auditIds);
                }
                node.calculateUsage();
                if (node.isLeaf()) continue;
                auditList = this.buildAuditList(node.getChildren(), auditList, level + 1, auditIds);
            }
            return auditList;
        }

        private void moveToMainList(List<Node> auditList, Node node, Set<Long> auditIds) {
            for (Node childNode : node.getChildren()) {
                IAuditInstance instance = childNode.getAuditInstance();
                if (childNode.getType() != NodeType.AUDIT || instance == null || auditIds.contains(instance.getQueryId())) continue;
                auditIds.add(instance.getQueryId());
                AuditInstanceOperation operation = instance.getOperation();
                if (operation == null || !operation.equals(AuditInstanceOperation.INSTANCE_RESUMED) && !operation.equals(AuditInstanceOperation.INSTANCE_SUSPENDED) && !operation.equals(AuditInstanceOperation.INSTANCE_UPDATED) && !operation.equals(AuditInstanceOperation.INSTANCE_FAULT)) continue;
                auditList.add(childNode);
            }
        }

        private Node createActivityNode(Node parentNode, IAuditInstance auditInstance) {
            Node activityNode = new Node(DummyAuditInstance.create(auditInstance, auditInstance.getActivityId()), NodeType.FLOW_ELEMENT, parentNode, ++this.nodeIndex);
            activityNode.setEvent(NodeEvent.FLOW_ELEMENT_RUNNING);
            this.auditTrail.nodes.put(activityNode.getId(), activityNode);
            return activityNode;
        }

        private NodeEvent getFlowNodeEvent(AuditInstanceOperation operation) {
            switch (operation) {
                case FLOW_NODE_IN: {
                    return NodeEvent.FLOW_ELEMENT_RUNNING;
                }
                case FLOW_NODE_OUT: {
                    return NodeEvent.FLOW_ELEMENT_COMPLETED;
                }
                case FLOW_NODE_DATA_CHANGED: {
                    return NodeEvent.INSTANCE_UPDATED;
                }
                case INSTANCE_UPDATED: {
                    return NodeEvent.INSTANCE_UPDATED;
                }
                case FLOW_NODE_MOVED: {
                    return NodeEvent.FLOW_ELEMENT_MOVED;
                }
                case FLOW_NODE_CANCELLED: {
                    return NodeEvent.FLOW_ELEMENT_CANCELLED;
                }
                case INSTANCE_ABORTED: {
                    return NodeEvent.FLOW_ELEMENT_ABORTED;
                }
                case INSTANCE_CREATED: {
                    return NodeEvent.FLOW_ELEMENT_RUNNING;
                }
                case INSTANCE_FAULT: {
                    return NodeEvent.FLOW_ELEMENT_FAULT;
                }
                case INSTANCE_SYSTEM_FAULT: {
                    return NodeEvent.FLOW_ELEMENT_SYSTEM_FAULT;
                }
                case INSTANCE_TERMINATED: {
                    return NodeEvent.FLOW_ELEMENT_COMPLETED;
                }
                case INSTANCE_SUSPENDED: {
                    return NodeEvent.INSTANCE_SUSPENDED;
                }
                case INSTANCE_RESUMED: {
                    return NodeEvent.INSTANCE_RESUMED;
                }
                case MEASUREMENT_COUNTER: {
                    return NodeEvent.FLOW_ELEMENT_COMPLETED;
                }
                case MEASUREMENT_START: {
                    return NodeEvent.FLOW_ELEMENT_RUNNING;
                }
                case MEASUREMENT_START_STOP: {
                    return NodeEvent.FLOW_ELEMENT_COMPLETED;
                }
                case MEASUREMENT_STOP: {
                    return NodeEvent.FLOW_ELEMENT_COMPLETED;
                }
                case STALE_ABORTED: {
                    return NodeEvent.FLOW_ELEMENT_ABORTED;
                }
                case STALE_COMPLETED: {
                    return NodeEvent.FLOW_ELEMENT_COMPLETED;
                }
                case BEFORE_INPUT_DATA_ASSOCIATION: 
                case AFTER_INPUT_DATA_ASSOCIATION: 
                case BEFORE_OUTPUT_DATA_ASSOCIATION: 
                case AFTER_OUTPUT_DATA_ASSOCIATION: {
                    return NodeEvent.FLOW_ELEMENT_RUNNING;
                }
            }
            throw new IllegalArgumentException("Invalid Audit Operation '" + operation.name() + "'");
        }

        private NodeEvent getThreadNodeEvent(AuditInstanceOperation operation) {
            switch (operation) {
                case FLOW_NODE_IN: {
                    return NodeEvent.THREAD_RUNNING;
                }
                case FLOW_NODE_OUT: {
                    return NodeEvent.THREAD_COMPLETED;
                }
                case FLOW_NODE_DATA_CHANGED: {
                    return NodeEvent.INSTANCE_UPDATED;
                }
                case INSTANCE_UPDATED: {
                    return NodeEvent.INSTANCE_UPDATED;
                }
                case FLOW_NODE_CANCELLED: {
                    return NodeEvent.THREAD_CANCELLED;
                }
                case FLOW_NODE_MOVED: {
                    return NodeEvent.FLOW_NODE_MOVED;
                }
                case INSTANCE_ABORTED: {
                    return NodeEvent.THREAD_ABORTED;
                }
                case INSTANCE_CREATED: {
                    return NodeEvent.THREAD_CREATED;
                }
                case INSTANCE_FAULT: {
                    return NodeEvent.THREAD_FAULT;
                }
                case INSTANCE_SYSTEM_FAULT: {
                    return NodeEvent.THREAD_SYSTEM_FAULT;
                }
                case INSTANCE_SUSPENDED: {
                    return NodeEvent.INSTANCE_SUSPENDED;
                }
                case INSTANCE_TERMINATED: {
                    return NodeEvent.THREAD_COMPLETED;
                }
                case MEASUREMENT_COUNTER: {
                    return NodeEvent.THREAD_COMPLETED;
                }
                case MEASUREMENT_START: {
                    return NodeEvent.THREAD_RUNNING;
                }
                case MEASUREMENT_START_STOP: {
                    return NodeEvent.THREAD_COMPLETED;
                }
                case MEASUREMENT_STOP: {
                    return NodeEvent.THREAD_COMPLETED;
                }
                case STALE_ABORTED: {
                    return NodeEvent.THREAD_ABORTED;
                }
                case STALE_COMPLETED: {
                    return NodeEvent.THREAD_COMPLETED;
                }
                case BEFORE_INPUT_DATA_ASSOCIATION: 
                case AFTER_INPUT_DATA_ASSOCIATION: 
                case BEFORE_OUTPUT_DATA_ASSOCIATION: 
                case AFTER_OUTPUT_DATA_ASSOCIATION: {
                    return NodeEvent.THREAD_RUNNING;
                }
            }
            throw new IllegalArgumentException("Invalid Audit Operation '" + operation.name() + "'");
        }

        private NodeEvent getRootNodeEvent(AuditInstanceOperation operation) {
            switch (operation) {
                case FLOW_NODE_IN: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
                case FLOW_NODE_OUT: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
                case FLOW_NODE_CANCELLED: {
                    return NodeEvent.INSTANCE_TERMINATED;
                }
                case FLOW_NODE_DATA_CHANGED: {
                    return NodeEvent.INSTANCE_UPDATED;
                }
                case FLOW_NODE_MOVED: {
                    return NodeEvent.FLOW_NODE_MOVED;
                }
                case INSTANCE_UPDATED: {
                    return NodeEvent.INSTANCE_UPDATED;
                }
                case INSTANCE_ABORTED: {
                    return NodeEvent.INSTANCE_ABORTED;
                }
                case INSTANCE_CREATED: {
                    return NodeEvent.INSTANCE_CREATED;
                }
                case INSTANCE_FAULT: {
                    return NodeEvent.INSTANCE_FAULT;
                }
                case INSTANCE_SYSTEM_FAULT: {
                    return NodeEvent.INSTANCE_SYSTEM_FAULT;
                }
                case INSTANCE_TERMINATED: {
                    return NodeEvent.INSTANCE_TERMINATED;
                }
                case INSTANCE_SUSPENDED: {
                    return NodeEvent.INSTANCE_SUSPENDED;
                }
                case INSTANCE_RESUMED: {
                    return NodeEvent.INSTANCE_RESUMED;
                }
                case MEASUREMENT_COUNTER: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
                case MEASUREMENT_START: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
                case MEASUREMENT_START_STOP: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
                case MEASUREMENT_STOP: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
                case STALE_ABORTED: {
                    return NodeEvent.INSTANCE_ABORTED;
                }
                case STALE_COMPLETED: {
                    return NodeEvent.INSTANCE_TERMINATED;
                }
                case BEFORE_INPUT_DATA_ASSOCIATION: 
                case AFTER_INPUT_DATA_ASSOCIATION: 
                case BEFORE_OUTPUT_DATA_ASSOCIATION: 
                case AFTER_OUTPUT_DATA_ASSOCIATION: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
            }
            throw new IllegalArgumentException("Invalid Audit Operation '" + operation.name() + "'");
        }

        private void terminateInstance(Node parentNode, IAuditInstance auditInstance) {
            switch (parentNode.getType()) {
                case FLOW_ELEMENT: {
                    parentNode.setEvent(this.getFlowNodeEvent(auditInstance.getOperation()));
                    parentNode.setTimestamp(auditInstance.getCreateTime());
                    break;
                }
                case THREAD: {
                    parentNode.setEvent(this.getThreadNodeEvent(auditInstance.getOperation()));
                    parentNode.setTimestamp(auditInstance.getCreateTime());
                    break;
                }
                case ROOT: {
                    parentNode.setEvent(this.getRootNodeEvent(auditInstance.getOperation()));
                    parentNode.setTimestamp(auditInstance.getCreateTime());
                }
            }
        }

        private void terminateFlow(Node parentNode, IAuditInstance auditInstance, Calendar lastCreationTime) {
            switch (parentNode.getType()) {
                case FLOW_ELEMENT: {
                    parentNode.setEvent(this.getFlowNodeEvent(auditInstance.getOperation()));
                    parentNode.setTimestamp(lastCreationTime);
                    break;
                }
                case THREAD: {
                    parentNode.setEvent(this.getThreadNodeEvent(auditInstance.getOperation()));
                    parentNode.setTimestamp(auditInstance.getCreateTime());
                }
            }
        }

        private Node generateUnprocessedChildren(Node parentNode, @NotNull IAuditInstance auditInstance) {
            Map<Long, SortedSet<IAuditInstance>> unprocessedChildren = this.getUnprocessedChildren(auditInstance.getThreadId(), auditInstance.getQueryId());
            Node unprocessedGateway = null;
            if (!unprocessedChildren.isEmpty()) {
                unprocessedGateway = new Node(DummyAuditInstance.createGateway(auditInstance, "Gateway"), NodeType.GROUP_THREAD, parentNode, ++this.nodeIndex);
                unprocessedGateway.setEvent(NodeEvent.THREAD_GROUPED);
                for (SortedSet<IAuditInstance> child : unprocessedChildren.values()) {
                    unprocessedGateway.addChild(this.generateThreadTree(unprocessedGateway, child));
                }
            }
            return unprocessedGateway;
        }

        private Node generateNotProcessedChildren(Node parentNode, @NotNull IAuditInstance auditInstance) {
            Map<Long, SortedSet<IAuditInstance>> unprocessedChildren = this.getUnprocessedChildren(auditInstance.getThreadId());
            Node unprocessedGateway = null;
            if (!unprocessedChildren.isEmpty()) {
                unprocessedGateway = new Node(DummyAuditInstance.createGateway(auditInstance, "Gateway"), NodeType.GROUP_THREAD, parentNode, ++this.nodeIndex);
                unprocessedGateway.setEvent(NodeEvent.THREAD_GROUPED);
                for (SortedSet<IAuditInstance> child : unprocessedChildren.values()) {
                    unprocessedGateway.addChild(this.generateThreadTree(unprocessedGateway, child));
                }
            }
            return unprocessedGateway;
        }

        private Node createRootNode(Node parent, IAuditInstance auditInstance) {
            Node rootNode;
            String title = auditInstance.getComponentInstanceId();
            IAuditInstance dummyAuditInstance = DummyAuditInstance.create(auditInstance, title);
            if (parent == null) {
                rootNode = new Node(dummyAuditInstance, NodeType.ROOT, parent, ++this.nodeIndex);
                rootNode.setEvent(NodeEvent.INSTANCE_RUNNING);
                rootNode.setTimestamp(auditInstance.getCreateTime());
            } else {
                rootNode = new Node(dummyAuditInstance, NodeType.THREAD, parent, ++this.nodeIndex);
                rootNode.setEvent(NodeEvent.THREAD_RUNNING);
                rootNode.setTimestamp(auditInstance.getCreateTime());
            }
            return rootNode;
        }

        private Map<Long, SortedSet<IAuditInstance>> getUnprocessedChildren(long parentThread, long queryId) {
            HashMap<Long, SortedSet<IAuditInstance>> children = new HashMap<Long, SortedSet<IAuditInstance>>();
            if (this.childrenThreads.containsKey(parentThread)) {
                for (Long threadId : this.childrenThreads.get(parentThread)) {
                    SortedSet<IAuditInstance> auditInstances = this.auditThreads.get(threadId);
                    if (auditInstances == null || auditInstances.isEmpty()) continue;
                    IAuditInstance auditInstance = auditInstances.first();
                    if (queryId != 0L && auditInstance.getQueryId() >= queryId || this.processedThreads.contains(auditInstance.getThreadId())) continue;
                    children.put(threadId, auditInstances);
                }
            }
            return children;
        }

        private Map<Long, SortedSet<IAuditInstance>> getUnprocessedChildren(long parentThread) {
            HashMap<Long, SortedSet<IAuditInstance>> children = new HashMap<Long, SortedSet<IAuditInstance>>();
            if (this.childrenThreads.containsKey(parentThread)) {
                for (Long threadId : this.childrenThreads.get(parentThread)) {
                    IAuditInstance auditInstance;
                    SortedSet<IAuditInstance> auditInstances = this.auditThreads.get(threadId);
                    if (auditInstances == null || auditInstances.isEmpty() || this.processedThreads.contains((auditInstance = auditInstances.first()).getThreadId())) continue;
                    children.put(threadId, auditInstances);
                }
            }
            return children;
        }

        private void generateAuxiliarObjects(List<IAuditInstance> auditInstances) {
            HashMap<Long, SortedSet<IAuditInstance>> auditThreads = new HashMap<Long, SortedSet<IAuditInstance>>();
            HashMap<Long, SortedSet<Long>> childrenThreads = new HashMap<Long, SortedSet<Long>>();
            HashMap<Long, Calendar> firstThreadEvent = new HashMap<Long, Calendar>();
            for (IAuditInstance auditInstance : auditInstances) {
                TreeSet<IAuditInstance> threadAuditInstances = (TreeSet<IAuditInstance>)auditThreads.get(auditInstance.getThreadId());
                if (threadAuditInstances == null) {
                    threadAuditInstances = new TreeSet<IAuditInstance>(AuditInstanceComparator.create());
                    auditThreads.put(auditInstance.getThreadId(), threadAuditInstances);
                }
                threadAuditInstances.add(auditInstance);
                TreeSet<Long> brotherThreads = (TreeSet<Long>)childrenThreads.get(auditInstance.getParentThreadId());
                if (brotherThreads == null) {
                    brotherThreads = new TreeSet<Long>();
                    childrenThreads.put(auditInstance.getParentThreadId(), brotherThreads);
                }
                brotherThreads.add(auditInstance.getThreadId());
                Calendar firstEvent = (Calendar)firstThreadEvent.get(auditInstance.getThreadId());
                if (firstEvent != null && firstEvent.compareTo(auditInstance.getCreateTime()) <= 0) continue;
                firstThreadEvent.put(auditInstance.getThreadId(), auditInstance.getCreateTime());
            }
            this.processedThreads = new HashSet<Long>();
            this.auditThreads = auditThreads;
            this.childrenThreads = childrenThreads;
            this.firstThreadEvent = firstThreadEvent;
        }

        private void cleanAuxiliarObjects() {
            if (this.processedThreads != null) {
                this.processedThreads.clear();
            }
            if (this.auditThreads != null) {
                this.auditThreads.clear();
            }
            if (this.firstThreadEvent != null) {
                this.firstThreadEvent.clear();
            }
            if (this.childrenThreads != null) {
                this.childrenThreads.clear();
            }
            this.processedThreads = null;
            this.auditThreads = null;
            this.firstThreadEvent = null;
            this.childrenThreads = null;
            this.nodeIndex = 0L;
        }
    }

    private static class AuditInstanceComparator
    implements Comparator<IAuditInstance>,
    Serializable {
        private static final long serialVersionUID = 2334883749398773051L;

        private AuditInstanceComparator() {
        }

        public static AuditInstanceComparator create() {
            return new AuditInstanceComparator();
        }

        @Override
        public int compare(IAuditInstance left, IAuditInstance right) {
            if (left == null || right == null) {
                throw new NullPointerException("Arguments must not be null ('" + left + "', '" + right + "').");
            }
            int compareValue = left.getCreateTime().compareTo(right.getCreateTime());
            return compareValue != 0 ? compareValue : left.getQueryId().compareTo(right.getQueryId());
        }
    }

    public static class Node
    implements Comparable<Node> {
        private IAuditInstance auditInstance;
        private Set<Node> children;
        private Calendar createTime;
        private Long duration;
        private Calendar endTime;
        private NodeEvent event;
        private String id;
        private long index;
        private boolean isExpanded;
        private boolean isVisible;
        private int level;
        private String location;
        private String outcome;
        private Node parent;
        private String responsible;
        private Calendar timestamp;
        private NodeType type;

        protected Node(IAuditInstance auditInstance, NodeType type, Node parent, long index) {
            this.id = type.name() + "." + auditInstance.getQueryId();
            this.auditInstance = auditInstance;
            this.type = type;
            this.parent = parent;
            this.isVisible = false;
            this.isExpanded = false;
            this.children = new TreeSet<Node>();
            this.event = NodeEvent.NONE;
            this.index = index;
            this.timestamp = auditInstance.getCreateTime();
            if (parent != null) {
                parent.addChild(this);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getPath() {
            return this.parent != null ? this.parent.getPath() + AuditTrail.PATH_SEPARATOR + this.id : this.id;
        }

        public String getProcessName() {
            return this.auditInstance.getProcessName();
        }

        public String getActivityName() {
            String label;
            if (this.auditInstance.getFlowElementType() != null && FlowElementType.PROCESS.name().equalsIgnoreCase(this.auditInstance.getFlowElementType()) && (this.auditInstance.getOperation() != AuditInstanceOperation.INSTANCE_SUSPENDED || this.auditInstance.getOperation() != AuditInstanceOperation.INSTANCE_RESUMED || this.auditInstance.getOperation() != AuditInstanceOperation.INSTANCE_UPDATED)) {
                label = "";
            } else {
                switch (this.getType()) {
                    case AUDIT: 
                    case FLOW_ELEMENT: {
                        label = this.auditInstance.getLabel();
                        label = label == null || label.isEmpty() ? this.auditInstance.getActivityId() : label;
                        break;
                    }
                    default: {
                        label = "";
                    }
                }
            }
            return label;
        }

        public String getActivityType() {
            switch (this.getType()) {
                case AUDIT: {
                    return this.auditInstance.getActivityName();
                }
                case FLOW_ELEMENT: {
                    return this.auditInstance.getActivityName();
                }
            }
            return "";
        }

        public String getEventName(Locale locale) {
            return this.getEvent().getName(locale);
        }

        public NodeEvent getEvent() {
            switch (this.getType()) {
                case AUDIT: {
                    try {
                        AuditInstanceOperation operation = this.auditInstance.getOperation();
                        this.event = NodeEvent.valueOf(operation.name());
                    }
                    catch (IllegalArgumentException exception) {
                        this.event = NodeEvent.NONE;
                    }
                    if (this.event != null) break;
                    this.event = NodeEvent.NONE;
                }
            }
            return this.event;
        }

        public String getResponsible() {
            if (this.responsible != null && !this.responsible.equals("")) {
                return this.responsible;
            }
            switch (this.getType()) {
                case AUDIT: {
                    return this.auditInstance.getParticipant();
                }
            }
            return "";
        }

        public Calendar getTimestamp() {
            switch (this.getType()) {
                case AUDIT: {
                    return this.auditInstance.getCreateTime();
                }
            }
            return this.timestamp;
        }

        public long getThread() {
            return this.auditInstance.getThreadId();
        }

        public List<Node> getChildren() {
            return new ArrayList<Node>(this.children);
        }

        public String getDescription() {
            switch (this.getType()) {
                case ROOT: {
                    return this.auditInstance.getComponentInstanceId() + " : " + this.getEvent().name();
                }
                case GROUP_THREAD: {
                    return "Group Threads";
                }
                case THREAD: {
                    return "Thread " + this.auditInstance.getThreadId() + " : " + this.getEvent().name();
                }
                case AUDIT: 
                case FLOW_ELEMENT: {
                    return this.getActivityName() + " : " + this.getEvent().name();
                }
            }
            return "";
        }

        public List<Node> getDescendants() {
            ArrayList<Node> descendants = new ArrayList<Node>();
            descendants.add(this);
            for (Node node : this.getChildren()) {
                descendants.addAll(node.getDescendants());
            }
            return descendants;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public boolean isLeaf() {
            return this.getChildren().isEmpty();
        }

        public int getLevel() {
            return this.getParent() == null ? 0 : this.getParent().getLevel() + 1;
        }

        public Node getParent() {
            return this.parent;
        }

        public NodeType getType() {
            return this.type;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public IAuditInstance getAuditInstance() {
            return this.auditInstance;
        }

        public void collapse() {
            this.isExpanded = false;
            for (Node node : this.getChildren()) {
                node.hide();
                if (!node.isExpanded()) continue;
                node.collapse();
            }
        }

        public void expand() {
            this.isExpanded = true;
            for (Node node : this.getChildren()) {
                node.show();
            }
        }

        public void expandAll() {
            this.isExpanded = true;
            for (Node node : this.getChildren()) {
                node.show();
                node.expandAll();
            }
        }

        public void hide() {
            this.isVisible = false;
        }

        public void show() {
            this.isVisible = true;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.getLevel(); ++i) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(this.getId());
            stringBuffer.append(" - ");
            stringBuffer.append(this.getDescription());
            for (Node child : this.getChildren()) {
                stringBuffer.append("\n");
                stringBuffer.append(child.toString());
            }
            return stringBuffer.toString();
        }

        @Override
        public int compareTo(Node node) {
            if (node == null) {
                return 1;
            }
            return (int)(this.getIndex() - node.getIndex());
        }

        public void calculateUsage() {
            if (this.children.size() == 0) {
                this.endTime = this.createTime = this.getAuditInstance().getCreateTime();
            }
            for (Node node : this.children) {
                if (NodeEvent.FLOW_NODE_IN == node.getEvent()) {
                    this.createTime = node.getAuditInstance().getCreateTime();
                    this.calculateLocation();
                } else {
                    if (node.getActivityName().equals("USER_TASK")) {
                        this.setOutcome();
                    }
                    this.endTime = node.getAuditInstance().getCreateTime();
                }
                this.responsible = node.getAuditInstance().getParticipant();
            }
            this.duration = this.createTime != null && this.endTime != null ? Long.valueOf(this.endTime.getTimeInMillis() - this.createTime.getTimeInMillis()) : null;
        }

        public void calculateLocation() {
            ArrayList<String> parentNames = new ArrayList<String>();
            for (Node parentNode = this.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
                if (parentNode.getType() != NodeType.FLOW_ELEMENT) continue;
                String parentName = parentNode.getActivityName() + "[" + parentNode.getThread() + "]";
                parentNames.add(0, parentName);
            }
            this.location = "/" + this.getProcessName();
            for (int i = 0; i < parentNames.size(); ++i) {
                this.location = this.location + "/" + parentNames.get(i);
            }
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public Calendar getCreateTime() {
            return this.createTime;
        }

        public Calendar getEndTime() {
            return this.endTime;
        }

        public String getLocation() {
            return this.location;
        }

        public Long getTaskNumber() {
            return this.getAuditInstance().getUserTaskNumber();
        }

        public String getOutcome() {
            return this.outcome;
        }

        public Long getDuration() {
            return this.duration;
        }

        public boolean isMeasurement() {
            AuditInstanceOperation op = this.auditInstance.getOperation();
            return op == AuditInstanceOperation.MEASUREMENT_START || op == AuditInstanceOperation.MEASUREMENT_START_STOP || op == AuditInstanceOperation.MEASUREMENT_STOP;
        }

        protected void addChildren(List<Node> childNodes) {
            for (Node node : childNodes) {
                this.addChild(node);
            }
        }

        protected void addChild(Node node) {
            node.parent = this;
            this.children.add(node);
        }

        protected void removeChild(Node node) {
            this.children.remove(node);
        }

        protected void setEvent(NodeEvent event) {
            this.event = event;
        }

        protected void setTimestamp(Calendar timestamp) {
            this.timestamp = timestamp;
        }

        protected long getIndex() {
            return this.index;
        }

        private void setOutcome() {
        }

        private boolean isIntermediate() {
            return "INTERMEDIATE".equals(this.auditInstance.getAuditInstanceType());
        }

        private void setLevel(int level) {
            this.level = level;
        }
    }

    private static enum FlowElementType {
        PROCESS,
        SEQUENCE,
        ACTIVITY,
        GATEWAY;

    }

    public static enum NodeEvent {
        INSTANCE_CREATED,
        INSTANCE_RUNNING,
        INSTANCE_TERMINATED,
        INSTANCE_ABORTED,
        INSTANCE_FAULT,
        INSTANCE_SYSTEM_FAULT,
        INSTANCE_UPDATED,
        INSTANCE_SUSPENDED,
        INSTANCE_RESUMED,
        FLOW_ELEMENT_RUNNING,
        FLOW_ELEMENT_COMPLETED,
        FLOW_ELEMENT_MOVED,
        FLOW_ELEMENT_FAULT,
        FLOW_ELEMENT_SYSTEM_FAULT,
        FLOW_ELEMENT_CANCELLED,
        FLOW_ELEMENT_ABORTED,
        THREAD_CREATED,
        THREAD_RUNNING,
        THREAD_COMPLETED,
        THREAD_ABORTED,
        THREAD_FAULT,
        THREAD_SYSTEM_FAULT,
        THREAD_CANCELLED,
        THREAD_GROUPED,
        FLOW_NODE_IN,
        FLOW_NODE_OUT,
        FLOW_NODE_DATA_CHANGED,
        FLOW_NODE_MOVED,
        FLOW_NODE_CANCELLED,
        MEASUREMENT_START,
        MEASUREMENT_STOP,
        MEASUREMENT_START_STOP,
        MEASUREMENT_COUNTER,
        STALE_ABORTED,
        STALE_COMPLETED,
        BEFORE_INPUT_DATA_ASSOCIATION,
        AFTER_INPUT_DATA_ASSOCIATION,
        BEFORE_OUTPUT_DATA_ASSOCIATION,
        AFTER_OUTPUT_DATA_ASSOCIATION,
        BEFORE_ITERATION,
        BEFORE_INSTANCE_EXECUTION,
        AFTER_INSTANCE_EXECUTION,
        BEFORE_ACTIVITY_EXECUTION,
        AFTER_ACTIVITY_EXECUTION,
        NONE,
        ACTIVITY_IN,
        ACTIVITY_OUT,
        INSTANCE_ABORTING,
        INSTANCE_SELECTED,
        INSTANCE_UNSELECTED,
        INSTANCE_REASSIGNED,
        INSTANCE_GRABBED,
        INSTANCE_UNGRABBED,
        INSTANCE_BACK,
        INSTANCE_SKIP,
        SUBFLOW_INSTANCE_CREATED,
        SEQUENCE_PROCESSED,
        EVENT_PROCESSED,
        GATEWAY_PROCESSED,
        TASK_STARTED,
        TASK_FINISHED,
        TASK_SELECTED,
        TASK_UNSELECTED,
        TASK_REASSIGNED,
        FLOW_ELEMENT_INTERRUPTED;


        public String getName(Locale locale) {
            return BPMServicesResource.getNotNullResource(this.name(), locale);
        }
    }

    public static enum NodeType {
        ROOT,
        FLOW_ELEMENT,
        GROUP_THREAD,
        THREAD,
        AUDIT;

    }
}

