/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processsimulation.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpm.services.processsimulation.DistributionCriteria;
import oracle.bpm.services.processsimulation.model.ProcessSimulationModel;
import oracle.bpm.services.processsimulation.model.impl.ProcessSimulationModelHelper;
import oracle.bpm.services.processsimulation.model.jaxb.ProcessSimulationModelViewType;
import org.jetbrains.annotations.NotNull;

public class ProcessSimulationModelImpl
implements ProcessSimulationModel,
Serializable {
    private DistributionCriteria distributionCriteria;
    private Calendar from;
    private List<PrincipleRefType> grantees;
    private String model;
    private String name;
    private String process;
    private Calendar to;
    private UserApplicationDataType userApplicationDataType;
    private static final long serialVersionUID = 20110315163900000L;

    private ProcessSimulationModelImpl(String id, @NotNull String name, @NotNull String process) {
        this.name = name;
        this.process = process;
        this.distributionCriteria = DistributionCriteria.DAILY;
        this.grantees = new ArrayList<PrincipleRefType>();
    }

    public static ProcessSimulationModelImpl create(@NotNull String name, @NotNull String process, @NotNull Calendar from, @NotNull Calendar to, @NotNull DistributionCriteria distributionCriteria) {
        ProcessSimulationModelImpl processSimulationModelView = new ProcessSimulationModelImpl(null, name, process);
        processSimulationModelView.from = from;
        processSimulationModelView.to = to;
        processSimulationModelView.distributionCriteria = distributionCriteria;
        return processSimulationModelView;
    }

    public static ProcessSimulationModelImpl create(@NotNull UserApplicationDataType userApplicationDataType) {
        ProcessSimulationModelImpl processSimulationModel = new ProcessSimulationModelImpl(userApplicationDataType.getId(), userApplicationDataType.getName(), "UNKNOWN");
        if (userApplicationDataType.getData() != null) {
            ProcessSimulationModelViewType processSimulationModelViewType = ProcessSimulationModelHelper.loadProcessSimulationModelViewType(userApplicationDataType.getData());
            processSimulationModel.process = processSimulationModelViewType.getProcess();
            processSimulationModel.from = processSimulationModelViewType.getFrom().toGregorianCalendar();
            processSimulationModel.to = processSimulationModelViewType.getTo().toGregorianCalendar();
            processSimulationModel.distributionCriteria = ProcessSimulationModelHelper.getDistributionCriteria(processSimulationModelViewType.getDistributionCriteria());
            processSimulationModel.model = processSimulationModelViewType.getModel();
        }
        processSimulationModel.userApplicationDataType = userApplicationDataType;
        processSimulationModel.grantees = userApplicationDataType.getGrantees() == null ? new ArrayList() : userApplicationDataType.getGrantees().getParticipant();
        return processSimulationModel;
    }

    public static ProcessSimulationModelImpl create(@NotNull ProcessSimulationModel view) {
        ProcessSimulationModelImpl processSimulationModel = new ProcessSimulationModelImpl(view.getId(), view.getName(), view.getProcess());
        processSimulationModel.from = view.getFrom();
        processSimulationModel.to = view.getTo();
        processSimulationModel.distributionCriteria = view.getDistributionCriteria();
        processSimulationModel.model = view.getModel();
        processSimulationModel.grantees = view.getGrantees() == null ? new ArrayList() : view.getGrantees();
        return processSimulationModel;
    }

    @Override
    public String getId() {
        return this.userApplicationDataType == null ? null : this.userApplicationDataType.getId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProcess() {
        return this.process;
    }

    public void setProcess(@NotNull String process) {
        this.process = process;
    }

    @Override
    public Calendar getFrom() {
        return this.from;
    }

    public void setFrom(Calendar from) {
        this.from = from;
    }

    @Override
    public Calendar getTo() {
        return this.to;
    }

    public void setTo(Calendar to) {
        this.to = to;
    }

    @Override
    public DistributionCriteria getDistributionCriteria() {
        return this.distributionCriteria;
    }

    public void setDistributionCriteria(DistributionCriteria distributionCriteria) {
        this.distributionCriteria = distributionCriteria;
    }

    @Override
    public String getCreatedBy() {
        return this.userApplicationDataType == null ? null : this.userApplicationDataType.getCreatedBy();
    }

    @Override
    public Calendar getCreatedDate() {
        return this.userApplicationDataType == null ? null : this.userApplicationDataType.getCreatedDate();
    }

    @Override
    public String getUpdatedBy() {
        return this.userApplicationDataType == null ? null : this.userApplicationDataType.getUpdatedBy();
    }

    @Override
    public Calendar getUpdatedDate() {
        return this.userApplicationDataType == null ? null : this.userApplicationDataType.getUpdatedDate();
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public void setModel(@NotNull String model) {
        this.model = model;
    }

    @Override
    public List<PrincipleRefType> getGrantees() {
        return this.grantees;
    }

    @Override
    public void addGrantee(@NotNull PrincipleRefType principleRef) {
        this.grantees.add(principleRef);
    }

    @Override
    public void removeGrantee(@NotNull PrincipleRefType principleRef) {
        this.grantees.remove(principleRef);
    }

    @Override
    public void clearGrantees() {
        this.grantees.clear();
    }

    public UserApplicationDataType getUserApplicationDataType() {
        if (this.userApplicationDataType != null) {
            return ProcessSimulationModelHelper.createUserApplicationDataType(this.userApplicationDataType, this);
        }
        return ProcessSimulationModelHelper.createUserApplicationDataType(this);
    }
}

