/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processsimulation.model.impl;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpel.services.workflow.common.model.ObjectFactory;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpm.services.common.exception.BPMRuntimeException;
import oracle.bpm.services.processsimulation.DistributionCriteria;
import oracle.bpm.services.processsimulation.model.ProcessSimulationModel;
import oracle.bpm.services.processsimulation.model.jaxb.ProcessSimulationModelViewType;
import org.jetbrains.annotations.NotNull;

public class ProcessSimulationModelHelper {
    private static oracle.bpm.services.processsimulation.model.jaxb.ObjectFactory simulationModelFactory;
    private static oracle.bpel.services.workflow.user.model.ObjectFactory userModelFactory;
    private static ObjectFactory workflowModelFactory;
    private static JAXBContext jaxbContext;
    private static int MINUTE;

    public static UserApplicationDataType createUserApplicationDataType(@NotNull String name, @NotNull String process, @NotNull Calendar from, @NotNull Calendar to, @NotNull DistributionCriteria distributionCriteria) {
        ProcessSimulationModelViewType processSimulationModelViewType = ProcessSimulationModelHelper.getSimulationModelFactory().createProcessSimulationModelViewType();
        processSimulationModelViewType.setName(name);
        processSimulationModelViewType.setProcess(process);
        processSimulationModelViewType.setFrom(ProcessSimulationModelHelper.getXMLGregorianCalendar(from));
        processSimulationModelViewType.setTo(ProcessSimulationModelHelper.getXMLGregorianCalendar(to));
        processSimulationModelViewType.setDistributionCriteria(distributionCriteria.name());
        UserApplicationDataType userApplicationDataType = ProcessSimulationModelHelper.getUserModelFactory().createUserApplicationDataType();
        userApplicationDataType.setName(name);
        userApplicationDataType.setApplicationDataType("SIMULATION_MODEL");
        userApplicationDataType.setData(ProcessSimulationModelHelper.processSimulationModelViewTypeAsXML(processSimulationModelViewType));
        return userApplicationDataType;
    }

    public static UserApplicationDataType createUserApplicationDataType(@NotNull ProcessSimulationModel view) {
        UserApplicationDataType userApplicationDataType = ProcessSimulationModelHelper.getUserModelFactory().createUserApplicationDataType();
        userApplicationDataType.setName(view.getName());
        userApplicationDataType.setApplicationDataType("SIMULATION_MODEL");
        userApplicationDataType.setData(ProcessSimulationModelHelper.processSimulationModelViewAsXML(view));
        userApplicationDataType.setGrantees(ProcessSimulationModelHelper.getWorkflowModelFactory().createPrincipleListType());
        userApplicationDataType.getGrantees().getParticipant().addAll(view.getGrantees());
        return userApplicationDataType;
    }

    public static UserApplicationDataType createUserApplicationDataType(UserApplicationDataType userApplicationDataType, @NotNull ProcessSimulationModel view) {
        if (userApplicationDataType == null) {
            return ProcessSimulationModelHelper.createUserApplicationDataType(view);
        }
        userApplicationDataType.setData(ProcessSimulationModelHelper.processSimulationModelViewAsXML(view));
        userApplicationDataType.setGrantees(ProcessSimulationModelHelper.getWorkflowModelFactory().createPrincipleListType());
        userApplicationDataType.getGrantees().getParticipant().addAll(view.getGrantees());
        return userApplicationDataType;
    }

    public static DistributionCriteria getDistributionCriteria(String distributionCriteria) {
        if (distributionCriteria == null) {
            return DistributionCriteria.DAILY;
        }
        try {
            return DistributionCriteria.valueOf(distributionCriteria);
        }
        catch (Exception exception) {
            return DistributionCriteria.DAILY;
        }
    }

    public static oracle.bpm.services.processsimulation.model.jaxb.ObjectFactory getSimulationModelFactory() {
        if (simulationModelFactory == null) {
            simulationModelFactory = new oracle.bpm.services.processsimulation.model.jaxb.ObjectFactory();
        }
        return simulationModelFactory;
    }

    public static oracle.bpel.services.workflow.user.model.ObjectFactory getUserModelFactory() {
        if (userModelFactory == null) {
            userModelFactory = new oracle.bpel.services.workflow.user.model.ObjectFactory();
        }
        return userModelFactory;
    }

    public static ObjectFactory getWorkflowModelFactory() {
        if (workflowModelFactory == null) {
            workflowModelFactory = new ObjectFactory();
        }
        return workflowModelFactory;
    }

    public static ProcessSimulationModelViewType loadProcessSimulationModelViewType(@NotNull String xml) {
        try {
            StringReader stringReader = new StringReader(xml);
            JAXBContext jaxbContext = ProcessSimulationModelHelper.getJaxbContext();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement ProcessSimulationModelViewTypeDoc = (JAXBElement)unmarshaller.unmarshal((Reader)stringReader);
            return (ProcessSimulationModelViewType)ProcessSimulationModelViewTypeDoc.getValue();
        }
        catch (JAXBException cause) {
            throw new BPMRuntimeException(71404, new String[]{xml}, cause);
        }
    }

    public static String processSimulationModelViewAsXML(@NotNull ProcessSimulationModel view) {
        ProcessSimulationModelViewType type = ProcessSimulationModelHelper.getSimulationModelFactory().createProcessSimulationModelViewType();
        type.setName(view.getName());
        type.setProcess(view.getProcess());
        type.setFrom(ProcessSimulationModelHelper.getXMLGregorianCalendar(view.getFrom()));
        type.setTo(ProcessSimulationModelHelper.getXMLGregorianCalendar(view.getTo()));
        type.setDistributionCriteria(view.getDistributionCriteria().name());
        type.setModel(view.getModel());
        return ProcessSimulationModelHelper.processSimulationModelViewTypeAsXML(type);
    }

    public static String processSimulationModelViewTypeAsXML(@NotNull ProcessSimulationModelViewType type) {
        try {
            StringWriter writer = new StringWriter();
            JAXBContext jaxbContext = ProcessSimulationModelHelper.getJaxbContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal(ProcessSimulationModelHelper.getSimulationModelFactory().createProcessSimulationModelView(type), (Writer)writer);
            writer.flush();
            return writer.toString();
        }
        catch (JAXBException cause) {
            throw new BPMRuntimeException(71405, new String[0], cause);
        }
    }

    private static XMLGregorianCalendar getXMLGregorianCalendar(@NotNull Calendar calendar) {
        try {
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            int timezone = calendar.getTimeZone().getRawOffset();
            int n = year = year < 1 ? 1 : year;
            int n2 = month < 1 ? 1 : (month = month > 12 ? 12 : month);
            day = day < 1 ? 1 : (day > 31 ? 31 : day);
            return DatatypeFactory.newInstance().newXMLGregorianCalendarDate(year, month, day, timezone /= MINUTE);
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getCData(String data) {
        if (data == null) {
            return null;
        }
        return "![CDATA[\n" + data + "\n]]>";
    }

    private static JAXBContext getJaxbContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)ProcessSimulationModelViewType.class.getPackage().getName());
        }
        return jaxbContext;
    }

    static {
        MINUTE = 60000;
    }
}

