/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model.impl;

import oracle.bpm.services.processdashboard.model.Data;
import oracle.bpm.services.processdashboard.model.Visualization;
import oracle.bpm.services.processdashboard.model.Widget;
import oracle.bpm.services.processdashboard.model.impl.DataImpl;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.impl.VisualizationImpl;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;
import org.jetbrains.annotations.NotNull;

public class WidgetImpl
implements Widget {
    private WidgetType widgetType = ModelTypeFactory.getWidgetTypeFactory().createWidgetType();
    private static final long serialVersionUID = 20090821164235L;

    private WidgetImpl() {
    }

    public static WidgetImpl create() {
        return new WidgetImpl();
    }

    public static WidgetImpl create(WidgetType widgetType) {
        WidgetImpl widget = new WidgetImpl();
        widget.setWidgetType(widgetType);
        return widget;
    }

    public static WidgetImpl create(Widget widget) {
        WidgetImpl widgetImpl = new WidgetImpl();
        widgetImpl.setVisualization(widget.getVisualization());
        widgetImpl.setData(widget.getData());
        return widgetImpl;
    }

    public static WidgetImpl create(String widgetXML) {
        return WidgetImpl.create(ModelTypeFactory.createWidgetType(widgetXML));
    }

    public WidgetType getWidgetType() {
        return this.widgetType;
    }

    public void setWidgetType(WidgetType widgetType) {
        this.widgetType = widgetType;
    }

    @Override
    public Visualization getVisualization() {
        if (!this.widgetType.isSetVisualization()) {
            this.widgetType.setVisualization(ModelTypeFactory.createVisualizationType(VisualizationImpl.create()));
        }
        return VisualizationImpl.create(this.widgetType.getVisualization());
    }

    @Override
    public void setVisualization(@NotNull Visualization visualization) {
        this.widgetType.setVisualization(ModelTypeFactory.createVisualizationType(visualization));
    }

    @Override
    public Data getData() {
        if (!this.widgetType.isSetData()) {
            this.widgetType.setData(ModelTypeFactory.createDataType(DataImpl.create()));
        }
        return DataImpl.create(this.widgetType.getData());
    }

    @Override
    public void setData(@NotNull Data data) {
        this.widgetType.setData(ModelTypeFactory.createDataType(data));
    }
}

