/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import oracle.bpm.collections.comparators.LocaleComparator;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.services.processdashboard.model.ComponentType;
import oracle.bpm.services.processdashboard.model.Title;
import oracle.bpm.services.processdashboard.model.Visualization;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.impl.TitleImpl;
import oracle.bpm.services.processdashboard.model.jaxb.ObjectFactory;
import oracle.bpm.services.processdashboard.model.jaxb.TitleType;
import oracle.bpm.services.processdashboard.model.jaxb.VisualizationType;
import org.jetbrains.annotations.NotNull;

public class VisualizationImpl
implements Visualization {
    private transient LocaleStringMap labels;
    private transient Map<Locale, Title> titles;
    private VisualizationType visualizationType = new ObjectFactory().createVisualizationType();
    protected static final long serialVersionUID = 20090821115300L;

    protected VisualizationImpl() {
        this.titles = new TreeMap<Locale, Title>((Comparator<Locale>)LocaleComparator.INSTANCE);
        this.labels = LocaleStringMap.create();
    }

    public static VisualizationImpl create() {
        return new VisualizationImpl();
    }

    public static VisualizationImpl create(VisualizationType visualizationType) {
        VisualizationImpl visualization = new VisualizationImpl();
        visualization.setVisualizationType(visualizationType);
        return visualization;
    }

    public VisualizationType getVisualizationType() {
        return this.visualizationType;
    }

    public void setVisualizationType(VisualizationType visualizationType) {
        this.visualizationType = visualizationType;
        this.titles = new TreeMap<Locale, Title>((Comparator<Locale>)LocaleComparator.INSTANCE);
        this.labels = LocaleStringMap.create();
        if (visualizationType.isSetTitles()) {
            for (TitleType titleType : visualizationType.getTitles()) {
                TitleImpl title = TitleImpl.create(titleType);
                this.titles.put(title.getLocale(), title);
                this.labels.put(title.getLocale(), title.getValue());
            }
        }
    }

    @Override
    public boolean hasComponentType() {
        return this.visualizationType.isSetType();
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.valueOf(this.visualizationType.getType());
    }

    @Override
    public void setComponentType(@NotNull ComponentType componentType) {
        this.visualizationType.setType(componentType.name());
    }

    @Override
    public boolean hasTitle() {
        return this.visualizationType.isSetTitles();
    }

    @Override
    public String getTitle(@NotNull Locale locale) {
        String label = this.labels.getString(locale);
        if (label.isEmpty()) {
            label = this.labels.getString(Locale.ENGLISH);
        }
        return label;
    }

    public String getTitle() {
        String label = this.labels.getString();
        return label == null ? "" : label;
    }

    @Override
    public void setTitle(@NotNull Title title) {
        this.visualizationType.getTitles().add(ModelTypeFactory.createTitleType(title));
        this.titles.put(title.getLocale(), title);
        this.labels.put(title.getLocale(), title.getValue());
    }

    @Override
    public List<Title> getTitles() {
        ArrayList<Title> _titles = new ArrayList<Title>();
        _titles.addAll(this.titles.values());
        return _titles;
    }

    @Override
    public boolean hasDefinition() {
        return this.visualizationType.isSetDefinition();
    }

    @Override
    public String getDefinition() {
        return this.visualizationType.getDefinition();
    }

    @Override
    public void setDefinition(@NotNull String definition) {
        this.visualizationType.setDefinition(definition);
    }

    @Override
    public String getProperty(@NotNull String key) {
        return this.visualizationType.getOtherAttributes().get(new QName(key));
    }

    @Override
    public void putProperty(@NotNull String key, String value) {
        this.visualizationType.getOtherAttributes().put(new QName(key), value);
    }

    @Override
    public String removeProperty(@NotNull String key) {
        return this.visualizationType.getOtherAttributes().remove(new QName(key));
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll(this.visualizationType.getOtherAttributes());
        return properties;
    }
}

