/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model.impl;

import java.util.Locale;
import oracle.bpm.services.processdashboard.model.Title;
import oracle.bpm.services.processdashboard.model.jaxb.ObjectFactory;
import oracle.bpm.services.processdashboard.model.jaxb.TitleType;
import org.jetbrains.annotations.NotNull;

public class TitleImpl
implements Title {
    private TitleType titleType;
    private static final long serialVersionUID = 20090824095400L;

    public static TitleImpl create() {
        return TitleImpl.create(new ObjectFactory().createTitleType());
    }

    public static TitleImpl create(TitleType titleType) {
        TitleImpl title = new TitleImpl();
        title.setTitleType(titleType);
        return title;
    }

    public static TitleImpl create(@NotNull Title title) {
        TitleImpl titleImpl = new TitleImpl();
        titleImpl.getTitleType().setLang(title.getLocale().getLanguage());
        titleImpl.getTitleType().setCountry(title.getLocale().getCountry());
        titleImpl.getTitleType().setValue(title.getValue());
        return titleImpl;
    }

    public TitleType getTitleType() {
        return this.titleType;
    }

    public void setTitleType(@NotNull TitleType titleType) {
        this.titleType = titleType;
    }

    @Override
    public String getValue() {
        if (this.titleType.isSetValue()) {
            return this.titleType.getValue();
        }
        return "";
    }

    @Override
    public void setValue(@NotNull String title) {
        this.titleType.setValue(title);
    }

    @Override
    public Locale getLocale() {
        if (this.titleType.isSetLang() && !this.titleType.getLang().isEmpty()) {
            if (this.titleType.isSetCountry() && !this.titleType.getCountry().isEmpty()) {
                return new Locale(this.titleType.getLang(), this.titleType.getCountry());
            }
            return new Locale(this.titleType.getLang());
        }
        return Locale.getDefault();
    }

    @Override
    public void setLocale(@NotNull Locale locale) {
        this.titleType.setLang(locale.getLanguage());
        this.titleType.setCountry(locale.getCountry());
    }
}

