/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.internal.processmodel.model.impl;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.services.internal.processmodel.model.IProcessModelPackage;
import org.jetbrains.annotations.NotNull;

public class ProcessModelPackageImpl
implements IProcessModelPackage {
    private List<Process> callees;
    private Locale defaultLanguage;
    private Process processModel;
    private Process projectModel;
    private String projectName;
    public static final String NAMESPACE = "http://xmlns.oracle.com/bpm/ProcessModelPackage";
    public static final QName QNAME_MODELPACKAGE = new QName("http://xmlns.oracle.com/bpm/ProcessModelPackage", "projectPackage");
    public static final QName QNAME_PROJECTMODEL = new QName("http://xmlns.oracle.com/bpm/ProcessModelPackage", "projectModel");
    public static final QName ATTR_QNAME_PROJECTMODEL_NAME = new QName("projectName");
    public static final QName ATTR_QNAME_PROJECTMODEL_DEFAULTLOCALE = new QName("defaultLocale");
    public static final QName QNAME_PROCESSMODEL = new QName("http://xmlns.oracle.com/bpm/ProcessModelPackage", "processModel");
    public static final QName ATTR_QNAME_PROCESSMODEL_NAME = new QName("processName");
    public static final QName QNAME_CALLEES = new QName("http://xmlns.oracle.com/bpm/ProcessModelPackage", "callees");

    private ProcessModelPackageImpl(@NotNull Process projectModel, @NotNull String projectName, Locale defaultLanguage, @NotNull Process processModel, @NotNull List<Process> callees) {
        this.projectName = projectName;
        this.projectModel = projectModel;
        this.processModel = processModel;
        this.defaultLanguage = defaultLanguage;
        this.callees = Collections.unmodifiableList(callees);
    }

    public static IProcessModelPackage create(Process projectModel, String projectName, Locale defaultLanguage, Process processModel, List<Process> callees) {
        return new ProcessModelPackageImpl(projectModel, projectName, defaultLanguage, processModel, callees);
    }

    @Override
    public Process getProjectModel() {
        return this.projectModel;
    }

    @Override
    public Process getProcessModel() {
        return this.processModel;
    }

    @Override
    public List<Process> getCallees() {
        return this.callees;
    }

    @Override
    public Locale getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    public String toString() {
        return "ProcessModelPackageImpl{projectName='" + this.projectName + '\'' + ", projectModel=" + this.projectModel + ", processModel=" + this.processModel + ", callees=" + this.callees + '}';
    }
}

