/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancequery.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.bpm.services.instancequery.IAuditVariableRange;

public class AuditVariableMetadata
implements IAuditVariableMetadata,
Serializable {
    private List<IAuditVariableRange> mAllRanges;
    private String mCompositeDn;
    private List<String> mDateNames;
    private List<String> mDateTypes;
    private int mNextDate;
    private int mNextNumber;
    private int mNextString;
    private List<String> mNumberModelTypes;
    private List<String> mNumberNames;
    private List<String> mNumberTypes;
    private List<String> mStringModelTypes;
    private List<String> mStringNames;
    private List<String> mStringTypes;
    private static final String logClassName = AuditVariableMetadata.class.getName();
    static final long serialVersionUID = -7292044011617931550L;

    private AuditVariableMetadata() {
        String[] initDate = new String[10];
        String[] initNumber = new String[30];
        String[] initString = new String[20];
        this.mDateNames = new ArrayList<String>(Arrays.asList(initDate));
        this.mDateTypes = new ArrayList<String>(Arrays.asList(initDate));
        this.mNumberNames = new ArrayList<String>(Arrays.asList(initNumber));
        this.mNumberTypes = new ArrayList<String>(Arrays.asList(initNumber));
        this.mNumberModelTypes = new ArrayList<String>(Arrays.asList(initNumber));
        this.mStringNames = new ArrayList<String>(Arrays.asList(initString));
        this.mStringTypes = new ArrayList<String>(Arrays.asList(initString));
        this.mStringModelTypes = new ArrayList<String>(Arrays.asList(initString));
        this.mAllRanges = new ArrayList<IAuditVariableRange>();
        this.mNextDate = 0;
        this.mNextNumber = 0;
        this.mNextString = 0;
    }

    public static IAuditVariableMetadata newInstance() {
        return new AuditVariableMetadata();
    }

    @Override
    public void addDateVariable(String name, String type) {
        String logMethodName = "addDateVariable";
        BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.DEBUG, logClassName, "addDateVariable", "Adding {" + name + "} to slot {" + (this.mNextDate + 1) + "}");
        this.mNextDate = this.addVariable(name, type, null, this.mNextDate, this.mDateNames, this.mDateTypes, null);
    }

    @Override
    public void addNumberVariable(String name, String type) {
        String logMethodName = "addNumberVariable";
        BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.DEBUG, logClassName, "addNumberVariable", "Adding {" + name + "} to slot {" + (this.mNextNumber + 1) + "}");
        this.mNextNumber = this.addVariable(name, type, null, this.mNextNumber, this.mNumberNames, this.mNumberTypes, null);
    }

    @Override
    public void addNumberVariable(String name, String type, String modelType) {
        String logMethodName = "addNumberVariable";
        BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.DEBUG, logClassName, "addNumberVariable", "Adding {" + name + "} to slot {" + (this.mNextNumber + 1) + "}");
        this.mNextNumber = this.addVariable(name, type, modelType, this.mNextNumber, this.mNumberNames, this.mNumberTypes, this.mNumberModelTypes);
    }

    @Override
    public void addStringVariable(String name, String type) {
        String logMethodName = "addStringVariable";
        BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.DEBUG, logClassName, "addStringVariable", "Adding {" + name + "} to slot {" + (this.mNextString + 1) + "}");
        this.mNextString = this.addVariable(name, type, null, this.mNextString, this.mStringNames, this.mStringTypes, null);
    }

    @Override
    public void addStringVariable(String name, String type, String modelType) {
        String logMethodName = "addStringVariable";
        BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.DEBUG, logClassName, "addStringVariable", "Adding {" + name + "} to slot {" + (this.mNextString + 1) + "}");
        this.mNextString = this.addVariable(name, type, modelType, this.mNextString, this.mStringNames, this.mStringTypes, this.mStringModelTypes);
    }

    @Override
    public void setCompositeDn(String mCompositeDn) {
        this.mCompositeDn = mCompositeDn;
    }

    @Override
    public String getCompositeDn() {
        return this.mCompositeDn;
    }

    @Override
    public List<String> getNumberNames() {
        return this.mNumberNames;
    }

    @Override
    public List<String> getNumberTypes() {
        return this.mNumberTypes;
    }

    @Override
    public List<String> getNumberModelTypes() {
        return this.mNumberModelTypes;
    }

    @Override
    public String getNumberName(int slot) {
        return this.mNumberNames.get(slot - 1);
    }

    @Override
    public String getNumberType(int slot) {
        return this.mNumberTypes.get(slot - 1);
    }

    @Override
    public String getNumberModelType(int slot) {
        return this.mNumberModelTypes.get(slot - 1);
    }

    @Override
    public List<String> getStringNames() {
        return this.mStringNames;
    }

    @Override
    public List<String> getStringTypes() {
        return this.mStringTypes;
    }

    @Override
    public List<String> getStringModelTypes() {
        return this.mStringModelTypes;
    }

    @Override
    public String getStringName(int slot) {
        return this.mStringNames.get(slot - 1);
    }

    @Override
    public String getStringType(int slot) {
        return this.mStringTypes.get(slot - 1);
    }

    @Override
    public String getStringModelType(int slot) {
        return this.mStringModelTypes.get(slot - 1);
    }

    @Override
    public List<String> getDateNames() {
        return this.mDateNames;
    }

    @Override
    public String getDateType(int slot) {
        return this.mDateTypes.get(slot - 1);
    }

    @Override
    public List<String> getDateTypes() {
        return this.mDateTypes;
    }

    @Override
    public void setDateNames(List<String> names) {
        this.mDateNames.clear();
        for (int i = 0; i < names.size(); ++i) {
            this.mDateNames.add(i, names.get(i));
        }
    }

    @Override
    public String getDateName(int slot) {
        return this.mDateNames.get(slot - 1);
    }

    @Override
    public void setDateTypes(List<String> types) {
        this.mDateTypes.clear();
        for (int i = 0; i < types.size(); ++i) {
            this.mDateTypes.add(i, types.get(i));
        }
    }

    @Override
    public void setDateName(int slot, String name) {
        this.mDateNames.set(slot - 1, name);
    }

    @Override
    public void setDateType(int slot, String type) {
        this.mDateTypes.set(slot - 1, type);
    }

    @Override
    public void setNumberName(int slot, String name) {
        this.mNumberNames.set(slot - 1, name);
    }

    @Override
    public void setNumberType(int slot, String type) {
        this.mNumberTypes.set(slot - 1, type);
    }

    @Override
    public void setNumberModelType(int slot, String modelType) {
        this.mNumberModelTypes.set(slot - 1, modelType);
    }

    @Override
    public void setNumberNames(List<String> names) {
        this.mNumberNames.clear();
        for (int i = 0; i < names.size(); ++i) {
            this.mNumberNames.add(i, names.get(i));
        }
    }

    @Override
    public void setNumberTypes(List<String> types) {
        this.mNumberTypes.clear();
        for (int i = 0; i < types.size(); ++i) {
            String type = types.get(i);
            if (type != null && type.contains(":")) {
                String[] tx = type.split(":");
                this.mNumberTypes.add(i, tx[0]);
                continue;
            }
            this.mNumberTypes.add(i, types.get(i));
        }
    }

    @Override
    public void setNumberModelTypes(List<String> modelTypes) {
        this.mNumberModelTypes.clear();
        for (int i = 0; i < modelTypes.size(); ++i) {
            this.mNumberModelTypes.add(i, modelTypes.get(i));
        }
    }

    @Override
    public void setStringName(int slot, String name) {
        this.mStringNames.set(slot - 1, name);
    }

    @Override
    public void setStringType(int slot, String type) {
        this.mStringTypes.set(slot - 1, type);
    }

    @Override
    public void setStringModelType(int slot, String modelType) {
        this.mStringModelTypes.set(slot - 1, modelType);
    }

    @Override
    public void setStringNames(List<String> names) {
        this.mStringNames.clear();
        for (int i = 0; i < names.size(); ++i) {
            this.mStringNames.add(i, names.get(i));
        }
    }

    @Override
    public void setStringTypes(List<String> types) {
        this.mStringTypes.clear();
        for (int i = 0; i < types.size(); ++i) {
            String type = types.get(i);
            if (type != null && type.contains(":")) {
                String[] tx = type.split(":");
                this.mStringTypes.add(i, tx[0]);
                continue;
            }
            this.mStringTypes.add(i, types.get(i));
        }
    }

    @Override
    public void setStringModelTypes(List<String> modelTypes) {
        this.mStringModelTypes.clear();
        for (int i = 0; i < modelTypes.size(); ++i) {
            this.mStringModelTypes.add(i, modelTypes.get(i));
        }
    }

    @Override
    public int getSlot(String name) {
        int result = this.getNumberNames().indexOf(name);
        if (result < 0 && (result = this.getStringNames().indexOf(name)) < 0) {
            result = this.getDateNames().indexOf(name);
        }
        return ++result;
    }

    @Override
    public void setDateMetadata(int slot, String name, String dataType, String metricsType) {
        this.setDateName(slot, name);
        this.setDateType(slot, metricsType);
    }

    @Override
    public void setNumberMetadata(int slot, String name, String dataType, String metricsType) {
        this.setNumberName(slot, name);
        this.setNumberType(slot, metricsType);
        this.setNumberModelType(slot, dataType);
    }

    @Override
    public void setStringMetadata(int slot, String name, String dataType, String metricsType) {
        this.setStringName(slot, name);
        this.setStringType(slot, metricsType);
        this.setStringModelType(slot, dataType);
    }

    @Override
    public String getDataType(String name) {
        int slot = this.getNumberNames().indexOf(name);
        if (slot > -1) {
            return "NUMBER";
        }
        slot = this.getStringNames().indexOf(name);
        if (slot > -1) {
            return "STRING";
        }
        slot = this.getDateNames().indexOf(name);
        if (slot > -1) {
            return "DATE";
        }
        return null;
    }

    @Override
    public void setAllRanges(List<IAuditVariableRange> allRanges) {
        this.mAllRanges = allRanges;
    }

    @Override
    public List<IAuditVariableRange> getRanges(String name) {
        ArrayList<IAuditVariableRange> result = new ArrayList<IAuditVariableRange>();
        for (IAuditVariableRange r : this.mAllRanges) {
            if (!r.getVarLabel().equals(name)) continue;
            result.add(r);
        }
        return result;
    }

    @Override
    public String getType(String name) {
        String result = null;
        int slot = this.getNumberNames().indexOf(name);
        result = slot < 0 ? ((slot = this.getStringNames().indexOf(name)) < 0 ? ((slot = this.getDateNames().indexOf(name)) < 0 ? "" : "DATE") : "STRING") : "NUMBER";
        return result;
    }

    @Override
    public void markAllAsUnused() {
        this.mNextString = this.markAsUnused(this.mStringNames);
        this.mNextNumber = this.markAsUnused(this.mNumberNames);
        this.mNextDate = this.markAsUnused(this.mDateNames);
    }

    private int addVariable(String name, String type, String modelType, int nextVar, List<String> names, List<String> types, List<String> modelTypes) {
        String logMethodName = "addVariable";
        BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.DEBUG, logClassName, "addVariable", "Adding {" + name + "} to slot {" + (nextVar + 1) + "}" + "\n" + "Current value: {" + names.get(nextVar) + ", " + types.get(nextVar) + "}");
        names.remove(nextVar);
        names.add(nextVar, name);
        types.remove(nextVar);
        types.add(nextVar, type);
        if (modelTypes != null) {
            modelTypes.remove(nextVar);
            modelTypes.add(nextVar, modelType);
        }
        return ++nextVar;
    }

    private int markAsUnused(List<String> names) {
        int nextVar = 0;
        ArrayList<String> result = new ArrayList<String>(names);
        names.clear();
        for (String name : result) {
            if (name != null) {
                ++nextVar;
                names.add(name.startsWith("#") ? name : "#" + name);
                continue;
            }
            names.add(name);
        }
        return nextVar;
    }
}

