/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancequery;

import java.io.Serializable;

public enum AuditInstanceOperation implements Serializable
{
    COMPONENT_DEPLOYED("COMPONENT_STATUS"),
    COMPONENT_RETIRED("COMPONENT_STATUS"),
    COMPONENT_SUSPENDED("COMPONENT_STATUS"),
    COMPONENT_UNDEPLOYED("COMPONENT_STATUS"),
    FLOW_NODE_IN("START"),
    FLOW_NODE_OUT("END"),
    FLOW_NODE_CANCELLED("END"),
    FLOW_NODE_MOVED("END"),
    FLOW_NODE_DATA_CHANGED("INTERMEDIATE"),
    INSTANCE_UPDATED("INTERMEDIATE"),
    INSTANCE_ABORTED("END"),
    INSTANCE_CREATED("START"),
    INSTANCE_FAULT("END"),
    INSTANCE_SYSTEM_FAULT("END"),
    INSTANCE_TERMINATED("END"),
    INSTANCE_SUSPENDED("END"),
    INSTANCE_RESUMED("END"),
    MEASUREMENT_COUNTER("INTERMEDIATE"),
    MEASUREMENT_START("START"),
    MEASUREMENT_START_STOP("INTERMEDIATE"),
    MEASUREMENT_STOP("END"),
    STALE_ABORTED("END"),
    STALE_COMPLETED("END"),
    BEFORE_INPUT_DATA_ASSOCIATION("BEFORE_INPUT_DATA_ASSOCIATION"),
    AFTER_INPUT_DATA_ASSOCIATION("AFTER_INPUT_DATA_ASSOCIATION"),
    BEFORE_OUTPUT_DATA_ASSOCIATION("BEFORE_OUTPUT_DATA_ASSOCIATION"),
    AFTER_OUTPUT_DATA_ASSOCIATION("AFTER_OUTPUT_DATA_ASSOCIATION"),
    BEFORE_ITERATION("BEFORE_ITERATION"),
    BEFORE_INSTANCE_EXECUTION("BEFORE_INSTANCE_EXECUTION"),
    AFTER_INSTANCE_EXECUTION("AFTER_INSTANCE_EXECUTION");

    private final String type;

    private AuditInstanceOperation(String type) {
        this.type = type;
    }

    public String getType(boolean isEntry) {
        String result = this.type;
        switch (this) {
            case INSTANCE_UPDATED: 
            case MEASUREMENT_COUNTER: 
            case MEASUREMENT_START_STOP: {
                result = this.type;
                break;
            }
            default: {
                return isEntry ? "START" : "END";
            }
        }
        return result;
    }
}

