/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancemanagement.model.impl.alterflow;

import java.util.Set;
import oracle.bpm.services.instancemanagement.model.IActivityPathInfo;
import oracle.bpm.services.instancemanagement.model.ILocationInfo;
import oracle.bpm.services.instancemanagement.model.IOpenActivityInfo;
import oracle.bpm.services.instancemanagement.model.IVariableItem;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.ActivityInfo;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.ActivityPathInfo;

public class OpenActivityInfo
extends ActivityInfo
implements IOpenActivityInfo {
    private Set<IVariableItem> attributes;
    private boolean isContainer;
    private ILocationInfo locationInfo;
    private ActivityPathInfo path;
    private static final long serialVersionUID = -1650553996660024339L;

    protected OpenActivityInfo(String id, String displayName, boolean isContainer, ActivityPathInfo path, ILocationInfo locationInfo, Set<IVariableItem> attributes) {
        super(id, displayName);
        this.path = path;
        this.attributes = attributes;
        this.locationInfo = locationInfo;
        this.isContainer = isContainer;
    }

    public static OpenActivityInfo create(String id, String displayName, boolean isContainer, ActivityPathInfo pathInfo, Set<IVariableItem> attributes) {
        if (pathInfo.getLength() < 1) {
            throw new IllegalArgumentException("The activity path must have at least one node.");
        }
        return new OpenActivityInfo(id, displayName, isContainer, ActivityPathInfo.removeLastNode(pathInfo), pathInfo.getEndLocation(), attributes);
    }

    @Override
    public IActivityPathInfo getPath() {
        return this.path;
    }

    @Override
    public ILocationInfo getLocation() {
        return this.locationInfo;
    }

    @Override
    public Boolean isContainerActivity() {
        return this.isContainer;
    }

    @Override
    public Iterable<IVariableItem> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getStringPath() {
        return this.path.getStringPath();
    }

    @Override
    public String getStringPath(String pathSeparator, Boolean useThreadIndicator) {
        return this.path.getStringPath(pathSeparator, useThreadIndicator);
    }

    @Override
    public String getProcessId() {
        return this.getLocation().getActivityInfo().getProcessId();
    }
}

