/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancemanagement.model.impl.alterflow;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bpm.services.instancemanagement.model.IActivityInfo;
import oracle.bpm.services.instancemanagement.model.ILocationInfo;
import oracle.bpm.services.instancemanagement.model.IVariableItem;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.ProcessInstanceInfo;

public class LocationInfo
implements ILocationInfo {
    private String absoluteScopeId;
    private IActivityInfo activityInfo;
    private Map<String, String> attributesByName;
    private ProcessInstanceInfo instance;
    private Boolean isRoot;
    private static final String LOOP_COUNTER = "loopCounter";
    private static String ROOT_ID = "PROCESS_SCOPE";
    private static LocationInfo ROOT_LOCATION_IMPL = new LocationInfo(ROOT_ID, null, true, Collections.<IVariableItem>emptySet(), null);
    public static ILocationInfo ROOT_LOCATION = ROOT_LOCATION_IMPL;
    private static final long serialVersionUID = -470328345833549304L;

    private LocationInfo(String absoluteScopeId, IActivityInfo activityInfo, Boolean isRoot, Set<IVariableItem> activityAttributes, ProcessInstanceInfo instance) {
        this.absoluteScopeId = absoluteScopeId;
        this.activityInfo = activityInfo;
        this.isRoot = isRoot;
        this.instance = instance;
        this.attributesByName = new HashMap<String, String>();
        if (activityAttributes != null) {
            for (IVariableItem attribute : activityAttributes) {
                this.attributesByName.put(attribute.getName(), attribute.getValue());
            }
        }
    }

    public static LocationInfo create(String absoluteScopeId, IActivityInfo activityInfo, Boolean isRoot, Set<IVariableItem> attributes, ProcessInstanceInfo instance) {
        return new LocationInfo(absoluteScopeId, activityInfo, isRoot, attributes, instance);
    }

    public static boolean isRoot(String absoluteScopeId) {
        return ROOT_LOCATION_IMPL.getAbsoluteScopeId().equals(absoluteScopeId);
    }

    @Override
    public IActivityInfo getActivityInfo() {
        return this.activityInfo;
    }

    @Override
    public Boolean isRoot() {
        return ROOT_ID.equals(this.absoluteScopeId) || this.isRoot != null && this.isRoot != false;
    }

    @Override
    public ProcessInstanceInfo getProcessInstanceInfo() {
        return this.instance;
    }

    public void markAsRoot() {
        this.isRoot = true;
    }

    public String getAbsoluteScopeId() {
        return this.absoluteScopeId;
    }

    public boolean isMultiInstance() {
        return this.getLoopCounter() != null;
    }

    public Object getLoopCounter() {
        return this.attributesByName.get(LOOP_COUNTER);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationInfo that = (LocationInfo)o;
        return !(this.absoluteScopeId == null ? that.absoluteScopeId != null : !this.absoluteScopeId.equals(that.absoluteScopeId));
    }

    public int hashCode() {
        return this.absoluteScopeId != null ? this.absoluteScopeId.hashCode() : 0;
    }
}

