/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancemanagement.model.impl.alterflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.bpm.services.instancemanagement.model.IActivityInfo;
import oracle.bpm.services.instancemanagement.model.IActivityPathInfo;
import oracle.bpm.services.instancemanagement.model.ILocationInfo;
import oracle.bpm.services.instancemanagement.model.IVariableItem;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.LocationInfo;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.ProcessInstanceInfo;

public class ActivityPathInfo
implements IActivityPathInfo {
    List<ILocationInfo> locations;
    private static final long serialVersionUID = 6186786196790773620L;

    private ActivityPathInfo(List<ILocationInfo> locations) {
        this.locations = new ArrayList<ILocationInfo>(locations);
    }

    private ActivityPathInfo(Builder builder) {
        this.locations = new ArrayList<ILocationInfo>(builder.locations);
        this.getStartLocation().markAsRoot();
    }

    public static ActivityPathInfo removeLastNode(ActivityPathInfo pathInfo) {
        int length = pathInfo.getLength();
        if (length < 2) {
            throw new IllegalArgumentException("A activity path must have at least two nodes: The process top-level scope and itself.");
        }
        return new ActivityPathInfo(pathInfo.locations.subList(0, length - 1));
    }

    @Override
    public Iterable<ILocationInfo> getLocations() {
        return Collections.unmodifiableCollection(this.locations);
    }

    @Override
    public int getLength() {
        return this.locations.size();
    }

    public LocationInfo getStartLocation() {
        return (LocationInfo)this.locations.get(0);
    }

    public LocationInfo getEndLocation() {
        return (LocationInfo)this.locations.get(this.locations.size() - 1);
    }

    public String getStringPath(String pathSeparator, Boolean useThreadIndicator) {
        Iterator<ILocationInfo> iterator = this.locations.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            LocationInfo locationInfo = (LocationInfo)iterator.next();
            IActivityInfo activityInfo = locationInfo.getActivityInfo();
            String label = locationInfo.isRoot() != false ? activityInfo.getId() : activityInfo.getDisplayName();
            sb.append(label);
            if (locationInfo.isMultiInstance()) {
                sb.append("[");
                sb.append(useThreadIndicator != false ? Integer.valueOf(locationInfo.getProcessInstanceInfo().getThread()) : locationInfo.getLoopCounter());
                sb.append("]");
            }
            if (!iterator.hasNext()) {
                return sb.toString();
            }
            sb.append(pathSeparator);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityPathInfo that = (ActivityPathInfo)o;
        return !(this.locations == null ? that.locations != null : !((Object)this.locations).equals(that.locations));
    }

    public int hashCode() {
        return this.locations != null ? ((Object)this.locations).hashCode() : 0;
    }

    public String getStringPath() {
        return this.getStringPath(" -> ", false);
    }

    public static class Builder {
        private List<ILocationInfo> locations = new ArrayList<ILocationInfo>();

        public Builder addLocationInfo(IActivityInfo activityInfo, String absoluteScopeId, Set<IVariableItem> attributes, ProcessInstanceInfo instance) {
            LocationInfo locationInfo = LocationInfo.create(absoluteScopeId, activityInfo, false, attributes, instance);
            this.locations.add(locationInfo);
            return this;
        }

        public ActivityPathInfo build() {
            return new ActivityPathInfo(this);
        }
    }
}

