/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.common.model;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CompositeDNModel
implements Serializable,
Comparable<CompositeDNModel> {
    private String applicationName;
    private String compositeDNString;
    private String compositeName;
    private String label;
    private String revision;
    private static final String COMPOSITE_DL = "/";
    private static final String REVISION_DL = "!";
    private static final String LABEL_DL = "\\*";
    protected static final char NAME_SEPARATOR = '/';
    protected static final char REVISION_SEPARATOR = '!';
    protected static final char LABEL_SEPARATOR = '*';
    protected static final Pattern compositeDLPattern = Pattern.compile("/");
    protected static final Pattern revisionDLPattern = Pattern.compile("!");
    protected static final Pattern labelDLPattern = Pattern.compile("\\*");
    private static final long serialVersionUID = 7099013553993854681L;

    private CompositeDNModel() {
    }

    public static CompositeDNModel buildCompositeDN(@NotNull String applicationName, @NotNull String compositeName, @NotNull String revision, @NotNull String label) {
        CompositeDNModel instance = new CompositeDNModel();
        instance.applicationName = applicationName;
        instance.compositeName = compositeName;
        instance.revision = revision;
        instance.label = label;
        instance.compositeDNString = CompositeDNModel.buildCompositeDNString(applicationName, compositeName, revision, label);
        return instance;
    }

    public static CompositeDNModel parseCompositeDN(String compositeDN) {
        String label;
        String revision;
        String[] parts = compositeDLPattern.split(compositeDN);
        if (parts.length != 2) {
            throw new IllegalArgumentException(compositeDN);
        }
        String applicationName = parts[0];
        String[] parts2 = revisionDLPattern.split(parts[1]);
        if (parts2.length != 2) {
            throw new IllegalArgumentException(compositeDN);
        }
        String compositeName = parts2[0];
        String[] parts3 = labelDLPattern.split(parts2[1]);
        if (parts3.length == 1) {
            revision = parts3[0];
            label = "";
        } else if (parts3.length == 2) {
            revision = parts3[0];
            label = parts3[1];
        } else {
            throw new IllegalArgumentException(compositeDN);
        }
        return CompositeDNModel.buildCompositeDN(applicationName, compositeName, revision, label);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CompositeDNModel parseConsolidatedCompositeDN(String consolidatedCompositeDN) {
        String compositeName;
        String revision = "";
        String label = "";
        String[] parts = compositeDLPattern.split(consolidatedCompositeDN);
        if (parts.length != 2) {
            throw new IllegalArgumentException(consolidatedCompositeDN);
        }
        String applicationName = parts[0];
        String[] parts2 = revisionDLPattern.split(parts[1]);
        if (parts2.length == 2) {
            compositeName = parts2[0];
            String[] parts3 = labelDLPattern.split(parts2[1]);
            if (parts3.length == 1) {
                revision = parts3[0];
                return CompositeDNModel.buildCompositeDN(applicationName, compositeName, revision, label);
            } else {
                if (parts3.length != 2) throw new IllegalArgumentException(consolidatedCompositeDN);
                revision = parts3[0];
                label = parts3[1];
            }
            return CompositeDNModel.buildCompositeDN(applicationName, compositeName, revision, label);
        } else {
            compositeName = parts2[0];
        }
        return CompositeDNModel.buildCompositeDN(applicationName, compositeName, revision, label);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getCompositeName() {
        return this.compositeName;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDNString() {
        return this.compositeDNString;
    }

    public String getConsolidatedDNString() {
        return this.getApplicationName() + '/' + this.getCompositeName();
    }

    public String toString() {
        return this.getDNString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeDNModel)) {
            return false;
        }
        CompositeDNModel dnModel = (CompositeDNModel)o;
        return this.getDNString().equals(dnModel.getDNString());
    }

    public int hashCode() {
        return this.getDNString().hashCode();
    }

    @Override
    public int compareTo(CompositeDNModel compositeDN) {
        if (compositeDN == null) {
            return 1;
        }
        int compare = this.compareApplication(compositeDN.getApplicationName());
        if (compare == 0 && (compare = this.compareComposite(compositeDN.getCompositeName())) == 0 && (compare = this.compareRevision(compositeDN.getRevision())) == 0) {
            compare = this.compareLabel(compositeDN.getLabel());
        }
        return compare;
    }

    public int compareWithoutLabelTo(CompositeDNModel compositeDN) {
        if (compositeDN == null) {
            return 1;
        }
        int compare = this.compareApplication(compositeDN.getApplicationName());
        if (compare == 0 && (compare = this.compareComposite(compositeDN.getCompositeName())) == 0) {
            compare = this.compareRevision(compositeDN.getRevision());
        }
        return compare;
    }

    public int compareConsolidatedDNTo(CompositeDNModel compositeDN) {
        if (compositeDN == null) {
            return 1;
        }
        int compare = this.compareApplication(compositeDN.getApplicationName());
        return compare != 0 ? compare : this.compareComposite(compositeDN.getCompositeName());
    }

    private static String buildCompositeDNString(String applicationName, String compositeName, String revision, String label) {
        String dnWithoutLabel = applicationName + '/' + compositeName + '!' + revision;
        return dnWithoutLabel + '*' + label;
    }

    private int compareApplication(String _applicationName) {
        if (this.applicationName != null && _applicationName != null) {
            return this.applicationName.compareTo(_applicationName);
        }
        return this.applicationName == null ? (_applicationName == null ? 0 : -1) : 1;
    }

    private int compareComposite(String _compositeName) {
        if (this.compositeName != null && _compositeName != null) {
            return this.compositeName.compareTo(_compositeName);
        }
        return this.compositeName == null ? (_compositeName == null ? 0 : -1) : 1;
    }

    private int compareRevision(String _revision) {
        if (this.revision != null && _revision != null) {
            return this.revision.compareTo(_revision);
        }
        return this.revision == null ? (_revision == null ? 0 : -1) : 1;
    }

    private int compareLabel(String _label) {
        if (this.label != null && _label != null) {
            return this.label.compareTo(_label);
        }
        return this.label == null ? (_label == null ? 0 : -1) : 1;
    }
}

