/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.services.common.model.ComponentDNModel;
import org.jetbrains.annotations.NotNull;

public class ComponentDNModelUtils {
    public static boolean containsProcess(@NotNull ComponentDNModel process, @NotNull Collection<ComponentDNModel> processes) {
        for (ComponentDNModel componentDN : processes) {
            if (process.compareConsolidatedDNTo(componentDN) != 0) continue;
            return true;
        }
        return false;
    }

    public static ComponentDNModel getCurrentProcessLabel(@NotNull ComponentDNModel processDN, @NotNull Collection<ComponentDNModel> processes) {
        if (processes.contains(processDN)) {
            return processDN;
        }
        for (ComponentDNModel componentDN : processes) {
            if (componentDN.compareWithoutLabelTo(processDN) != 0) continue;
            return componentDN;
        }
        return null;
    }

    public static ComponentDNModel getAnyVersion(@NotNull ComponentDNModel process, @NotNull Collection<ComponentDNModel> processes) {
        ComponentDNModel result = ComponentDNModelUtils.getCurrentProcessLabel(process, processes);
        if (result == null) {
            for (ComponentDNModel componentDN : processes) {
                if (process.compareConsolidatedDNTo(componentDN) != 0) continue;
                return componentDN;
            }
        }
        return null;
    }

    public static List<ComponentDNModel> getAllVersions(@NotNull ComponentDNModel process, @NotNull Collection<ComponentDNModel> processes) {
        ArrayList<ComponentDNModel> versions = new ArrayList<ComponentDNModel>();
        for (ComponentDNModel componentDN : processes) {
            if (process.compareConsolidatedDNTo(componentDN) != 0) continue;
            versions.add(componentDN);
        }
        return versions;
    }
}

